/*
	Project Name : Maxcv
	
	## Document Ready
		-- Scrolling Navigation
		-- Find all anchors
		-- Add Easing Effect
		-- Responsive Caret

	## Window Load
		-- Site Loader
*/

(function($) {

	"use strict"
	
	/* ## Document Ready - Handler for .ready() called */
	$(document).on("ready",function() {
		var width = $(window).width();
		var height = $(window).height();
		
		/* - Set Sticky Menu */
		if( $(".header-section").length ) {
			var menu_scroll = $(".header-section").offset().top;
			var sticky_menu = function() {
				var scroll_top = $(window).scrollTop();

				if ( scroll_top > menu_scroll ) {
					$(".header-section").addClass("navbar-fixed-top animated fadeInDown");
				} else {
					$(".header-section").removeClass("navbar-fixed-top animated fadeInDown"); 
				}
			};
			sticky_menu();
		}
		
		/* Event - Window Scroll */
		$( window ).on("scroll",function() {
			/* - Set Sticky Menu */
			if( $(".header-section").length ) {
				sticky_menu();
			}
		});		
		
		$('.navbar-nav li a[href*="#"]:not([href="#"]), .site-logo a[href*="#"]:not([href="#"])').on("click", function(e) {
	
			var $anchor = $(this);
			
			$("html, body").stop().animate({ scrollTop: $($anchor.attr("href")).offset().top - 49 }, 1500, "easeInOutExpo");
			
			e.preventDefault();
		});

		/* -- Responsive Caret */
		$(".ddl-switch").on("click", function() {
			var li = $(this).parent();
			if ( li.hasClass("ddl-active") || li.find(".ddl-active").length !== 0 || li.find(".dropdown-menu").is(":visible") ) {
				li.removeClass("ddl-active");
				li.children().find(".ddl-active").removeClass("ddl-active");
				li.children(".dropdown-menu").slideUp();
			}
			else {
				li.addClass("ddl-active");
				li.children(".dropdown-menu").slideDown();
			}
		});
		
		/* - Search */
		if($(".search-box").length){
			$("#search").on("click", function(){
				$(".search-box").addClass("active")
			});
			$(".search-box > span").on("click", function(){
				$(".search-box").removeClass("active")
			});
		}
	
	});	/* -- Document Ready /- */
	
	/* ## Window Load - Handler for .load() called */
	
	$(window).on("load",function() {
		/* -- Site Loader */
		if ( !$("html").is(".ie6, .ie7, .ie8") ) {
			$("#site-loader").delay(1000).fadeOut("slow");
		}
		else {
			$("#site-loader").css("display","none");
		}
		
	});
	
	if( $('.social').length ) {
		$('.social > li > a', this).on('click', function(e) {
			e.preventDefault();
			e.stopPropagation();

			var data_action = $(this).attr('data-action');
			var data_title = $(this).attr('data-title');
			var data_url = $(this).attr('data-url');

			if( data_action == 'twitter' ) {
				window.open('http://twitter.com/intent/tweet?status='+encodeURIComponent(data_url)+'+'+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'tumblr' ) {
				window.open('http://www.tumblr.com/submit?url='+encodeURIComponent(data_url)+'&amp;title='+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'vimeo' ) {
				window.open('http://www.vimeo.com/?url='+encodeURIComponent(data_url)+'&amp;title='+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'pinterest' ) {
				window.open('http://pinterest.com/pin/create/button/?url='+encodeURIComponent(data_url)+'&media=http://cdn2.wpbeginner.com/wp-content/uploads/2013/12/siteground-74x74.jpg&description='+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}	
		});
	}

})(jQuery);