<?php
/**
 * The Header for our theme
 *
 *
 * @package WordPress
 * @subpackage Maxcv
 * @since Maxcv 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> data-offset="200" data-spy="scroll" data-target=".ow-navigation">

	<?php
	$logo_style = $logo_img = $badge_img = "";

	$logo_style = get_theme_mod("select_logo", "img_logo");

	if( get_theme_mod("img_sitelogo") != "" ) {
		$logo_img = get_theme_mod("img_sitelogo");
	}
	else {
		$logo_img = MAXCV_IMGURI . "/logo.png";
	}

	if( get_theme_mod("img_badge") != "" ) {
		$badge_img = get_theme_mod("img_badge");
	}

	/* Page Metabox */
	$page_title = "";
	$page_subtitle = "";
	$page_banner = "";

	$header_image = "";

	$page_title = get_post_meta( get_the_ID(), 'maxcv_cf_page_title', true );
	$page_subtitle = get_post_meta( get_the_ID(), 'maxcv_cf_page_subtitle', true );
	$page_banner = get_post_meta( get_the_ID(), 'maxcv_cf_page_header_img', true );

	/* Page Banner */
	if( $page_banner != "" ) {
		$header_image = $page_banner;
	}
	else {
		$header_image = MAXCV_IMGURI . '/page-banner.jpg';
	}

	$loader_display = get_theme_mod("select_loader_option", "show");
	?>
	<div class="main-container">
		<?php
		if( $loader_display == "show") {
			?>
			<!-- Loader -->
			<div id="site-loader" class="load-complete">
				<div class="loader">
					<div class="loader-inner ball-clip-rotate">
						<div></div>
					</div>
				</div>
			</div><!-- Loader /- -->
			<?php
		} ?>

		<!-- Header Section -->
		<header class="container-fluid no-padding header-section<?php if(get_post_meta( get_the_ID(), 'maxcv_cf_header_bg', true ) == "on" ) { echo " header-section2"; } else {} ?>">
			<!-- Container -->
			<div class="container">		
				<!-- nav -->
				<nav class="navbar navbar-default ow-navigation">
					<div class="navbar-header">
						<button aria-controls="navbar" aria-expanded="false" data-target="#navbar" data-toggle="collapse" class="navbar-toggle collapsed" type="button">
							<span class="sr-only"><?php echo esc_html_e("Toggle navigation", "maxcv"); ?></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
						<?php
						if( $logo_style == "img_logo" && $logo_img != "" ) {
							?>
							<a class="navbar-brand image-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo_img ); ?>" alt=""/></a>
							<?php
						}
						elseif( $logo_style == "site_title" ) {
							?>
							<a class="navbar-brand site-title" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo get_bloginfo("title"); ?></a>
							<?php
						}
						else {
							?>
							<a class="navbar-brand custom-txt" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_attr( get_theme_mod("txt_custom_logo", "maxcv") ); ?></a>
							<?php
						} ?>
					</div>
					<!-- Menu Icon -->
					<div class="menu-icon">
						<div class="search">	
							<a href="#" id="search" title="Search"><i class="icon icon-Search"></i></a>
						</div>
					</div><!-- Menu Icon /- -->
					<div class="navbar-collapse collapse navbar-right" id="navbar">
						<?php
						if( has_nav_menu('ow_primary_nav') ) :
							wp_nav_menu( array(
								'theme_location' => 'ow_primary_nav',
								'container' => false,
								'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								'depth' => 10,
								'menu_class' => 'nav navbar-nav',
								'walker' => new maxcv_nav_walker
							));
						else :
						endif;
						?>
					</div><!--/.nav-collapse -->
				</nav><!-- nav /- -->
				<!-- Search Box -->
				<div class="search-box">
					<span><i class="icon_close"></i></span>
					<?php echo maxcv_custom_search_form(); ?>
				</div><!-- Search Box /- -->
			</div><!-- Container /- -->
		</header><!-- Header Section /- -->
		
		<?php
		if( $page_title != "disable" ) {
			?>
			<!-- Page Banner -->
			<div class="container-fluid no-padding page-banner"<?php if( $header_image != "" ) { ?> style="background-image: url(<?php echo esc_url( $header_image ); ?>);"<?php } ?>>
				<!-- Container -->
				<div class="container">
					<h3>
						<?php
						if( is_home() ) {
							esc_html_e( 'Blog', "maxcv" );
						}
						if( is_404() ) {
							esc_html_e( 'Error Page', "maxcv" );
						}
						elseif( is_search() ) {
							printf( esc_html__( 'Search Results for: %s', "maxcv" ), get_search_query() );
						}
						elseif( is_archive() ) {

							the_archive_title();

						}
						elseif( ! is_home() ) {
							the_title();
						}

						if( $page_subtitle != "" ) {
							?>
							<span class="page-subtitle">
								<?php echo esc_attr( $page_subtitle ); ?>
							</span>
							<?php
						}
						?>
					</h3>
					<div class="page-breadcrumb">
						<?php
							if( function_exists( 'bcn_display' ) ) {
								?>
								<div class="breadcrumb">
									<?php bcn_display(); ?>
								</div>
								<?php
							}
						?>
					</div>
				</div><!-- Container /- -->				
			</div><!-- Page Banner /- -->
			<?php
		} ?>