<?php
/**
 * Theme functions and definitions
 *
*/

/* Include Core */
require_once( trailingslashit( get_template_directory() ) . 'include/inc.php' );
require_once( trailingslashit( get_template_directory() ) . 'admin/inc.php' );

/* ************************************************************************ */

if( !function_exists('maxcv_get_the_ID') ) :

	function maxcv_get_the_ID() {

		if( class_exists( 'WooCommerce' ) && wc_get_page_id('shop') != "-1" && is_shop() ) {
			$post_id = wc_get_page_id('shop');
		}
		else {
			$post_id = get_the_ID();
		}

		return ! empty( $post_id ) ? $post_id : false;
	}
endif;

/* ************************************************************************ */

/* Redux Options */
if( !function_exists('maxcv_options') ) :

	function maxcv_options( $option, $arr = null ) {

		global $maxcv_option;

		if( $arr ) {

			if( isset( $maxcv_option[$option][$arr] ) ) {
				return $maxcv_option[$option][$arr];
			}
		}
		else {
			if( isset( $maxcv_option[$option] ) ) {
				return $maxcv_option[$option];
			}
		}
	}

endif;

/* ************************************************************************ */

if( ! function_exists('maxcv_allowhtmltags') ) :

	// Create function which allows more tags within comments
	function maxcv_allowhtmltags() {

		global $maxcv_allowedtags;

		$maxcv_allowedtags['h1'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['h2'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['h3'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['h4'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['h5'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['h6'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['em'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['i'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['li'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['button'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['ul'] = array( 'class' => array(), 'style' => array() );		
		$maxcv_allowedtags['ol'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['pre'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['blockquote'] = array( 'style' => array() );
		$maxcv_allowedtags['<!--more-->'] = array();
		$maxcv_allowedtags['p'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['del'] = array( 'class' => array(), 'style' => array() );
		$maxcv_allowedtags['span'] = array( 'class' => array(), 'style' => array() );
		//$maxcv_allowedtags['code'] = array( 'class' => array());
		$maxcv_allowedtags['strong'] = array( 'class'=> array(), 'style' => array() );
		$maxcv_allowedtags['ins'] = array( 'datetime' => array() );
		$maxcv_allowedtags['img'] = array( 'class' => array(), 'src' => array(), 'alt' => array(), 'style' => array() );
		$maxcv_allowedtags['a'] = array( 'class' => array(), 'href' => array(), 'target' => array(), 'title' => array(), 'style' => array() );

		return $maxcv_allowedtags;
	}
endif;

/* ************************************************************************ */

/**
 * Filters all menu item URLs for a #placeholder#.
 *
 * @param WP_Post[] $menu_items All of the nave menu items, sorted for display.
 *
 * @return WP_Post[] The menu items with any placeholders properly filled in.
 */
function maxcv_dynamic_menu_items( $menu_items ) {

    foreach ( $menu_items as $menu_item ) {

		$url = substr( $menu_item->url, 0, 1);

        if ( '#' === $url && !is_front_page() ) {
			$menu_item->url = trailingslashit( home_url() ) . $menu_item->url;
        }
    }

    return $menu_items;
}
add_filter( 'wp_nav_menu_objects', 'maxcv_dynamic_menu_items' );

/**
 * Set up the content width value based on the theme's design.
 *
 * @see ow_content_width()
 *
 * @since Maxcv 1.0
 */
if ( ! isset( $content_width ) ) { $content_width = 474; }


/**
 * Adjust content_width value for image attachment template.
 *
 * @since Maxcv 1.0
 */
if( !function_exists('maxcv_content_width') ) :

	function maxcv_content_width() {
		if ( is_attachment() && wp_attachment_is_image() ) { $GLOBALS['content_width'] = 810; }
	}
	add_action( 'template_redirect', 'maxcv_content_width' );
endif;

/* ************************************************************************ */

/**
 * Theme setup.
 *
 * Set up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support post thumbnails.
 *
 * @since Maxcv 1.0
 */
if( !function_exists('maxcv_theme_setup') ) :

	function maxcv_theme_setup() {

		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 */
		// wp-content/themes/maxcv-child/languages/en_US.mo
		load_theme_textdomain( "maxcv", get_stylesheet_directory() . '/languages' );

		/* load theme languages */
		load_theme_textdomain( "maxcv", get_template_directory() . '/languages' );

		/* Image Sizes */
		set_post_thumbnail_size( 825, 342, true ); /* Default Featured Image */

		add_image_size( 'maxcv_825_342', 825, 342, true ); // Gallery Post
		
		register_nav_menus( array(
			'ow_primary_nav'   => esc_html__( 'Primary menu', "maxcv" ),
		) );

		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		
		/* WooCommerce Theme Support */
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array( 'video', 'gallery', 'audio' ) );
	}
	add_action( 'after_setup_theme', 'maxcv_theme_setup' );
endif;

/* ************************************************************************ */

/* Google Font */
if( !function_exists('maxcv_fonts_url') ) :

	function maxcv_fonts_url() {

		$fonts_url = '';
		
		$raleway = _x( 'on', 'Raleway font: on or off', "maxcv" );
		$roboto = _x( 'on', 'Roboto font: on or off', "maxcv" );

		if ( 'off' !== $raleway || 'off' !== $roboto ) {

			$font_families = array();

			if ( 'off' !== $raleway ) {
				$font_families[] = 'Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
			}

			if ( 'off' !== $roboto ) {
				$font_families[] = 'Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i';
			}

			$query_args = array(
				'family' => urlencode( implode( '|', $font_families ) ),
				'subset' => urlencode( 'latin,latin-ext' ),
			);

			$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
		}

		return esc_url_raw( $fonts_url );
	}
endif;

/* ************************************************************************ */

/**
 * Enqueue scripts and styles for the front end.
 *
 * @since Maxcv 1.0
 */
if( !function_exists('maxcv_enqueue_scripts') ) :

	function maxcv_enqueue_scripts() {

		wp_enqueue_media();

		$theme = wp_get_theme("maxcv");
		$version = $theme['Version'];

		// load the Internet Explorer specific stylesheet.
	 	wp_enqueue_style( 'maxcv-ie', get_template_directory_uri() . '/css/ie.css');
		wp_style_add_data( 'maxcv-ie', 'conditional', 'lt IE 9' );

		// Load the html5 shiv.
		wp_enqueue_script( 'maxcv-respond.min', get_template_directory_uri() . '/js/html5/respond.min.js', array(), '3.7.3' );
		wp_script_add_data( 'maxcv-respond.min', 'conditional', 'lt IE 9' );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		/* Google Font */
		if( function_exists('maxcv_fonts_url') ) :
			wp_enqueue_style( 'maxcv-fonts', maxcv_fonts_url() );
		endif;

		wp_enqueue_style( 'dashicons' );

		/* Lib */
		wp_enqueue_style( 'maxcv-lib', get_template_directory_uri() . '/css/lib.css');
		wp_enqueue_script( 'maxcv-lib', get_template_directory_uri() . '/js/lib.js', array( 'jquery' ), $version, true );

		wp_add_inline_script( 'maxcv-lib', '
			var templateUrl = "'.esc_url( get_template_directory_uri() ).'";
			var WPAjaxUrl = "'.admin_url( 'admin-ajax.php' ).'";
		');

		/* Main Style */
		wp_enqueue_style( 'maxcv-plugins', get_template_directory_uri() . '/css/plugins.css');
		wp_enqueue_style( 'maxcv-navigationmenu', get_template_directory_uri() . '/css/navigation-menu.css');
		wp_enqueue_style( 'maxcv-wordpress', get_template_directory_uri() . '/css/wordpress.css');
		wp_enqueue_style( 'maxcv-woocommerce', get_template_directory_uri() . '/css/woocommerce.css');

		wp_enqueue_style( 'maxcv-main', get_template_directory_uri() . '/css/main.css');
		wp_enqueue_script( 'maxcv-main', get_template_directory_uri() . '/js/main.js', array( 'jquery' ), $version, true );
		wp_enqueue_style( 'maxcv-shortcode', get_template_directory_uri() . '/css/shortcode.css');	

		wp_enqueue_style( 'maxcv-stylesheet', get_template_directory_uri() . "/style.css" );
		wp_add_inline_style( 'maxcv-stylesheet', get_theme_mod('txtarea_customcss') );
	}
	add_action( 'wp_enqueue_scripts', 'maxcv_enqueue_scripts' );
endif;

/* ************************************************************************ */

/**
 * Do the work to pagination work on custom post types listing pages.
 *
 * @param array $query args array, as it works on wordpress (dont use it as string)
 * @return array set global $posts and return it as well
 */
if( ! function_exists("maxcv_wp_query") ) {

	function maxcv_wp_query( array $qry_args = array() ) {

		global $wp_query;

		wp_reset_query();

		$paged = get_query_var('paged') ? get_query_var('paged') : 1;

		$defaults = array(
			'paged'	=> $paged,
			'posts_per_page' => 10
		);

		$qry_args += $defaults;

		$wp_query = new WP_Query( $qry_args );
	}
}

/* ************************************************************************ */

/**
 * Extend the default WordPress body classes.
 *
 * @since Maxcv 1.0
 *
 * @param array $classes A list of existing body class values.
 * @return array The filtered body class list.
 */
if( !function_exists('maxcv_body_classes') ) :

	function maxcv_body_classes( $classes ) {

		if ( is_singular() && ! is_front_page() ) {
			$classes[] = "singular";
		}

		if( is_front_page() && !is_home() ) {
			$classes[] = "front-page";
		}

		if( is_404() ) {
			$classes[] = "404-template";
		}

		return $classes;
	}
	add_filter( 'body_class', 'maxcv_body_classes' );

endif;

/* ************************************************************************ */

/**
 * Extend the default WordPress post classes.
 *
 * Adds a post class to denote:
 * Non-password protected page with a post thumbnail.
 *
 * @since Maxcv 1.0
 *
 * @param array $classes A list of existing post class values.
 * @return array The filtered post class list.
 */
if( !function_exists('maxcv_post_classes') ) :

	function maxcv_post_classes( $classes ) {
		if ( ! is_attachment() && has_post_thumbnail() ) { $classes[] = 'has-post-thumbnail'; }
		return $classes;
	}
	add_filter( 'post_class', 'maxcv_post_classes' );

endif;
/* ************************************************************************ */

/**
 * Add a `screen-reader-text` class to the search form's submit button.
 *
 * @since Maxcv 1.0
 *
 * @param string $html Search form HTML.
 * @return string Modified search form HTML.
 */
if( ! function_exists( 'maxcv_search_form_modify' ) ) :

	function maxcv_search_form_modify( $html ) {
		$number = mt_rand(0,999);
		$html = '<form method="get" id="'.$number.'" class="searchform" action="' . home_url( '/' ) . '" >
		<div class="input-group">
		<input type="text" name="s" id="s-'.$number.'" placeholder="'.esc_html("SEARCH", "maxcv").'" class="form-control" required>
		<span class="input-group-btn">
			<button class="btn btn-default" type="submit"><i class="icon icon-Search"></i></button>
		</span>
		</div><!-- /input-group -->
		</form>';
		return $html;

	}
	add_filter( 'get_search_form', 'maxcv_search_form_modify' );
endif;

/* ************************************************************************ */

if( ! function_exists( 'maxcv_custom_search_form' ) ) :

	function maxcv_custom_search_form() {
		
		$html = '<form method="get" id="searchform_header" class="searchform" action="' . home_url( '/' ) . '" >
			<input type="text" name="s" id="s_header" placeholder="'.esc_html("Enter a keyword and press enter...", "maxcv").'" class="form-control" required>
			<span  class="input-group-btn">
				<button type="submit" title="Search" class="btn"><i class="fa fa-search" aria-hidden="true"></i></button>
			</span>
		</form>';
		return $html;
	}
endif;

/* ************************************************************************ */

if( class_exists("woocommerce") ) {

	/* Change number or products per row to 3 */
	if ( !function_exists('maxcv_loop_columns') ) :

		add_filter('loop_shop_columns', 'maxcv_loop_columns');

		function maxcv_loop_columns() {
			return 3; // 4 products per row
		}
	endif;
	
	if ( !function_exists('maxcv_related_products_args') ) :

		add_filter( 'woocommerce_output_related_products_args', 'maxcv_related_products_args' );

		function maxcv_related_products_args( $args ) {

			$args['posts_per_page'] = 3; // 4 related products
			$args['columns'] = 3; // arranged in 3 columns
			return $args;
			
		}
	endif;
}