<?php
/**
* The Template for displaying all single posts
*
* @package WordPress
* @subpackage Maxcv
* @since Maxcv 1.0
*/
get_header(); ?>

<main id="main" class="site-main">
	<?php
		$css = "";
		
		if(get_theme_mod("404_img") != "") {
			$css = " errorbg";
		}
		
		if( get_theme_mod("404_image") != "" ) {
			$error_img = get_theme_mod("404_image");
		}
		else {
			$error_img = MAXCV_IMGURI . "/404.jpg";
		}
	?>

	<!-- Error Section -->
	<div class="container-fluid no-padding error-section<?php echo esc_attr($css); ?>" <?php if(get_theme_mod("404_img")) { ?>style="background-image: url(<?php echo esc_url( get_theme_mod("404_img") ) ?>);" <?php } ?>>
		<div class="col-md-6 error-details">
			<div class="error-content">
				<h3><?php esc_html_e("Yep! It's Broken!","maxcv"); ?></h3>
				<h2><?php esc_html_e("404","maxcv"); ?></h2>
				<h4><?php esc_html_e("It's Ok, We can fix that.","maxcv"); ?></h4>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="Go Home"><?php esc_html_e('Go home',"maxcv"); ?></a>
			</div>
		</div>
		<div class="col-md-6">
			<img src="<?php echo esc_url($error_img) ?>" alt="" />
		</div>
	</div><!-- Error Section /- -->
	
</main><!-- .site-main -->

<?php get_footer(); ?>