<?php
/**
 * Template for displaying content of archive courses page.
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.1
 */

defined( 'ABSPATH' ) || exit;

get_header();

global $wp_query;
?>
	<div id="page-content" class="page-content">
		<div class="container">
			<div class="row">

				<?php Maxcoach_Templates::render_sidebar( 'left' ); ?>

				<div class="page-main-content">
					<div class="lp-archive-courses">

						<?php do_action( 'lp/template/archive-course/description' ); ?>

						<?php
						if ( have_posts() ) : ?>
							<?php
							/**
							 * @since 3.0.0
							 */
							do_action( 'learn-press/before-courses-loop' );

							LP()->template( 'course' )->begin_courses_loop();

							if ( LP_Settings_Courses::is_ajax_load_courses() && ! LP_Settings_Courses::is_no_load_ajax_first_courses() ) {
								echo '<div class="lp-archive-course-skeleton" style="width:100%">';
								echo '</div>';
							} else {

								while ( have_posts() ) :
									the_post();

									learn_press_get_template_part( 'content', 'course' );

								endwhile;

							}

							LP()->template( 'course' )->end_courses_loop();

							/**
							 * @since 3.0.0
							 */
							do_action( 'learn-press/after-courses-loop' );

							wp_reset_postdata();

						else:
							LP()->template( 'course' )->no_courses_found();
						endif; ?>
					</div>
				</div>

				<?php Maxcoach_Templates::render_sidebar( 'right' ); ?>

			</div>
		</div>
	</div>
<?php
get_footer();
