<?php
/**
 * Template for displaying form submit review.
 *
 * @theme-since   2.7.9
 * @theme-version 2.7.9
 */

if ( ! isset( $user ) || ! isset( $course_id ) ) {
	return;
}

if ( ! $user->has_course_status( $course_id, [ LP_COURSE_ENROLLED, LP_COURSE_FINISHED ] ) || learn_press_get_user_rate( $course_id ) ) {
	return;
}
?>

<button class="write-a-review"><?php _e( 'Write a review', 'maxcoach' ); ?></button>
<div class="course-review-wrapper" id="course-review">
	<div class="review-overlay"></div>

	<div class="review-form-wrap">
		<div id="review-form" class="review-form">
			<div class="form-overlay-review"></div>
			<a href="" class="close dashicons dashicons-no-alt"></a>
			<form>
				<h3>
					<?php esc_html_e( 'Write a review', 'maxcoach' ); ?>
				</h3>
				<ul class="review-fields">
					<?php do_action( 'learn_press_before_review_fields' ); ?>
					<li>
						<label><?php esc_html_e( 'Title', 'maxcoach' ); ?> <span class="required">*</span></label>
						<input type="text" name="review_title"/>
					</li>
					<li>
						<label><?php esc_html_e( 'Content', 'maxcoach' ); ?><span class="required">*</span></label>
						<textarea name="review_content"></textarea>
					</li>
					<li>
						<label><?php esc_html_e( 'Rating', 'maxcoach' ); ?><span class="required">*</span></label>
						<ul class="review-stars">
							<?php for ( $i = 1; $i <= 5; $i ++ ) { ?>
								<li class="review-title" title="<?php echo $i; ?>">
									<span class="dashicons dashicons-star-empty"></span></li>
							<?php } ?>
						</ul>
					</li>
					<?php do_action( 'learn_press_after_review_fields' ); ?>
					<li class="review-actions">
						<button type="button" class="submit-review"
						        data-id="<?php echo $course_id; ?>">
							<?php esc_html_e( 'Add review', 'maxcoach' ); ?>
						</button>
						<button type="button" class="close">
							<?php esc_html_e( 'Cancel', 'maxcoach' ); ?>
						</button>
						<span class="ajaxload"></span>
						<span class="error"></span>
						<?php wp_nonce_field( 'learn_press_course_review_' . get_the_ID(), 'review-nonce' ); ?>
						<input type="hidden" name="rating" value="0">
						<input type="hidden" name="lp-ajax" value="add_review">
						<input type="hidden" name="comment_post_ID" value="<?php echo get_the_ID(); ?>">
						<input type="hidden" name="empty_title" value="<?php echo __( 'Please enter the review title', 'maxcoach' ); ?>">
						<input type="hidden" name="empty_content" value="<?php echo __( 'Please enter the review content', 'maxcoach' ); ?>">
						<input type="hidden" name="empty_rating" value="<?php echo __( 'Please select your rating', 'maxcoach' ); ?>">
					</li>
				</ul>
			</form>
		</div>
	</div>
</div>
