<?php
/*
Plugin Name: Thememove Payment Add-ons for LearnPress
Description: Add stripe method for LearnPress
Author: Thememove
Version: 1.2.0
Author URI: https://thememove.com
Text Domain: thememove-payment
Domain Path: /languages/
Require_LP_Version: 4.0.0
*/

defined( 'ABSPATH' ) || exit;

define( 'TM_ADDON_PAYMENT_FILE', __FILE__ );
define( 'TM_ADDON_PAYMENT_VER', '1.2.0' );
define( 'TM_ADDON_PAYMENT_REQUIRE_VER', '4.0.0' );

if ( ! class_exists( 'TM_Addon_Payment_Entry' ) ) {
	class TM_Addon_Payment_Entry {
		public function __construct() {
			// Check if LearnPress plugin installed and activated.
			if ( ! class_exists( 'LearnPress' ) ) {
				add_action( 'admin_notices', array( $this, 'admin_notice_missing_main_plugin' ) );

				return;
			}

			add_action( 'plugins_loaded', [ $this, 'load_textdomain' ] );

			add_action( 'learn-press/ready', [ $this, 'load' ] );
			add_action( 'admin_notices', [ $this, 'admin_notices' ] );
		}

		public function load_textdomain() {
			load_plugin_textdomain( 'thememove-payment', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
		}

		/**
		 * Load addon
		 */
		public function load() {
			LP_Addon::load( 'TM_Addon_Stripe_Payment', 'inc/load.php', __FILE__ );
			remove_action( 'admin_notices', array( $this, 'admin_notices' ) );
		}

		/**
		 * Admin notice
		 */
		public function admin_notices() {
			?>
			<div class="error">
				<p><?php echo wp_kses(
						sprintf(
							__( '<strong>%s</strong> addon version %s requires %s version %s or higher is <strong>installed</strong> and <strong>activated</strong>.', 'thememove-payment' ),
							__( 'LearnPress Stripe Payment', 'thememove-payment' ),
							TM_ADDON_PAYMENT_VER,
							sprintf( '<a href="%s" target="_blank"><strong>%s</strong></a>', admin_url( 'plugin-install.php?tab=search&type=term&s=learnpress' ), __( 'LearnPress', 'thememove-payment' ) ),
							TM_ADDON_PAYMENT_REQUIRE_VER
						),
						array(
							'a'      => array(
								'href'  => array(),
								'blank' => array(),
							),
							'strong' => array(),
						)
					); ?>
				</p>
			</div>
			<?php
		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have LearnPress installed or activated.
		 *
		 * @since  1.0.1
		 *
		 * @access public
		 */
		public function admin_notice_missing_main_plugin() {

			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}

			$message = sprintf(
				esc_html__( '%1$sThememove Payment Add-ons for LearnPress%2$s requires %1$sLearnPress%2$s version 3.0.0 or higher is %1$sinstalled%2$s and %1$sactivated%2$s.', 'thememove-payment' ),
				'<strong>', '</strong>'
			);

			printf( '<div class="error"><p>%1$s</p></div>', $message );

		}
	}

	new TM_Addon_Payment_Entry();
}
