<?php
/**
 * Template for displaying Stripe payment form.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/addons/thememove-payment/form.php.
 *
 * @author   ThemeMove
 * @since    1.0.0
 * @version  1.2.0
 */

defined( 'ABSPATH' ) || exit();

$settings = LP()->settings();
?>
<p><?php echo $this->get_description(); ?></p>

<div id="learn-press-stripe-form" class="learn-press-stripe-form">
	<div class="row row-stripe-payment-card-number">
		<div class="col-md-12">
			<label><?php echo wp_kses( __( 'Card Number <span class="required">*</span>', 'thememove-payment' ), array( 'span' => array() ) ); ?></label>
			<input type="text" name="learn-press-stripe[card_number]" id="learn-press-stripe-payment-card-number"
			       maxlength="19" value="" autocomplete="cc-number" placeholder="•••• •••• •••• ••••"/>
		</div>
	</div>

	<div class="row row-stripe-payment-card-expiry">
		<div class="col-xs-8">
			<label><?php echo wp_kses( __( 'Expiry (MM/YY) <span class="required">*</span>', 'thememove-payment' ), array( 'span' => array() ) ); ?></label>
			<div class="row">
				<div class="col-xs-6">
					<select class="learn-press-stripe-expiry" name="learn-press-stripe[expiry_month]">
						<option value=01>01</option>
						<option value=02>02</option>
						<option value=03>03</option>
						<option value=04>04</option>
						<option value=05>05</option>
						<option value=06>06</option>
						<option value=07>07</option>
						<option value=08>08</option>
						<option value=09>09</option>
						<option value=10>10</option>
						<option value=11>11</option>
						<option value=12>12</option>
					</select>
				</div>
				<div class="col-xs-6">
					<select class="learn-press-stripe-expiry" name="learn-press-stripe[expiry_year]">
						<?php for ( $a = (int) gmdate( 'Y', time() ), $b = $a + 10, $i = $a; $i < $b; $i++ ) { ?>
							<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
						<?php } ?>
					</select>
				</div>
			</div>
		</div>
		<div class="col-xs-4">
			<label><?php echo wp_kses( __( 'Card Code <span class="required">*</span>', 'thememove-payment' ), array( 'span' => array() ) ); ?></label>
			<input type="text" name="learn-press-stripe[card_code]" id="learn-press-stripe-payment-card-code" value=""
			       placeholder="•••"/>
		</div>
	</div>
</div>

<?php if ( $settings->get( 'stripe.test_mode' ) == 'yes' ) { ?>
	<?php learn_press_display_message( esc_html__( 'Test mode is enabled. You can use the card number 4242424242424242 with any CVC and a valid expiration date for testing purpose.', 'thememove-payment' ), 'error' ); ?>
<?php } ?>
