;(
	function( $ ) {
		try {
			var stripe = Stripe( $thememovePayment.publish_key );
		} catch ( error ) {
			console.log( error );
			return;
		}

		var TM_Addon_Payment = {

			init: function() {
				window.addEventListener( 'hashchange', TM_Addon_Payment.onHashChange );
			},

			notice: function( $message ) {
				$( 'div.learnpress' ).find( '.learn-press-message.stripe' ).remove();
				$( 'div.learnpress' ).prepend( '<div class="learn-press-message stripe error message-error">' + $message + '</div>' );
			},

			onHashChange: function() {
				var partials = window.location.hash.match( /^#?confirm-(pi|si)-([^:]+):(.+)$/ );

				if ( ! partials || 4 > partials.length ) {
					return;
				}

				var type = partials[ 1 ];
				var intentClientSecret = partials[ 2 ];
				var redirectURL = decodeURIComponent( partials[ 3 ] );

				// Cleanup the URL
				window.location.hash = '';

				TM_Addon_Payment.openIntentModal( intentClientSecret, redirectURL, false, 'si' === type );
			},

			openIntentModal: function( intentClientSecret, redirectURL, alwaysRedirect, isSetupIntent ) {
				var buttonCheckout = $( '#learn-press-checkout-place-order' ),
				    formCheckout   = buttonCheckout.closest( 'form' );

				stripe[ isSetupIntent ? 'confirmCardSetup' : 'confirmCardPayment' ]( intentClientSecret )
					.then( function( response ) {
						if ( response.error ) {
							TM_Addon_Payment.notice( $thememovePayment.error_verify );

							throw response.error;
						}

						var intent = response[ isSetupIntent ? 'setupIntent' : 'paymentIntent' ];

						if ( 'requires_capture' !== intent.status && 'succeeded' !== intent.status ) {
							TM_Addon_Payment.notice( $thememovePayment.error_verify );

							buttonCheckout.html( lpCheckoutSettings.i18n_place_order );
							buttonCheckout.prop( 'disabled', false );
							return;
						}

						buttonCheckout.html( $thememovePayment.button_verify );

						formCheckout.addClass( 'lp-stripe_loading' );

						$.get( redirectURL, function( data ) {
							if ( data.result !== 'success' ) {
								if ( data.message ) {
									TM_Addon_Payment.notice( data.message );
								} else {
									TM_Addon_Payment.notice( 'ThemeMove Payment Stripe Js error.' );
								}
							}

							if ( data.redirect ) {
								window.location = data.redirect;
							}

							formCheckout.removeClass( 'lp-stripe_loading' );

							buttonCheckout.html( lpCheckoutSettings.i18n_place_order );
							buttonCheckout.prop( 'disabled', false );
						} );
					} )
					.catch( function( error ) {
						$( document.body ).trigger( 'stripeError', { error: error } );

						TM_Addon_Payment.notice( $thememovePayment.error_verify );

						// Report back to the server.
						buttonCheckout.html( $thememovePayment.button_verify );

						formCheckout.addClass( 'lp-stripe_loading' );

						$.get( redirectURL, function( data ) {
							if ( data.result !== 'success' ) {
								if ( data.message ) {
									TM_Addon_Payment.notice( data.message );
								} else {
									TM_Addon_Payment.notice( 'LearnPress Stripe Js error.' );
								}
							}

							if ( data.redirect ) {
								window.location = data.redirect;
							}

							formCheckout.removeClass( 'lp-stripe_loading' );

							buttonCheckout.html( lpCheckoutSettings.i18n_place_order );
							buttonCheckout.prop( 'disabled', false );
						} );
					} );
			},

		};

		$( document ).ready( function() {
			TM_Addon_Payment.init();
		} );
	}
)( jQuery );
