<?php
/**
 * Template Name:Contact
 */

get_header(); 

$map_type = tokopress_get_mod( 'tokopress_contact_map_type' );
$map_apikey = tokopress_get_mod( 'tokopress_contact_apikey' );

$latitude = tokopress_get_mod( 'tokopress_contact_lat' );
if ( !$latitude ) {
	$latitude = -6.903932;
}

$longitude = tokopress_get_mod( 'tokopress_contact_long' );
if ( !$longitude ) {
	$longitude = 107.610344;
}

$marker_title = tokopress_get_mod( 'tokopress_contact_marker_title' );
if ( !$marker_title ) {
	$marker_title = esc_html__( 'Marker Title', 'tokopress' );
}
$marker_title = str_replace( "\r\n", "<br/>", $marker_title );

$marker_content = tokopress_get_mod( 'tokopress_contact_marker_desc' );
if ( !$marker_content ) {
	$marker_content = esc_html__( 'Marker Content', 'tokopress' );
}
$marker_content = str_replace( "\r\n", "<br/>", $marker_content );

$map_zoom = tokopress_get_mod( 'tokopress_contact_map_zoom' );
if ( !$map_zoom ) {
	$map_zoom = 15;
}

$map_height = tokopress_get_mod( 'tokopress_contact_map_height' );
if ( !$map_height ) {
	$map_height = 500;
}

$map_address = tokopress_get_mod( 'tokopress_contact_address' );
if ( !$map_address ) {
	$map_address = 'Gedung Sate, Bandung, Indonesia';
}

?>

<?php if ( of_get_option( 'tokopress_page_header_style' ) == 'outer' ) get_template_part( 'block-page-header-outer' ); ?>

<?php do_action( 'tokopress_before_inner_content' ); ?>

	<section class="content-area" id="content">
		<div id="container">

		<?php if ( of_get_option( 'tokopress_page_header_style' ) != 'outer' ) get_template_part( 'block-page-header-inner' ); ?>

	    <div class="page-content contact-form">

			<?php if ( have_posts() ) : ?>

				<?php if( !of_get_option( 'tokopress_disable_contact_map' ) ) : ?>
				<div class="map-section map-block">

					<?php if( ( !$map_type || 'api' == $map_type ) && $map_apikey )  : ?>

						<script type="text/javascript">
							var map;
							var map_latitude = <?php echo esc_js( $latitude ); ?>;
							var map_longitude = <?php echo esc_js( $longitude ); ?>;
							var markerTitle = "<?php echo esc_js( $marker_title ); ?>";
							var markerContent = "<h1><?php echo esc_js( $marker_title ); ?></h1><p><?php echo esc_js( $marker_content ); ?></p>";

							jQuery(document).ready(function(){map=new GMaps({el:"#map",lat:map_latitude,lng:map_longitude,zoom:<?php echo intval($map_zoom); ?>,scrollwheel:false});map.addMarker({lat:map_latitude,lng:map_longitude,title:markerTitle,infoWindow:{content:markerContent}})})
						</script>

						<div id="map" style="background-color:rgb(229,227,223);height:<?php echo intval($map_height); ?>px;"></div>

					<?php elseif ( 'iframe' == $map_type ) : ?>

						<div id="map" style="background-color:rgb(229,227,223);height:<?php echo intval($map_height); ?>px;">
							<?php 
							$map_iframe = tokopress_get_mod( 'tokopress_contact_iframe' );
							if ( $map_iframe ) {
								preg_match_all('/<iframe[^>]+src="([^"]+)"/', $map_iframe, $map_iframe_match);
								if ( isset( $map_iframe_match[1][0] ) && $map_iframe_match[1][0] ) {
									?>
									<iframe width="100%" height="<?php echo intval($map_height); ?>" src="<?php echo esc_url( $map_iframe_match[1][0] ); ?>" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
									<?php
								}
							}
							?>
						</div>

					<?php else : ?>

						<?php if ( 'embed' != $map_type ) $map_address = '-6.903932,107.610344'; ?>
						<div id="map" style="background-color:rgb(229,227,223);height:<?php echo intval($map_height); ?>px;">
							<iframe width="100%" height="<?php echo intval($map_height); ?>" src="https://maps.google.com/maps?width=100%&amp;height=<?php echo intval($map_height); ?>&amp;q=<?php echo rawurlencode( trim( $map_address) ); ?>&amp;ie=UTF8&amp;t=&amp;z=<?php echo intval($map_zoom); ?>&amp;iwloc=near&amp;output=embed" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>
						</div>

					<?php endif; ?>

				</div>
				<?php endif; ?>

				<?php while ( have_posts() ) : the_post(); ?>
					<?php if( "" != get_the_content() ): ?>

						<div id="page-<?php echo get_the_ID(); ?>" class="page-area">

							<?php the_content(); ?>

						</div><!-- Content Block -->

					<?php endif; ?>
				<?php endwhile; ?>

				<?php
				if ( ! tokopress_get_mod( 'tokopress_disable_contact_form' ) ) {

					$args = array();

					$title = tokopress_get_mod( 'tokopress_contact_form_title' );
					if ( $title ) $args['title'] = $title;

					$sendcopy = tokopress_get_mod( 'tokopress_contact_form_sendcopy_hide' );
					if ( $sendcopy ) $args['sendcopy'] = 'no';

					$button_text = tokopress_get_mod( 'tokopress_contact_form_button' );
					if ( $button_text ) $args['button_text'] = $button_text;

					$email = tokopress_get_mod( 'tokopress_contact_form_email' );
					if ( $email ) $args['email'] = $email;

					$subject = tokopress_get_mod( 'tokopress_contact_form_subject' );
					if ( $subject ) $args['subject'] = $subject;

					echo tokopress_get_contact_form( $args );

				}
				?>
				<!-- Contact Form -->

			<?php else : ?>

				<?php get_template_part( 'content', '404' ); ?>

			<?php endif; ?>

	    </div>
		</div>
	</section>

<?php do_action( 'tokopress_after_inner_content' ); ?>

<?php get_footer(); ?>
