<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$store_user   = get_userdata( get_query_var( 'author' ) );
$store_info   = dokan_get_store_info( $store_user->ID );
$dokan_appearance = get_option( 'dokan_appearance' );
$profile_layout = empty( $dokan_appearance['store_header_template'] ) ? 'default' : $dokan_appearance['store_header_template'];

get_header( 'shop' );
?>

<?php do_action( 'tokopress_before_inner_content' ); ?>

    <?php if ( $profile_layout == 'default' && of_get_option( 'tokopress_dokan_shop_description' ) != 'no' && of_get_option( 'tokopress_dokan_store_header_style' ) != 'inner' ) : ?>
        <?php dokan_get_template_part( 'store-header' ); ?>
    <?php endif; ?>

    <?php do_action( 'woocommerce_before_main_content' ); ?>

    <div id="dokan-primary" class="dokan-single-store">
        <div id="dokan-content" class="store-page-wrap woocommerce" role="main">

            <?php if ( $profile_layout == 'default' && of_get_option( 'tokopress_dokan_shop_description' ) != 'no' && of_get_option( 'tokopress_dokan_store_header_style' ) == 'inner' ) : ?>
                <?php dokan_get_template_part( 'store-header' ); ?>
            <?php endif; ?>

            <?php if ( $profile_layout != 'default' && of_get_option( 'tokopress_dokan_shop_description' ) != 'no' ) : ?>
                <?php dokan_get_template_part( 'store-header-dokan' ); ?>
            <?php endif; ?>

            <?php if ( of_get_option( 'tokopress_dokan_shop_description' ) == 'no' && isset( $store_info['store_name'] ) && $store_info['store_name'] ) : ?>
                <div class="page-header page-header-inner">
                    <h1 class="page-title"><?php echo esc_html( $store_info['store_name'] ); ?></h1>
                    <?php woocommerce_breadcrumb(); ?>
                </div>
            <?php endif; ?>

            <?php dokan_get_template_part( 'store-tabs' ); ?>

            <?php do_action( 'dokan_store_profile_frame_after', $store_user, $store_info ); ?>

            <?php if ( have_posts() ) { ?>

                <?php do_action( 'woocommerce_before_shop_loop' ); ?>

                <div class="seller-items">

                    <?php woocommerce_product_loop_start(); ?>

                        <?php while ( have_posts() ) : the_post(); ?>

                            <?php if( "alt" == of_get_option( 'tokopress_wc_products_style' ) ) : ?>
                                <?php wc_get_template_part( 'content-product', 'alt' ); ?>
                            <?php else : ?>
                                <?php wc_get_template_part( 'content-product' ); ?>
                            <?php endif; ?>

                        <?php endwhile; // end of the loop. ?>

                    <?php woocommerce_product_loop_end(); ?>

                </div>

                <?php do_action( 'woocommerce_after_shop_loop' ); ?>

            <?php } else { ?>

                <p class="dokan-info"><?php _e( 'No products were found of this seller!', 'tokopress' ); ?></p>

            <?php } ?>
        </div>

    </div><!-- .dokan-single-store -->

    <?php do_action( 'woocommerce_after_main_content' ); ?>

    <?php if ( class_exists( 'Dokan_Store_Location' ) && dokan_get_option( 'enable_theme_store_sidebar', 'dokan_general', 'off' ) == 'off' ) : ?>
        <?php get_sidebar( 'dokan' ); ?>
    <?php else : ?>
        <?php if ( ! of_get_option( 'tokopress_wc_hide_products_sidebar' ) ) : ?>
            <?php get_sidebar( 'shop' ); ?>
        <?php endif; ?>
    <?php endif; ?>

<?php do_action( 'tokopress_after_inner_content' ); ?>

<?php get_footer( 'shop' ); ?>
