<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>
	
	<ul class="list-none detail-total-info gray">
		<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
		<li>
			<label><?php esc_html_e( 'Product Code:', 'manu' ); ?></label>
			<span class="title12 font-bold black">SUK01</span>
		</li>
		<?php endif; ?>
		<?php
			$s_class = '';
			$stock = $product->get_availability();
			if(is_array($stock)){
				if(!empty($stock['class'])) $s_class = $stock['class'];
				if(!empty($stock['availability'])) $stock = $stock['availability'];
				else {
					if($stock['class'] == 'in-stock') $stock = esc_html__("In stock","'manu");
					else $stock = esc_html__("Out of stock","'manu");
				}
		?>
		<li>
			<label><?php esc_html_e( 'Availability:', 'manu' ); ?></label>
			<span class="title12 font-bold black <?php echo esc_attr($s_class);?>"><?php echo esc_attr($stock);?></span>
		</li>
		<?php };?>
		<?php 
			$check_cat = wc_get_product_category_list($product->get_id());
			if($check_cat!=false):
		?>
		<li>
			<label><?php esc_html_e( 'Categories:', 'manu' ); ?></label>
			<?php echo wc_get_product_category_list($product->get_id(),'','','');?>
		</li>
		<?php endif;?>
		<?php 
			$check_tag = wc_get_product_tag_list($product->get_id());
			if($check_tag!=false):
		?>
		<li>
			<label><?php esc_html_e( 'Tags:', 'manu' ); ?></label>
			<?php echo wc_get_product_tag_list($product->get_id(),'','','');?>
		</li>
		<?php endif;?>
	</ul>
	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
