<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php
	/**
	 * woocommerce_before_single_product hook
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
	 
	global $product;
	$has_sidebar='';
	$check_sidebar = s7upf_check_sidebar();
	if($check_sidebar == true){
		$has_sidebar='detail-with-sidebar';
	}
?>
<div class="content-product-detail <?php echo esc_attr($has_sidebar);?>">
	<div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php 
			$style = s7upf_get_value_by_id('product_layout');
			switch($style){
				case 'sticky':
					?>
						<div class="detail-product detail-sticky fixed-detail-info">
							<?php s7upf_product_main_detail('sticky')?>
						</div>
					<?php
					break;
					
				default:
					?>
						<div class="detail-product">
							<?php s7upf_product_main_detail()?>		
						</div>
						<?php s7upf_product_tab_detail();?>	
					<?php
					break;
			}
		?>	
		<?php
			s7upf_single_relate_product();
			s7upf_single_upsell_product();
			s7upf_single_latest_product();
		?>	
	</div>
	<?php do_action( 'woocommerce_after_single_product' ); ?>
</div>
