<?php
/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $cross_sells ) : ?>

	<div class="cross-sells">
		<h2 class="title18 font-bold text-uppercase"><?php _e( 'You may be interested in&hellip;', 'manu' ) ?></h2>
		<div class="product-related-slider">
			<div class="wrap-item group-navi" data-itemscustom="[[0,1],[768,2]]" data-pagination="false" data-navigation="true">	
			<?php woocommerce_product_loop_start(); ?>

				<?php 
					$size = s7upf_get_option('product_size_thumb');
					if(empty($size)) $size = array(370,247);
					else $size = explode('x', $size);
					foreach ( $cross_sells as $cross_sell ) :
				?>
					
					<?php
						$post_object = get_post( $cross_sell->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );
						echo s7upf_product_item('','',$size);
					?>

				<?php endforeach; ?>

			<?php woocommerce_product_loop_end(); ?>
			</div>
		</div>
	</div>

<?php endif;

wp_reset_postdata();
