<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Price Filter Widget and related functions.
 *
 * Generates a range slider to filter products by price.
 *
 * @author   WooThemes
 * @category Widgets
 * @package  WooCommerce/Widgets
 * @version  2.3.0
 * @extends  WC_Widget
 */
if(class_exists('WC_Widget')){
	class S7upf_Widget_Price_Filter extends WC_Widget {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->widget_cssclass    = 'woocommerce s7upf_widget_price_filter';
			$this->widget_description = esc_html__( 'Display a slider to filter products in your store by price.', 'manu' );
			$this->widget_id          = 's7upf_price_filter';
			$this->widget_name        = esc_html__( 'SV Filter Products by Price', 'manu' );
			$this->settings           = array(
				'title'  => array(
					'type'  => 'text',
					'std'   => esc_html__( 'Price', 'manu' ),
					'label' => esc_html__( 'Title', 'manu' ),
				),
			);

			parent::__construct();
		}

		/**
		 * Output widget.
		 *
		 * @see WP_Widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance ) {
			global $wp, $wp_the_query;

			// Find min and max price in current result set.
			$min_max = s7upf_get_price_arange();
			$min = $min_max['min'];
			$max = $min_max['max'];

			$this->widget_start( $args, $instance );

			if ( '' === get_option( 'permalink_structure' ) ) {
				$form_action = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
			} else {
				$form_action = preg_replace( '%\/page/[0-9]+%', '', home_url( trailingslashit( $wp->request ) ) );
			}

			/**
			 * Adjust max if the store taxes are not displayed how they are stored.
			 * Min is left alone because the product may not be taxable.
			 * Kicks in when prices excluding tax are displayed including tax.
			 */

			$min_price = isset( $_GET['min_price'] ) ? esc_attr( $_GET['min_price'] ) : esc_attr( $min ) ;
			$max_price = isset( $_GET['max_price'] ) ? esc_attr( $_GET['max_price'] ) : esc_attr( $max ) ;

			echo '<form method="get" action="' . esc_url( $form_action ) . '">
				<div class="range-filter">
					<div class="price-range" data-symbol="'.esc_attr(get_woocommerce_currency_symbol()).'">
						<span class="min-price"></span>
						<span class="max-price"></span>
					</div>
					<div class="price-amount">
						<input type="hidden" name="min_price" value="' . esc_attr( $min_price ) . '" data-min="' . esc_attr( $min ) . '"/>
						<input type="hidden" name="max_price" value="' . esc_attr( $max_price ) . '" data-max="' . esc_attr( $max ) . '"/>
						<button type="submit" class="button">' . esc_html__( 'Filter', 'manu' ) . '</button>
						' . wc_query_string_form_fields( null, array( 'min_price', 'max_price' ), '', true ) . '
					</div>
				</div>
			</form>';

			$this->widget_end( $args );
		}

		/**
		 * Get filtered min price for current products.
		 * @return int
		 */
		protected function get_filtered_price() {
			global $wpdb, $wp_the_query;

			$args       = $wp_the_query->query_vars;
			$tax_query  = isset( $args['tax_query'] ) ? $args['tax_query'] : array();
			$meta_query = isset( $args['meta_query'] ) ? $args['meta_query'] : array();

			if ( ! is_post_type_archive( 'product' ) && ! empty( $args['taxonomy'] ) && ! empty( $args['term'] ) ) {
				$tax_query[] = array(
					'taxonomy' => $args['taxonomy'],
					'terms'    => array( $args['term'] ),
					'field'    => 'slug',
				);
			}

			foreach ( $meta_query + $tax_query as $key => $query ) {
				if ( ! empty( $query['price_filter'] ) || ! empty( $query['rating_filter'] ) ) {
					unset( $meta_query[ $key ] );
				}
			}

			$meta_query = new WP_Meta_Query( $meta_query );
			$tax_query  = new WP_Tax_Query( $tax_query );

			$meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
			$tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

			$sql  = "SELECT min( FLOOR( price_meta.meta_value ) ) as min_price, max( CEILING( price_meta.meta_value ) ) as max_price FROM {$wpdb->posts} ";
			$sql .= " LEFT JOIN {$wpdb->postmeta} as price_meta ON {$wpdb->posts}.ID = price_meta.post_id " . $tax_query_sql['join'] . $meta_query_sql['join'];
			$sql .= " 	WHERE {$wpdb->posts}.post_type IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_post_type', array( 'product' ) ) ) ) . "')
						AND {$wpdb->posts}.post_status = 'publish'
						AND price_meta.meta_key IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_meta_keys', array( '_price' ) ) ) ) . "')
						AND price_meta.meta_value > '' ";
			$sql .= $tax_query_sql['where'] . $meta_query_sql['where'];

			if ( $search = WC_Query::get_main_search_query_sql() ) {
				$sql .= ' AND ' . $search;
			}

			return $wpdb->get_row( $sql );
		}
	}
	function s7upf_register_Widget_Price_Filter() {
	    register_widget( 'S7upf_Widget_Price_Filter' );
	}
	add_action( 'widgets_init', 's7upf_register_Widget_Price_Filter' );
}
