<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 24/12/15
 * Time: 10:20 AM
 */
if(!class_exists('S7upf_Category_Fillter') && class_exists("woocommerce"))
{
    class S7upf_Category_Fillter extends WP_Widget {


        protected $default=array();

        static function _init()
        {
            add_action( 'widgets_init', array(__CLASS__,'_add_widget') );
        }

        static function _add_widget()
        {
            register_widget( 'S7upf_Category_Fillter' );
        }

        function __construct() {
            // Instantiate the parent object
            parent::__construct( false, esc_html__('SV Categories Filter','manu'),
                array( 'description' => esc_html__( 'Filter product shop page', 'manu' ), ));

            $this->default=array(
                'title' => '',
                'category' => array(),
            );
        }



        function widget( $args, $instance ) {
            // Widget output
            if(!is_single()){
                echo apply_filters('s7upf_output_content',$args['before_widget']);
                if ( ! empty( $instance['title'] ) ) {
                   echo apply_filters('s7upf_output_content',$args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
                }

                $instance=wp_parse_args($instance,$this->default);
                extract($instance);
                if(is_object($category)) $category = json_decode(json_encode($category), true);
                if(is_array($category) && !empty($category)){
                    echo        '<div class="widget-content">';                
						echo        '<ul class="list-category-toggle list-none">';                
							$cat_current = '';
							if(isset($_GET['product_cat'])) $cat_current = $_GET['product_cat'];
							if($cat_current != '') $cat_current = explode(',', $cat_current);
							else $cat_current = array();
							foreach ($category as $cat_slug) {
								$cat = get_term_by('slug',$cat_slug,'product_cat');
								$term_id = $cat->term_id;
								$list_sub = get_term_children( $term_id, 'product_cat');
								if(is_object($cat)){
									
									if(!empty($list_sub)){
										$class_sub = 'has-sub-cat';
										$toggle = '<span class="btn-toggle-cat"></span>';
									}else{
										$class_sub = '';
										$toggle = '';
									}
									if(in_array($cat->slug, $cat_current)) $current = 'current';
									else $current = '';
									echo        '<li class="'.$class_sub.'">
													<a href="'.esc_url(get_term_link($term_id,'product_cat')).'" class="'.$current.'"> '.$cat->name.'</a>'.$toggle;
													if(!empty($list_sub)){
														echo '<ul class="list-none">';
														foreach($list_sub as $sub_term){
															$term = get_term( $sub_term );
															echo '<li><a class="'.$current.'" href="'.esc_url(get_term_link($sub_term,'product_cat')).'">'.$term->name.'</a><span class="count">'.esc_attr($term->count).'</span></li>';
														}
														echo '</ul>';
													}
									echo		'</li>';
								}
							}
						echo      '</ul>';
                    echo      '</div>';
                }      
                echo apply_filters('s7upf_output_content',$args['after_widget']);
            }
        }

        function update( $new_instance, $old_instance ) {

            // Save widget options
            $instance=array();
            $instance=wp_parse_args($instance,$this->default);
            $new_instance=wp_parse_args($new_instance,$instance);

            return $new_instance;
        }

        function form( $instance ) {
            // Output admin widget options form

            $instance=wp_parse_args($instance,$this->default);
            extract($instance);
            if(is_object($category)) $category = json_decode(json_encode($category), true);
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ,'manu'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>
            <p>
                <label><?php esc_html_e( 'Categories:' ,'manu'); ?></label></br>
                <?php 
                $cats = get_terms('product_cat');
                if(is_array($cats) && !empty($cats)){
                    foreach ($cats as $cat) {
                        if(in_array($cat->slug, $category)) $checked = 'checked="checked"';
                        else $checked = '';
                        echo '<input '.$checked.' id="'.esc_attr($this->get_field_id( 'category' )).'" type="checkbox" name="'.esc_attr($this->get_field_name( 'category' )).'[]" value="'.$cat->slug.'"><span>'.$cat->name.'</span>';
                    }
                }
                else echo esc_html__("No any category.","'manu");
                ?>
            </p>            
        <?php
        }
    }

    S7upf_Category_Fillter::_init();

}
