<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 24/12/15
 * Time: 10:20 AM
 */
if(!class_exists('S7upf_Attribute_Filter') && class_exists("woocommerce"))
{
    class S7upf_Attribute_Filter extends WP_Widget {


        protected $default=array();

        static function _init()
        {
            add_action( 'widgets_init', array(__CLASS__,'_add_widget') );
        }

        static function _add_widget()
        {
            register_widget( 'S7upf_Attribute_Filter' );
        }

        function __construct() {
            // Instantiate the parent object
            parent::__construct( false, esc_html__('SV Attribute Filter','manu'),
                array( 'description' => esc_html__( 'Filter product shop page', 'manu' ), ));

            $this->default=array(
                'title' => '',
                'attribute' => '',
            );
        }



        function widget( $args, $instance ) {
            // Widget output
            if(!is_single()){
                echo apply_filters('s7upf_output_content',$args['before_widget']);
                if ( ! empty( $instance['title'] ) ) {
                   echo apply_filters('s7upf_output_content',$args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
                }
                $instance=wp_parse_args($instance,$this->default);
                extract($instance);
				$attribute_taxonomies = wc_get_attribute_taxonomies();
				foreach($attribute_taxonomies as $key => $value){
					$attr_name = $value->attribute_name;
					if($attr_name == $attribute ){
						$attr_type = $value->attribute_type;
					}
				}
				if($attr_type == 'color'){
					echo    '<div class="widget-content"><ul class="list-none list-attr list-attr-color">';                
					$terms = get_terms("pa_".$attribute);
					$term_current = '';
					if(isset($_GET['filter_'.$attribute])) $term_current = $_GET['filter_'.$attribute];
					if($term_current != '') $term_current = explode(',', $term_current);
					else $term_current = array();  
					if(is_array($terms)){
						$class_color = '';
						foreach ($terms as $term) {
							if(in_array($term->slug, $term_current)){
								$active = 'active';
							}else {
								$active = '';
							}
							$color_id = get_term_meta( $term->term_id,'', 'term-color', true);
							$class_color = S7upf_Assets::build_css('background:'.$color_id['color'][0].';');
							if(is_object($term)){
								if(in_array($term->slug, $term_current)) $active = 'active';
								else $active = '';
								echo    '<li><a class="'.esc_attr($active).'" href="'.esc_url(s7upf_get_filter_url('filter_'.$attribute,$term->slug)).'"><i class="'.esc_attr($class_color).'"></i>'.$term->name.'<span class="count">'.$term->count.'</span></a></li>';
							}
						}
					}
					echo    '</ul></div>';
				}
				if($attr_type == 'image'){
					echo    '<div class="widget-content"><ul class="list-none list-attr list-attr-image">';                
					$terms = get_terms("pa_".$attribute);
					$term_current = '';
					if(isset($_GET['filter_'.$attribute])) $term_current = $_GET['filter_'.$attribute];
					if($term_current != '') $term_current = explode(',', $term_current);
					else $term_current = array();  
					if(is_array($terms)){
						foreach ($terms as $term) {
							if(in_array($term->slug, $term_current)){
								$active = 'active';
							}else {
								$active = '';
							}
							$image_id = get_term_meta( $term->term_id,'', 'term-image', true);
							if(is_object($term)){
								if(in_array($term->slug, $term_current)) $active = 'active';
								else $active = '';
								echo    '<li><a class="'.esc_attr($active).'" href="'.esc_url(s7upf_get_filter_url('filter_'.$attribute,$term->slug)).'"><img src="'.$image_id['image'][0].'">'.$term->name.'<span class="count">'.$term->count.'</span></a></li>';
							}
						}
					}
					echo    '</ul></div>'; 
				}
				if($attr_type == 'label'){
					echo    '<div class="widget-content"><ul class="list-none list-attr list-attr-label">';                
					$terms = get_terms("pa_".$attribute);
					$term_current = '';
					if(isset($_GET['filter_'.$attribute])) $term_current = $_GET['filter_'.$attribute];
					if($term_current != '') $term_current = explode(',', $term_current);
					else $term_current = array();  
					if(is_array($terms)){
						foreach ($terms as $term) {
							if(in_array($term->slug, $term_current)){
								$active = 'active';
							}else {
								$active = '';
							}
							if(is_object($term)){
								if(in_array($term->slug, $term_current)) $active = 'active';
								else $active = '';
								echo    '<li><a class="'.esc_attr($active).'" href="'.esc_url(s7upf_get_filter_url('filter_'.$attribute,$term->slug)).'">'.$term->name.'<span class="count">'.$term->count.'</span></a></li>';
							}
						}
					}
					echo    '</ul></div>';
				}
				if($attr_type == 'text'){
					echo    '<div class="widget-content"><ul class="list-none list-attr list-attr-text">';                
					$terms = get_terms("pa_".$attribute);
					$term_current = '';
					if(isset($_GET['filter_'.$attribute])) $term_current = $_GET['filter_'.$attribute];
					if($term_current != '') $term_current = explode(',', $term_current);
					else $term_current = array();  
					if(is_array($terms)){
						foreach ($terms as $term) {
							if(in_array($term->slug, $term_current)){
								$active = 'active';
							}else {
								$active = '';
							}
							if(is_object($term)){
								if(in_array($term->slug, $term_current)) $active = 'active';
								else $active = '';
								echo    '<li><a class="'.esc_attr($active).'" href="'.esc_url(s7upf_get_filter_url('filter_'.$attribute,$term->slug)).'">'.$term->name.'<span class="count">'.$term->count.'</span></a></li>';
							}
						}
					}
					echo    '</ul></div>';  
				}
                echo apply_filters('s7upf_output_content',$args['after_widget']);
            }
        }

        function update( $new_instance, $old_instance ) {

            // Save widget options
            $instance=array();
            $instance=wp_parse_args($instance,$this->default);
            $new_instance=wp_parse_args($new_instance,$instance);

            return $new_instance;
        }

        function form( $instance ) {
            // Output admin widget options form

            $instance=wp_parse_args($instance,$this->default);
            extract($instance);
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ,'manu'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>            
            <p>
                <label><?php esc_html_e( 'Attribute:' ,'manu'); ?></label></br>
                <select id="<?php echo esc_attr($this->get_field_id( 'attribute' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'attribute' )); ?>">
                    <?php 
                    global $wpdb;
                    $attribute_taxonomies = wc_get_attribute_taxonomies();
                    if(!empty($attribute_taxonomies)){
                        foreach($attribute_taxonomies as $attr){
                            $selected=selected($attr->attribute_name,$attribute,false);
                            echo "<option {$selected} value='{$attr->attribute_name}'>{$attr->attribute_label}</option>";
                        }
                    }
                    else echo esc_html__("No any attribute.","'manu");
                    ?>
                </select>                
            </p>
        <?php
        }
    }

    S7upf_Attribute_Filter::_init();

}
