<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('s7upf_vc_search_form'))
{
    function s7upf_vc_search_form($attr)
    {
        $html = $label_sm = '';
        extract(shortcode_atts(array(
            'style'             => 'product-search',
            'placeholder'       => '',
            'live_search'       => 'on',
            'cats'              => '',
            'show_cats'         => 'no',
			'class_extra'   	=> '',
        ),$attr));
        if(!empty($cats)) $cats = str_replace(' ', '', $cats);
        ob_start();
        $search_val = get_search_query();
		if($style=="product-search"){
            ?>
			<div class="smart-search show-cat-<?php echo esc_attr($show_cats)?> live-search-<?php echo esc_attr($live_search)?> <?php echo esc_attr($class_extra);?>">
				<form class="smart-search-form form-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
					<?php if($show_cats == 'yes'):?>
					<div class="select-category select-box">
						<select name="product_cat">
							<option value=''><?php echo esc_html__( 'All Categories','manu' ); ?></option>
							<?php 
								if(!empty($cats)){
									$custom_list = explode(",",$cats);
									foreach ($custom_list as $key => $cat) {
										$term = get_term_by( 'slug',$cat, 'product_cat' );
										if(!empty($term) && is_object($term)){
											if(!empty($term) && is_object($term)){
												echo '<option value="'.$term->slug.'">'.$term->name.'</option>';
											}
										}
									}
								}
								else{
									$product_cat_list = get_terms('product_cat');
									if(is_array($product_cat_list) && !empty($product_cat_list)){
										foreach ($product_cat_list as $cat) {
											echo '<option value="'.$term->slug.'">'.$term->name.'</option>';
										}
									}
								}
							?>
						</select> 
					</div>
					<?php endif;?>
					<input class="smoke" name="s" type="text" value="<?php echo esc_attr($search_val);?>" placeholder="<?php echo esc_attr($placeholder)?>">
					<input type="hidden" name="post_type" value="product" />
					<input type="submit" class="white text-uppercase bg-color" value="<?php esc_html_e('Search','manu')?>">
					<div class="list-product-search">
						<p class="text-center"><?php esc_html_e("Please enter key search to display results.","'manu")?></p>
					</div>
				</form>
			</div>
			<?php
		}	
		if($style=="general-search"){
			?>
			<form class="search-hover <?php echo esc_attr($class_extra);?>" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
				<input type="text" name="s" value="<?php echo esc_attr($search_val);?>"  placeholder="<?php echo esc_attr($placeholder)?>">
				<div class="submit-form">
					<input type="submit" value="">
				</div>
			</form>	
			<?php
		}
		if($style=="character-search"){
			?>
			<div class="footer-alphabet text-uppercase <?php echo esc_attr($class_extra);?>">
				<form action="<?php echo esc_url( home_url( '/'  ) ); ?>" class="search-character">
					<input type="text" class="hidden" name="s" value="<?php echo esc_attr($search_val);?>">
					<a href="#" class="black">#</a>
					<a href="#" class="black">A</a>
					<a href="#" class="black">B</a>
					<a href="#" class="black">C</a>
					<a href="#" class="black">D</a>
					<a href="#" class="black">E</a>
					<a href="#" class="black">F</a>
					<a href="#" class="black">G</a>
					<a href="#" class="black">H</a>
					<a href="#" class="black">I</a>
					<a href="#" class="black">J</a>
					<a href="#" class="black">K</a>
					<a href="#" class="black">L</a>
					<a href="#" class="black">M</a>
					<a href="#" class="black">N</a>
					<a href="#" class="black">O</a>
					<a href="#" class="black">P</a>
					<a href="#" class="black">Q</a>
					<a href="#" class="black">R</a>
					<a href="#" class="black">S</a>
					<a href="#" class="black">T</a>
					<a href="#" class="black">U</a>
					<a href="#" class="black">V</a>
					<a href="#" class="black">W</a>
					<a href="#" class="black">X</a>
					<a href="#" class="black">Y</a>
					<a href="#" class="black">Z</a>
				</form>
			</div>
			<?php
		}
        $html .=    ob_get_clean();
        return $html;
    }
}

stp_reg_shortcode('sv_search_form','s7upf_vc_search_form');
$check_add = '';
if(isset($_GET['return'])) $check_add = $_GET['return'];
if(empty($check_add)) add_action( 'vc_before_init_base','sv_add_admin_search',10,100 );
if ( ! function_exists( 'sv_add_admin_search' ) ) {
    function sv_add_admin_search(){
        vc_map( array(
            "name"      => esc_html__("Manu Search", 'manu'),
            "base"      => "sv_search_form",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Style",'manu'),
                    "param_name" => "style",
                    "value"     => array(
                        esc_html__("Product Search",'manu')   => 'product-search',
                        esc_html__("General Search",'manu')   => 'general-search',
                        esc_html__("Character Search",'manu')   => 'character-search',
                    )
                ),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "heading" => esc_html__("Place holder input",'manu'),
                    "param_name" => "placeholder",
					"dependency"    =>array(
						'element'   =>'style',
						'value'     =>array('product-search','general-search')
					),
                ),
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Show Categories",'manu'),
                    "param_name" => "show_cats",
                    "value"     => array(
                        esc_html__("No",'manu')   => 'no',
                        esc_html__("Yes",'manu')  => 'yes',
					),
					"dependency"    =>array(
						'element'   =>'style',
						'value'     =>array('product-search')
					),
                ),
                array(
                    'holder'     => 'div',
                    'heading'     => esc_html__( 'Product Categories', 'manu' ),
                    'type'        => 'autocomplete',
                    'param_name'  => 'cats',
                    'settings' => array(
                        'multiple' => true,
                        'sortable' => true,
                        'values' => s7upf_get_product_taxonomy(),
                    ),
                    'save_always' => true,
                    'description' => esc_html__( 'List of product categories', 'manu' ),
					"dependency"    =>array(
						'element'   =>'show_cats',
						'value'     =>array('yes')
					),
                ),
                array(
                    "type" => "dropdown",
                    "heading" => esc_html__("Live Search",'manu'),
                    "param_name" => "live_search",
                    "value"     => array(
                        esc_html__("Yes",'manu')   => 'on',
                        esc_html__("No",'manu')   => 'off',
                    ),
					"dependency"    =>array(
						'element'   =>'style',
						'value'     =>array('product-search')
					),
                ),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Class Extra', 'manu' ),
					'param_name'  => 'class_extra',
				),
            )
        ));
    }
}
add_action( 'wp_ajax_live_search', 's7upf_live_search' );
add_action( 'wp_ajax_nopriv_live_search', 's7upf_live_search' );
if(!function_exists('s7upf_live_search')){
    function s7upf_live_search() {
        $key = $_POST['key'];
        $cat = $_POST['cat'];
        $post_type = $_POST['post_type'];
        $trim_key = trim($key);
        $args = array(
            'post_type' => $post_type,
            's'         => $key,
		);
        if(!empty($cat)) {
            $args['tax_query'][]=array(
                'taxonomy'  =>  'product_cat',
                'field'     =>  'slug',
                'terms'     =>  $cat
            );
        }
        $query = new WP_Query( $args );
        if( $query->have_posts() && !empty($key) && !empty($trim_key)){
            while ( $query->have_posts() ) : $query->the_post();
                global $product;
                echo    '<div class="item-search-pro table-custom">
                            <div class="search-ajax-thumb product-thumb">
                                <a href="'.esc_url(get_the_permalink()).'" class="product-thumb-link">
                                    '.get_the_post_thumbnail(get_the_ID(),array(70,70)).'
                                </a>
                            </div>
							<div class="product-info">
								<div class="search-ajax-title"><h3 class="title14 product-title"><a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a></h3></div>
								<div class="search-ajax-price">
									'.s7upf_get_price_html().'
								</div>
							</div>
                        </div>';
            endwhile;
        }
        else{
            echo '<p class="text-center">'.esc_html__("No any results with this keyword.","'manu").'</p>';
        }
        wp_reset_postdata();
    }
}