<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */
if(class_exists("woocommerce")){
    if(!function_exists('s7upf_vc_product_tab'))
    {
        function s7upf_vc_product_tab($attr, $content = false)
        {
            $html = '';
            extract(shortcode_atts(array(
                'style'             => '',
                'title'             => '',
                'cats'              => '',
                'product_type'      => '',
				'product_style'     => '',
				'tab_style'         => '',
				'content_style'     => 'slider',
                'number'            => '',
                'order_by'          => 'date',
                'order'             => 'DESC',
                'itemscustom'       => '',
				'control_nav'       => '',
				'autoplay'          => 'false',
				'pagination'        => 'false',
				'navigation'        => 'false',
                'size'              => '',
                'row'               => '1',
                'class_extra'       => '',
            ),$attr));
            if(empty($size)){
				$size = 'full';
			}else{
				$size = explode('x', $size);
			}
			$row = (int)$row;
            switch($style){
				case 'category':
					$pre = uniqid();
					$custom_list = explode(",",$cats);
					$html .= 	'<div class="cat-tab-default '.esc_attr($class_extra).'">';
					
					$html .=		'<ul class="list-inline-block '.esc_attr($tab_style).'">';
										foreach($custom_list as $key=>$tab_title){
											if($key==0){
												$active_class = 'active';
											}else{
												$active_class = '';
											}
											$tab_title = trim($tab_title);
											$term = get_term_by('slug',$tab_title,'product_cat'); 
											$title = $term->name;
											$html .= '<li class="'.$active_class.'"><a href="#'.$pre.$key.'" data-toggle="tab">'.$title.'</a></li>';
										}
					$html .=	    '</ul>';
					
					$html .=        '<div class="tab-content">';
							
							foreach($custom_list as $key=>$tab_tax){
								if($key == 0) {
									$active_class = 'active';
								}else {
									$active_class = '';
								}
								$tab_tax = trim($tab_tax);
								$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
								$args=array(
									'post_type'         => 'product',
									'posts_per_page'    => $number,
									'orderby'           => $order_by,
									'order'             => $order,
									'paged'             => $paged,
								);
								$args['tax_query'][]=array(
									'taxonomy'=>'product_cat',
									'field'=>'slug',
									'terms'=> $tab_tax
								);
								switch ($product_type) {
									case 'bestsell':
										$args['meta_key'] = 'total_sales';
										$args['orderby'] = 'meta_value_num';
										break;

									case 'toprate':
										unset($args['meta_key']);
										$args['meta_key'] = '_wc_average_rating';
										$args['orderby'] = 'meta_value_num';
										$args['meta_query'] = WC()->query->get_meta_query();
										$args['tax_query'][] = WC()->query->get_tax_query();
										break;
									
									case 'mostview':
										unset($args['no_found_rows']);
										unset($args['meta_query']);
										unset($args['tax_query']);
										$args['meta_key'] = 'post_views';
										$args['orderby'] = 'meta_value_num';
										break;

									case 'featured':
										$args['orderby'] = $order_by;
										$args['tax_query'][] = array(
											'taxonomy' => 'product_visibility',
											'field'    => 'name',
											'terms'    => 'featured',
											'operator' => 'IN',
										);
										break;

									case 'trendding':
										unset($args['meta_key']);
										unset($args['meta_value']);
										$args['meta_query'][] = array(
											'key'     => 'trending_product',
											'value'   => 'on',
											'compare' => '=',
										);
										break;
									
									case 'onsale':
										unset($args['meta_query']);
										unset($args['meta_key']);
										unset($args['meta_value']);
										$args['meta_query']['relation']= 'OR';
										$args['meta_query'][]=array(
											'key'   => '_sale_price',
											'value' => 0,
											'compare' => '>',                
											'type'          => 'numeric'
										);
										$args['meta_query'][]=array(
											'key'   => '_min_variation_sale_price',
											'value' => 0,
											'compare' => '>',                
											'type'          => 'numeric'
										);
										break;
									
									default:
										$args['orderby'] = 'date';
										break;
								}
								$product_query = new WP_Query($args);
								$max_page = $product_query->max_num_pages;
								$count_query = $product_query->post_count;
								$html .= '<div id="'.$pre.$key.'" class="tab-pane '.$active_class.'">';
								switch($content_style){
									case 'slider':	
										$html .= '<div class="tab-cat-slider1">
														<div class="wrap-item '.esc_attr($control_nav).'" data-autoplay="'.esc_attr($autoplay).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
										
										if($product_query->have_posts()) {
											$count = 0;
											while($product_query->have_posts()) {
												$count++;
												$product_query->the_post();
												if($row>1){
													if($count%$row==1){
														$html .= '<div class="item">';
													}
														$html .=  s7upf_product_item('table','',$size);
													if($count%$row == 0 || $count == $count_query){
														$html .= '</div>';
													}
												}else{
													$html .=  s7upf_product_item($product_style,'',$size);
												}
											}
										}
												
										$html .=	'</div>
												</div>';
								    break;
									
									case 'grid':	
										$html .= '<div class="list-product-offer4">
														<div class="row">';
										if($product_query->have_posts()) {
											while($product_query->have_posts()) {
												$product_query->the_post();
												$html .=  '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_product_item($product_style,'',$size).'</div>';
											}
										}
												
										$html .=	'</div>
												</div>';
								    break;	
									
									case 'loadmore':	
										$html .= '<div class="block-product-loadmore">
														<div class="row">';
										if($product_query->have_posts()) {
											$num = 0;
											while($product_query->have_posts()) {
												$num++;
												$col = 'col-md-3 col-sm-4 col-xs-12';
												$size = array(280,300);
												if($num%6 == 2 | $num%6 == 4){
													$col = 'col-md-6 col-sm-8 col-xs-12';
													$size = array(580,300);
												}
												$product_query->the_post();
												$html .=  '<div class="'.esc_attr($col).'">'.s7upf_product_item('loadmore','',$size).'</div>';
											}
										}
												
										$html .=	    '</div>';
										if($max_page > 1) $html .='<a href="#" class="btn-load-more btn-load-more-product btn-border" data-hover="Load more" data-cat="'.esc_attr($tab_tax).'" data-type="'.esc_attr($product_type).'" data-maxpage="'.esc_attr($max_page).'" data-number="'.esc_attr($number).'" data-paged="1" data-order="'.esc_attr($order).'"  data-orderby="'.esc_attr($order_by).'">Load more</a>';	
										$html .=	'</div>';
								    break;	
									
								}			
								$html .= '</div>';
							}			
					$html .=		'</div>';
					
					$html .=    '</div>';
					
					wp_reset_postdata();
				break;
				
				default:
					$pre = uniqid();
					$args=array(
						'post_type'         => 'product',
						'posts_per_page'    => -1,
						'showposts'         => $number,
						'orderby'           => $order_by,
						'order'             => $order
					);
					if(!empty($cats)) {
						$custom_list = explode(",",$cats);
						$args['tax_query'][]=array(
							'taxonomy'=>'product_cat',
							'field'=>'slug',
							'terms'=> $custom_list
						);
					}
					if(!empty($product_type)){
						$tabs = explode(',', $product_type);
						$tab_html = $content_html = '';
						foreach ($tabs as $key => $tab) {
							switch ($tab) {
								case 'bestsell':
									$tab_title =    esc_html__("Best Sellers","'manu");
									$args['meta_key'] = 'total_sales';
									$args['orderby'] = 'meta_value_num';
									break;

								case 'toprate':
									$tab_title =    esc_html__("Top Rate","'manu");
									unset($args['meta_key']);
									$args['meta_key'] = '_wc_average_rating';
									$args['orderby'] = 'meta_value_num';
									$args['meta_query'] = WC()->query->get_meta_query();
									$args['tax_query'][] = WC()->query->get_tax_query();
									break;
								
								case 'mostview':
									$tab_title =    esc_html__("Popular","'manu");
									unset($args['no_found_rows']);
									unset($args['meta_query']);
									unset($args['tax_query']);
									$args['meta_key'] = 'post_views';
									$args['orderby'] = 'meta_value_num';
									break;

								case 'featured':
									$tab_title =    esc_html__("Featured Products","'manu");
									$args['orderby'] = $order_by;
									$args['tax_query'][] = array(
										'taxonomy' => 'product_visibility',
										'field'    => 'name',
										'terms'    => 'featured',
										'operator' => 'IN',
									);
									break;

								case 'trendding':
									unset($args['meta_key']);
									unset($args['meta_value']);
									$tab_title =    esc_html__("Trendding","'manu");
									$args['meta_query'][] = array(
										'key'     => 'trending_product',
										'value'   => 'on',
										'compare' => '=',
									);
									break;
								
								case 'onsale':
									$tab_title =    esc_html__("On sale","'manu");
									unset($args['meta_query']);
									unset($args['meta_key']);
									unset($args['meta_value']);
									$args['meta_query']['relation']= 'OR';
									$args['meta_query'][]=array(
										'key'   => '_sale_price',
										'value' => 0,
										'compare' => '>',                
										'type'          => 'numeric'
									);
									$args['meta_query'][]=array(
										'key'   => '_min_variation_sale_price',
										'value' => 0,
										'compare' => '>',                
										'type'          => 'numeric'
									);
									break;
								
								default:
									$tab_title =    esc_html__("New Products","'manu");
									$args['orderby'] = 'date';
									break;
							}
							if($key == 0) $f_class = 'active';
							else $f_class = '';
							$product_query = new WP_Query($args);
							$count_query = $product_query->post_count;
							$tab_html .=    '<li class="'.esc_attr($f_class).'"><a href="'.esc_url('#'.$tab.'_'.$pre).'" data-toggle="tab">'.$tab_title.'</a></li>';
							
							$content_html .=    '<div id="'.$tab.'_'.$pre.'" class="tab-pane '.$f_class.'">
													<div class="list-our-product3">
														<div class="row">';
							if($product_query->have_posts()) {
								while($product_query->have_posts()) {
									$product_query->the_post();
									$content_html .=    '<div class="col-md-3 col-sm-4 col-xs-6">'.s7upf_product_item('border','',$size).'</div>';
								}
							}
							$content_html .=             '</div>
													</div>
												</div>';
						} 
						$html .=    '<div class="product-tab-default '.esc_attr($class_extra).'">';
						$html .=       	'<ul class="list-inline-block '.esc_attr($tab_style).'">
											'.$tab_html.'
										</ul>
										<div class="tab-content">
											'.$content_html.'
										</div>
									</div>';
					}	
					wp_reset_postdata();
				break;
			}
            return $html;
        }
    }

    stp_reg_shortcode('sv_product_tab','s7upf_vc_product_tab');
    if(isset($_GET['return'])) $check_add = $_GET['return'];
    if(empty($check_add)) add_action( 'vc_before_init_base','s7upf_add_product_tab',10,100 );
    if ( ! function_exists( 's7upf_add_product_tab' ) ) {
        function s7upf_add_product_tab(){
            vc_map( array(
                "name"      => esc_html__("Manu Product Tab", 'manu'),
                "base"      => "sv_product_tab",
                "icon"      => "icon-st",
                "category"  => '7Up-theme',
                "params"    => array(
                    array(
                        "type" => "dropdown",
                        "heading" => esc_html__("Style",'manu'),
                        "param_name" => "style",
                        "value"     => array(
                            esc_html__("Tabs Product",'manu')   => 'product',
                            esc_html__("Tabs Category",'manu')   => 'category',
						)
                    ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title Box', 'manu' ),
						'param_name'  => 'title',
						"dependency"    =>array(
							'element'   =>'style',
							'value'     =>array('abc')
						),
					),
                    array(
                        "type" => "checkbox",
                        "heading" => esc_html__("Product Type",'manu'),
                        "param_name" => "product_type",
                        "value" => array(
                            esc_html__("New Arrivals",'manu')    => 'newarrival',
                            esc_html__("Best Seller",'manu')     => 'bestsell',
                            esc_html__("Most Review",'manu')     => 'toprate',
                            esc_html__("Most View",'manu')       => 'mostview',
                            esc_html__("Featured",'manu')        => 'featured',
                            esc_html__("Trendding",'manu')       => 'trendding',
                            esc_html__("On Sale",'manu')         => 'onsale',
						),
                    ),
					array(
						'holder'     => 'div',
						'heading'     => esc_html__( 'Product Categories', 'manu' ),
						'type'        => 'autocomplete',
						'param_name'  => 'cats',
						'settings' => array(
							'multiple' => true,
							'sortable' => true,
							'values' => s7upf_get_product_taxonomy(),
						),
						'save_always' => true,
						'description' => esc_html__( 'List of product categories', 'manu' ),
					),
					array(
						'heading'     => esc_html__( 'Tabs Style', 'manu' ),
						'type'        => 'dropdown',
						'description' => esc_html__( 'Choose style for tabs.', 'manu' ),
						'param_name'  => 'tab_style',
						'value'       => array(                        
							esc_html__('Default','manu')     => '',
							esc_html__('Style 1','manu')     => 'title-tab-cat1',
							esc_html__('Style 2','manu')     => 'title-tab3',
							esc_html__('Style 3','manu')     => 'title-tab-blog1 style2',
						),
					),
					array(
						'heading'     => esc_html__( 'Content Tabs Style', 'manu' ),
						'type'        => 'dropdown',
						'description' => esc_html__( 'Choose style for content tab.', 'manu' ),
						'param_name'  => 'content_style',
						'value'       => array(                        
							esc_html__('Slider','manu')     => 'slider',
							esc_html__('Grid','manu')     => 'grid',
							esc_html__('Load More','manu')     => 'loadmore',
						),
					),
					array(
						'heading'     => esc_html__( 'Product Style', 'manu' ),
						'type'        => 'dropdown',
						'description' => esc_html__( 'Choose style for product.', 'manu' ),
						'param_name'  => 'product_style',
						'value'       => array(                        
							esc_html__('Default','manu')     => '',
							esc_html__('Border','manu')     => 'border',
							esc_html__('Table','manu')     => 'table',
							esc_html__('Flex Box','manu')     => 'info-right',
							esc_html__('Special','manu')     => 'special',
							esc_html__('Load More','manu')     => 'loadmore',
						),
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider','grid')
						),
					),
                    array(
                        'heading'     => esc_html__( 'Number', 'manu' ),
                        'type'        => 'textfield',
                        'description' => esc_html__( 'Enter number of product. Default is 10.', 'manu' ),
                        'param_name'  => 'number',
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Size Thumbnail",'manu'),
                        "param_name"    => "size",
                        'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider','grid')
						),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__( 'Order By', 'manu' ),
                        'value' => s7upf_get_order_list(),
                        'param_name' => 'orderby',
                        'description' => esc_html__( 'Select Orderby Type ', 'manu' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                    array(
                        'heading'     => esc_html__( 'Order', 'manu' ),
                        'type'        => 'dropdown',
                        'param_name'  => 'order',
                        'value' => array(                   
                            esc_html__('Desc','manu')  => 'DESC',
                            esc_html__('Asc','manu')  => 'ASC',
                        ),
                        'description' => esc_html__( 'Select Order Type ', 'manu' ),
                        'edit_field_class'=>'vc_col-sm-6 vc_column',
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Row Number",'manu'),
                        "param_name"    => "row",
                        'description'   => esc_html__( 'Number Items/Row. Default:1', 'manu' ),
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
                    ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Class Extra', 'manu' ),
						'param_name'  => 'class_extra',
					),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Item Responsive",'manu'),
                        "param_name"    => "itemscustom",
                        "group"         => esc_html__("Slider Settings",'manu'),
                        'description'   => esc_html__( 'Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,600:3,1000:4. Default is auto.', 'manu' ),
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
                    ),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Navigation Control', 'manu' ),
						'param_name'  => 'navigation',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Settings','manu'),	
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Pagination Control', 'manu' ),
						'param_name'  => 'pagination',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Settings','manu'),	
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Auto Play Control', 'manu' ),
						'param_name'  => 'autoplay',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Settings','manu'),	
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style Control Nav', 'manu' ),
						'param_name'  => 'control_nav',
						'value'       => array(
							esc_html__( 'Default', 'manu' )        => '',
							esc_html__( 'Group Navi', 'manu' )     => 'group-navi',
							esc_html__( 'Pagination Border', 'manu' )      => 'pagi-white',
						),
						'group'         => esc_html__('Slider Settings','manu'),	
						"dependency"    =>array(
							'element'   =>'content_style',
							'value'     =>array('slider')
						),
					),
                )
            ));
        }
    }
}
