<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */
if(class_exists("woocommerce")){
	if(!function_exists('sv_vc_product_list'))
	{
		function sv_vc_product_list($attr, $content = false)
		{
			$html = $css_class = '';
			extract(shortcode_atts(array(
				'style'           => '',
				'number'          => '8',
				'cats'            => '',
				'order_by'        => 'date',
				'order'           => 'DESC',
				'product_type'    => '',
				'product_style'   => '',
				'time_counter'    => '',
				'link'            => '',
				'size'            => '',
				'row'             => '1',
				'control_nav'     => '',
				'itemscustom'     => '',
				'autoplay'        => 'false',
				'pagination'      => 'false',
				'navigation'      => 'false',
				'class_extra'     => '',
				'custom_css'      => '',
			),$attr));
			if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
			if(!empty($cats)) $cats = str_replace(' ', '', $cats);
			$custom_list = array();
			$args = array(
				'post_type'         => 'product',
				'posts_per_page'    => -1,
				'showposts'         => $number,
				'orderby'           => $order_by,
				'order'             => $order,
			);
			if($product_type == 'trendding'){
				$args['meta_query'][] = array(
						'key'     => 'trending_product',
						'value'   => 'on',
						'compare' => '=',
					);
			}
			if($product_type == 'toprate'){
				$args['meta_key'] = '_wc_average_rating';
				$args['orderby'] = 'meta_value_num';
				$args['meta_query'] = WC()->query->get_meta_query();
				$args['tax_query'][] = WC()->query->get_tax_query();
			}
			if($product_type == 'mostview'){
				$args['meta_key'] = 'post_views';
				$args['orderby'] = 'meta_value_num';
			}
			if($product_type == 'bestsell'){
				$args['meta_key'] = 'total_sales';
				$args['orderby'] = 'meta_value_num';
			}
			if($product_type=='onsale'){
				$args['meta_query']['relation']= 'OR';
				$args['meta_query'][]=array(
					'key'   => '_sale_price',
					'value' => 0,
					'compare' => '>',                
					'type'          => 'numeric'
				);
				$args['meta_query'][]=array(
					'key'   => '_min_variation_sale_price',
					'value' => 0,
					'compare' => '>',                
					'type'          => 'numeric'
				);
			}
			if($product_type == 'featured'){
				$args['tax_query'][] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN',
				);
			}
			if(!empty($cats)) {
				$custom_list = explode(",",$cats);
				$args['tax_query'][]=array(
					'taxonomy'=>'product_cat',
					'field'=>'slug',
					'terms'=> $custom_list
				);
			}
			$product_query = new WP_Query($args);
			$count_query = $product_query->post_count;
			if(!empty($size)){
				$size = explode('x', $size);
			}else{
				$size = 'full';
			}
			switch ($style) {
				
				case 'trending-slider1':
					$html .= '<div class="trending-slider1 '.esc_attr($class_extra).' '.esc_attr($css_class).'">
								<div class="wrap-item '.esc_attr($control_nav).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-autoplay="'.esc_attr($autoplay).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
					if($product_query->have_posts()) {
						while($product_query->have_posts()) {
							$product_query->the_post();
							$html .=  s7upf_product_item('border','',$size);
						}
					}	
					$html .= 	'</div>
					          </div>';
					break;
							 
				case 'new-product-slider1':
					$html .= '<div class="new-product-slider1 border '.esc_attr($class_extra).' '.esc_attr($css_class).'">
								<div class="wrap-item '.esc_attr($control_nav).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-autoplay="'.esc_attr($autoplay).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
					if($product_query->have_posts()) {
						$count = 0;
						while($product_query->have_posts()) {
							$count++;
							$product_query->the_post();
							if($count%$row==1){
								$html .= '<div class="item">';
							}
							if($count%2==0){
								$html .=  s7upf_product_item('info-left','',$size);
							}else{
								$html .=  s7upf_product_item('info-right','',$size);
							}	
							if($count%$row == 0 || $count == $count_query){
								$html .= '</div>';
							}		
						}
					}	
					$html .= 	'</div>
					          </div>';
					break;
							  			 
				case 'deal-product-slider2':
					$date_text = '["Day","Hour","Min","Sec"]';
					$deal_time = strtotime($time_counter);
					$args = array(
						'post_type'         => 'product',
						'posts_per_page'    => -1,
						'showposts'         => $number,
						'orderby'           => $order_by,
						'order'             => $order,
					);
					if(!empty($cats)) {
						$custom_list = explode(",",$cats);
						$args['tax_query'][]=array(
							'taxonomy'=>'product_cat',
							'field'=>'slug',
							'terms'=> $custom_list
						);
					}
					$args['meta_query']['relation']= 'OR';
					$args['meta_query'][]=array(
						'key'   => '_sale_price',
						'value' => 0,
						'compare' => '>',                
						'type'          => 'numeric'
					);
					$args['meta_query'][]=array(
						'key'   => '_min_variation_sale_price',
						'value' => 0,
						'compare' => '>',                
						'type'          => 'numeric'
					);
					$product_query = new WP_Query($args);
					$html .= 	'<div class="wrap-deal-clock text-center">
					                <div class="time-countdown deal-time" data-date="'.esc_attr($time_counter).'" data-text="'.esc_attr($date_text).'" data-width="0.03" data-color="#fdd55a" data-bg="#3f4042"></div>
								    <a href="'.esc_attr($link).'" class="btn-border" data-hover="'.esc_html__('View All Products','manu').'">'.esc_html__('View All Products','manu').'</a>
								</div>';
					$html .= '<div class="deal-product-slider2 '.esc_attr($class_extra).' '.esc_attr($css_class).'">
								<div class="wrap-item '.esc_attr($control_nav).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-autoplay="'.esc_attr($autoplay).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
					if($product_query->have_posts()) {
						$count = 0;
						while($product_query->have_posts()) {
							$count++;
							$product_query->the_post();
							$html .=  s7upf_product_item('border','',$size);
						}
					}	
					$html .= 	'</div>
					          </div>';
					wp_reset_postdata();		  
					break;
							  
				default:
					$html .= '<div class="product-slider '.esc_attr($class_extra).' '.esc_attr($css_class).'">
								<div class="wrap-item '.esc_attr($control_nav).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-autoplay="'.esc_attr($autoplay).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
					if($product_query->have_posts()) {
						$count = 0;
						while($product_query->have_posts()) {
							$count++;
							$product_query->the_post();
							if($count%$row==1){
								$html .= '<div class="item">';
							}
							$html .=  s7upf_product_item($product_style,'',$size);	
							if($count%$row == 0 || $count == $count_query){
								$html .= '</div>';
							}		
						}
					}	
					
					$html .= 	'</div>
					          </div>';
					break;
			}
			wp_reset_postdata();
			return $html;
		}
	}

	stp_reg_shortcode('sv_product_list','sv_vc_product_list');

	$check_add = '';
	if(isset($_GET['return'])) $check_add = $_GET['return'];
	if(empty($check_add)) add_action( 'vc_before_init_base','sv_add_list_product',10,100 );
	if ( ! function_exists( 'sv_add_list_product' ) ) {
		function sv_add_list_product(){
			vc_map( array(
				"name"      => esc_html__("Manu Product List", 'manu'),
				"base"      => "sv_product_list",
				"icon"      => "icon-st",
				"category"  => '7Up-theme',
				"params"    => array(
					array(
						'heading'     => esc_html__( 'Style', 'manu' ),
						'holder'      => 'div',
						'type'        => 'dropdown',
						'param_name'  => 'style',
						'value'       => array(                        
							esc_html__('Default','manu')     => 'default',
							esc_html__('Trending Slider 1','manu')     => 'trending-slider1',
							esc_html__('Odd/Even Product','manu')     => 'new-product-slider1',
							esc_html__('Deal Product','manu')     => 'deal-product-slider2',
						),
					),
					array(
						'heading'     => esc_html__( 'Product Type', 'manu' ),
						'type'        => 'dropdown',
						'param_name'  => 'product_type',
						'value' => array(
							esc_html__('Default','manu')            => '',
							esc_html__('Trendding','manu')          => 'trendding',
							esc_html__('Featured Products','manu')  => 'featured',
							esc_html__('Best Sellers','manu')       => 'bestsell',
							esc_html__('On Sale','manu')            => 'onsale',
							esc_html__('Top rate','manu')           => 'toprate',
							esc_html__('Most view','manu')          => 'mostview',
						),
						'description' => esc_html__( 'Select Product View Type', 'manu' ),
					),
					array(
						'heading'     => esc_html__( 'Product Style', 'manu' ),
						'type'        => 'dropdown',
						'description' => esc_html__( 'Choose style for product.', 'manu' ),
						'param_name'  => 'product_style',
						'value'       => array(                        
							esc_html__('Default','manu')     => '',
							esc_html__('Border','manu')     => 'border',
							esc_html__('Table','manu')     => 'table',
							esc_html__('Flex Box','manu')     => 'info-right',
						),
						"dependency"    =>array(
							'element'   =>'style',
							'value'     =>array('default')
						),
					),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Row Number",'manu'),
                        "param_name"    => "row",
                        'description'   => esc_html__( 'Number Items/Row. Default:1', 'manu' ),
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Extra Link",'manu'),
                        "param_name"    => "link",
						"dependency"    =>array(
							'element'   =>'style',
							'value'     =>array('deal-product-slider2')
						),
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__("Time Count Down",'manu'),
                        "param_name"    => "time_counter",
                        'description'   => esc_html__( 'Set Time Count Down for product on sale(dateFormat: "mm/dd/yy")', 'manu' ),
						"dependency"    =>array(
							'element'   =>'style',
							'value'     =>array('deal-product-slider2')
						),
                    ),
					array(
						'heading'     => esc_html__( 'Number', 'manu' ),
						'type'        => 'textfield',
						'description' => esc_html__( 'Enter number of product. Default is 8.', 'manu' ),
						'param_name'  => 'number',
						'edit_field_class'=>'vc_col-sm-6 vc_column',
					),
					array(
						"type"          => "textfield",
						"heading"       => esc_html__("Size Thumbnail",'manu'),
						"param_name"    => "size",
						'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
						'edit_field_class'=>'vc_col-sm-6 vc_column',
					),
					array(
						'holder'     => 'div',
						'heading'     => esc_html__( 'Product Categories', 'manu' ),
						'type'        => 'autocomplete',
						'param_name'  => 'cats',
						'settings' => array(
							'multiple' => true,
							'sortable' => true,
							'values' => s7upf_get_product_taxonomy(),
						),
						'save_always' => true,
						'description' => esc_html__( 'List of product categories', 'manu' ),
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Order By', 'manu' ),
						'value' => s7upf_get_order_list(),
						'param_name' => 'orderby',
						'description' => esc_html__( 'Select Orderby Type ', 'manu' ),
						'edit_field_class'=>'vc_col-sm-6 vc_column',
					),
					array(
						'heading'     => esc_html__( 'Order', 'manu' ),
						'type'        => 'dropdown',
						'param_name'  => 'order',
						'value' => array(                   
							esc_html__('Desc','manu')  => 'DESC',
							esc_html__('Asc','manu')  => 'ASC',
						),
						'description' => esc_html__( 'Select Order Type ', 'manu' ),
						'edit_field_class'=>'vc_col-sm-6 vc_column',
					),
					array(
						'heading'     => esc_html__( 'Custom Items', 'manu' ),
						'type'        => 'textfield',
						'description'   => esc_html__( 'Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,480:3,768:4,1024:5. Default is auto.', 'manu' ),
						'param_name'  => 'itemscustom',
						'group'         => esc_html__('Slider Control','manu'),	
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Navigation Control', 'manu' ),
						'param_name'  => 'navigation',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Control','manu'),	
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Pagination Control', 'manu' ),
						'param_name'  => 'pagination',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Control','manu'),	
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Auto Play Control', 'manu' ),
						'param_name'  => 'autoplay',
						'value'       => array(
							esc_html__( 'False', 'manu' )        => 'false',
							esc_html__( 'True', 'manu' )        => 'true',
						),
						'group'         => esc_html__('Slider Control','manu'),
							
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Style Control Nav', 'manu' ),
						'param_name'  => 'control_nav',
						'value'       => array(
							esc_html__( 'Default', 'manu' )        => '',
							esc_html__( 'Group Navi', 'manu' )     => 'group-navi',
							esc_html__( 'Rect Navi', 'manu' )      => 'rect-navi',
							esc_html__( 'Hidden Navi', 'manu' )    => 'nav-hidden',
							esc_html__( 'Group Small', 'manu' )    => 'small-navi group-navi',
							esc_html__( 'Pagination Border', 'manu' )    => 'border-pagi',
						),
						'group'         => esc_html__('Slider Control','manu'),	
					),
					array(
						"type"          => "css_editor",
						"heading"       => esc_html__("Custom Style",'manu'),
						"param_name"    => "custom_css",
						'group'         => esc_html__('Design Option','manu')
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Class Extra', 'manu' ),
						'param_name'  => 'class_extra',
						'group'         => esc_html__('Design Option','manu')
					),
				)
			));
		}
	}
}