<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 26/12/15
 * Time: 10:00 AM
 */

if(!function_exists('s7upf_vc_mailchimp'))
{
    function s7upf_vc_mailchimp($attr)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
			'style'         => '',
            'title'         => '',
            'desc'           => '',
            'placeholder'   => '',
            'submit'        => '',
            'form_id'       => '',
			'class_extra'   => '',
			'custom_css'    => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
        $form_html = apply_filters('sv_remove_autofill',do_shortcode('[mc4wp_form id="'.$form_id.'"]'));
		switch($style){
			case 'style1':
				$html .=                  '<ul class="list-inline-block block-news-letter text-center '.esc_attr($class_extra).' '.$css_class.'">';
				if(!empty($title)) $html .=    '<li><h2 class="title18 font-bold text-uppercase">'.esc_html($title).'</h2></li>';
				$html .=        			   '<li><div class="form-newsletter">'.$form_html.'</div></li>
										   </ul>';
			break;
			
			default:
				$html .=    '<div class="newsletter-signup '.esc_attr($class_extra).' '.$css_class.'">';
					if(!empty($title)) $html .=    '<h2 class="title30 text-uppercase">'.esc_html($title).'</h2>';
					if(!empty($desc)) $html .=    '<p class="desc white">'.esc_html($desc).'</p>';
				$html .=        '<div class="form-newsletter">'.$form_html.'</div>';
				$html .=    '</div>';
			break;	
		}
		
        return $html;
    }
}

stp_reg_shortcode('sv_mailchimp','s7upf_vc_mailchimp');

vc_map( array(
    "name"      => esc_html__("Manu MailChimp", 'manu'),
    "base"      => "sv_mailchimp",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
		array(
			'type' => 'dropdown',
			'admin_label' => true,
			'heading' => esc_html__( 'Style', 'manu' ),
			'param_name' => 'style',
			'value' => array(
				esc_html__('Default','manu')=>'',
				esc_html__('Title Inline','manu')=>'style1',
			),
		),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Form ID",'manu'),
            "param_name" => "form_id",
        ),
        array(
            "type" => "textfield",
            'holder'      => 'div',
            "heading" => esc_html__("Title",'manu'),
            "param_name" => "title",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Description",'manu'),
            "param_name" => "desc",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Placeholder Input",'manu'),
            "param_name" => "placeholder",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Submit Label",'manu'),
            "param_name" => "submit",
        ),
		array(
			"type"          => "css_editor",
			"heading"       => esc_html__("Custom Style",'manu'),
			"param_name"    => "custom_css",
			'group'         => esc_html__('Design Option','manu')
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Class Extra', 'manu' ),
			'param_name'  => 'class_extra',
			'group'         => esc_html__('Design Option','manu')
		),
    )
));