<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('s7upf_vc_information'))
{
    function s7upf_vc_information($attr,$content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style'     	 => 'default',
            'image'     	 => '',
            'icon'      	 => '',
            'title'      	 => '',
			'desc'           => '',
            'bg_color'   	 => '',
            'link'       	 => '',
            'button'    	 => '',
			'class_extra'    => '',
			'custom_css'     => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		if(!empty($button)) $button = vc_build_link($button);
        if(!empty($bg_color)) $bg_color = S7upf_Assets::build_css('background-color:'.$bg_color);
        if(!empty($icon)) $icon = '<i class="'.esc_attr($icon).'"></i>';
        switch ($style) {
            case 'item-service3':
                $html .=    '<div class="item-service3 text-center '.$css_class.' '.esc_attr($class_extra).'">
								<a href="'.esc_url($link).'" class="title60 wobble-horizontal color2">'.$icon.'</a>
								<p class="desc">'.esc_html($desc).'</p>
							</div>';
                break;
				
            case 'item-service4':
                $html .=    '<div class="item-service4 table-custom'.$css_class.' '.esc_attr($class_extra).'">
								<div class="service-icon">
									<a href="'.esc_url($link).'" class="bg-color title30">'.$icon.'</a>
								</div>
								<div class="service-info">
									<h3 class="title14 font-bold text-uppercase">'.esc_html($title).'</h3>
									<p class="desc">'.esc_html($desc).'</p>
								</div>
							</div>';
                break;
					
            case 'item-statistic':
                $html .=    '<div class="item-statistic text-center white '.$css_class.' '.esc_attr($class_extra).'">
								<a href="'.esc_url($link).'" class="title30 white">'.$icon.'</a>
								<h3 class="title30 font-bold">'.esc_html($title).'</h3>
								<p class="desc white">'.esc_html($desc).'</p>
							</div>';
                break;
				
            case 'travel-service':
                $html .=    '<div class="item-travel-service bg-white transition '.$css_class.' '.esc_attr($class_extra).'">
								<ul class="list-inline-block">
									<li>'.wp_get_attachment_image($image,'full').'</li>
									<li><h2 class="title18 font-bold text-uppercase"><a href="'.esc_url($link).'" class="black">'.esc_html($title).'</a></h2></li>
								</ul>';
								if(!empty($desc)) $html .= '<p class="desc">'.esc_html($desc).'</p>';
				$html .=    '</div>';
                break;
				
			case 'contact-footer':
                $html .=    '<a href="'.esc_url($link).'" class="item-contact-footer '.$css_class.' '.esc_attr($class_extra).'">
                                '.$icon.'
                                <span>'.esc_html($title).'</span>
                            </a>';
                break;

            case 'intro-box':
                $html .=    '<div class="item-jouney '.$css_class.' '.esc_attr($class_extra).'">
                                <a href="'.esc_url($link).'" class="push">'.wp_get_attachment_image($image,'full').'</a>
                                '.wpb_js_remove_wpautop($content, true).'
                            </div>';
                break;

            case 'contact-box':
                $html .=    '<div class="contact-box '.$css_class.' '.esc_attr($class_extra).'">
                                <span class="color">'.$icon.'</span>
                                '.wpb_js_remove_wpautop($content, true).'
                            </div>';
                break;

            case 'about-style':
                $html .=    '<div class="item-about-service text-center white '.$css_class.' '.esc_attr($class_extra).' '.esc_attr($bg_color).'">
                                <a href="'.esc_url($link).'" class="wobble-horizontal">'.$icon.'</a>
                                '.wpb_js_remove_wpautop($content, true).'
                            </div>';
                break;
            
            default:
                $html .=    '<div class="custom-information '.$css_class.' '.esc_attr($class_extra).'">
								'.wpb_js_remove_wpautop($content, true).'
                            </div>';
                break;
        }        
        
        return $html;
    }
}

stp_reg_shortcode('s7upf_information','s7upf_vc_information');

vc_map( array(
    "name"      => esc_html__("Manu Information", 'manu'),
    "base"      => "s7upf_information",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type"          => "dropdown",
            "holder"        => "div",
            "heading"       => esc_html__("Style",'manu'),
            "param_name"    => "style",
            "value"         => array(
                esc_html__("Default","'manu")   => 'default',
                esc_html__("Policy","'manu")   => 'item-service3',
                esc_html__("Shadow Box","'manu")   => 'item-service4',
                esc_html__("Travel Service","'manu")   => 'travel-service',
                esc_html__("Statistic","'manu")   => 'item-statistic',
                esc_html__("Intro Box","'manu")   => 'intro-box',
                esc_html__("Contact Footer","'manu")   => 'contact-footer',
                esc_html__("About style","'manu")   => 'about-style',
                esc_html__("Contact box","'manu")   => 'contact-box',
                ),
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link",'manu'),
            "param_name" => "link",
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('item-service4','contact-footer','about-style','contact-box','intro-box','travel-service','item-statistic','item-service3'),
            )
        ),
		array(  
			'type' => 'iconpicker' ,
			'heading' => esc_html__('Icon', 'manu'),
			'param_name' => 'icon',
			'value' => '', 
			'settings' => array(
				'emptyIcon' => false,
				'type' => 'ionicon',
				'iconsPerPage' => 100,
			),
			'description' =>  esc_html__( 'Select icon from Ion icon library.', 'manu' ),
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('item-service4','contact-footer','about-style','contact-box','item-statistic','item-service3'),
            )
		),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Image",'manu'),
            "param_name" => "image",
            'dependency'    => array(
                'element'   => 'style',
                'value'   => array('intro-box','travel-service'),
			)
        ),
		array(
            "type" => "textfield",
            "heading" => esc_html__("Title",'manu'),
            "param_name" => "title",
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('item-service4','contact-footer','travel-service','item-statistic'),
            )
        ),
		array(
			"type" => "textfield",
			"heading" => esc_html__("Description",'manu'),
			"param_name" => "desc",
			"dependency"    => array(
				"element"   => "style",
				"value"   => array('item-service4','travel-service','item-statistic','item-service3'),
			),
		),
        array(
            "type"          => "colorpicker",
            "heading"       => esc_html__("Background Color",'manu'),
            "param_name"    => "bg_color",
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('about-style'),
			)
        ),
        array(
            "type"          => "vc_link",
            "heading"       => esc_html__("Button",'manu'),
            "param_name"    => "button",
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('abc'),
			)
        ),
        array(
            "type" => "textarea_html",
            "holder" => "div",
            "heading" => esc_html__("Content",'manu'),
            "param_name" => "content",
			'dependency'    => array(
                'element'   => 'style',
                'value'   => array('default','about-style','contact-box','intro-box'),
			)
        ),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Class Extra', 'manu' ),
			'param_name'  => 'class_extra',
		),
		array(
			"type"          => "css_editor",
			"heading"       => esc_html__("Custom Style",'manu'),
			"param_name"    => "custom_css",
			'group'         => esc_html__('Design Option','manu')
		),
    )
));