<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */
if(!function_exists('s7upf_vc_custom_link'))
{
    function s7upf_vc_custom_link($attr, $content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style'         => 'default',
            'list_text'     => '',
            'list_image'    => '',
            'list_icon'     => '',
			'class_extra'   => '',
			'custom_css'    => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		$data_text  = (array) vc_param_group_parse_atts( $list_text );
		$data_image = (array) vc_param_group_parse_atts( $list_image );
		$data_icon  = (array) vc_param_group_parse_atts( $list_icon );
		switch($style){
			case 'social-network':
				$html .=    '<div class="'.esc_attr($style).' '.esc_attr($class_extra).' '.$css_class.'">';
				if(is_array($data_image)){
					foreach ($data_image as $key => $value){
						if(!empty($value['link'])) {
							$html .= '<a class="float-shadow" href="'.esc_url($value['link']).'">';
								if(!empty($value['image'])) {
									$html .= wp_get_attachment_image($value['image'],'full');
								}
							$html .= '</a>';
						}
					}
				}
				$html .=    '</div>';   
			break;
			
			case 'social-network3':
				$html .=    '<div class="'.esc_attr($style).' '.esc_attr($class_extra).' '.$css_class.'">';
				if(is_array($data_icon)){
					foreach ($data_icon as $key => $value){
						if(!empty($value['link'])) {
							$html .= '<a class="white title18 float-shadow" href="'.esc_url($value['link']).'">';
								if(!empty($value['icon'])) {
									$html .= '<i class="'.$value['icon'].'"></i>';
								}
							$html .= '</a>';
						}
					}
				}
				$html .=    '</div>';   
			break;
			
			case 'payment-method':
				$html .=    '<div class="'.esc_attr($style).' '.esc_attr($class_extra).'">
								<ul class="list-inline-block">';
				if(is_array($data_image)){
					foreach ($data_image as $key => $value){
						if(!empty($value['link'])) {
							$html .= '<li><a class="wobble-top" href="'.esc_url($value['link']).'">';
								if(!empty($value['image'])) {
									$html .= wp_get_attachment_image($value['image'],'full');
								}
							$html .= '</a></li>';
						}
					}
				}
				$html .=    	'</ul>
							</div>';   
			break;
			
			case 'top-link':
				$html .=    '<ul class="'.esc_attr($style).' list-inline-block text-uppercase '.$css_class.' '.esc_attr($class_extra).'">';
				if(is_array($data_text)){
					foreach ($data_text as $key => $value){
						if(!empty($value['link'])) {
							$html .= '<li><a class="'.esc_attr($value['text_color']).'" href="'.esc_url($value['link']).'">';
								if(!empty($value['text'])) {
									$html .= esc_html($value['text']);
								}
							$html .= '</a></li>';
						}
					}
				}
				$html .=    '</ul>';   
			break;
			
			default:
				$html .=    '<div class="custom-image-link '.$css_class.' '.esc_attr($class_extra).'">';
				if(is_array($data_image)){
					foreach ($data_image as $key => $value){
						if(!empty($value['link'])) {
							$html .= '<a href="'.esc_url($value['link']).'">';
								if(!empty($value['image'])) {
									$html .= wp_get_attachment_image($value['image'],'full');
								}
							$html .= '</a>';
						}
					}
				}
				$html .=    '</div>';      
			break;
		}
		return  $html;
    }
}

stp_reg_shortcode('sv_custom_link','s7upf_vc_custom_link');


vc_map( array(
    "name"      => esc_html__("Manu Custom Link", 'manu'),
    "base"      => "sv_custom_link",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
		array(
			'type' => 'dropdown',
			'admin_label' => true,
			'heading' => esc_html__( 'Style', 'manu' ),
			'param_name' => 'style',
			'value' => array(
				esc_html__('Default','manu')=>'default',
				esc_html__('Top Link','manu')=>'top-link',
				esc_html__('Payment Method','manu')=>'payment-method',
				esc_html__('Social Network','manu')=>'social-network',
				esc_html__('Social Network Font Icon','manu')=>'social-network3',
			),
		),
		array(
            "type" => "param_group",
            "heading" => esc_html__("Add List Item",'manu'),
            "param_name" => "list_text",
            "params"    => array(
                array(
                    "type" => "textfield",
                    "heading" => esc_html__("Text",'manu'),
                    "param_name" => "text",
                ),
                array(
                    "type" => "textfield",
                    "heading" => esc_html__("Link",'manu'),
                    "param_name" => "link",
                ),
				array(
					'type' => 'dropdown',
					'admin_label' => true,
					'heading' => esc_html__( 'Text Color', 'manu' ),
					'param_name' => 'text_color',
					'value' => array(
						esc_html__('Default','manu')=>'gray',
						esc_html__('White','manu')=>'white',
						esc_html__('Black','manu')=>'black',
						esc_html__('Smoke','manu')=>'smoke',
						esc_html__('Main Color','manu')=>'color',
						esc_html__('Main Color2','manu')=>'color2',
					),
				),
            ),
			"dependency"    =>array(
				'element'   =>'style',
				'value'     =>array('top-link')
			),
        ),
		array(
            "type" => "param_group",
            "heading" => esc_html__("Add List Item",'manu'),
            "param_name" => "list_image",
            "params"    => array(
                array(
                    "type" => "attach_image",
                    "heading" => esc_html__("Image",'manu'),
                    "param_name" => "image",
                ),
                array(
                    "type" => "textfield",
                    "heading" => esc_html__("Link",'manu'),
                    "param_name" => "link",
                ),
            ),
			"dependency"    =>array(
				'element'   =>'style',
				'value'     =>array('social-network','payment-method','default')
			),
        ),
		array(
            "type" => "param_group",
            "heading" => esc_html__("Add List Item",'manu'),
            "param_name" => "list_icon",
            "params"    => array(
				array(  
					'type' => 'iconpicker' ,
					'heading' => esc_html__('Icon', 'manu'),
					'param_name' => 'icon',
					'value' => '', // default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						'type' => 'ionicon',
						'iconsPerPage' => 100,
					),
					'description' =>  esc_html__( 'Select icon from Ion icon library.', 'manu' ),
				),
                array(
                    "type" => "textfield",
                    "heading" => esc_html__("Link",'manu'),
                    "param_name" => "link",
                ),
            ),
			"dependency"    =>array(
				'element'   =>'style',
				'value'     =>array('social-network3')
			),
        ),
		array(
			"type"          => "css_editor",
			"heading"       => esc_html__("Custom Style",'manu'),
			"param_name"    => "custom_css",
			'group'         => esc_html__('Design Option','manu')
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Class Extra', 'manu' ),
			'param_name'  => 'class_extra',
			'group'         => esc_html__('Design Option','manu')
		),
    )
));