<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 31/08/15
 * Time: 10:00 AM
 */
/************************************Main Carousel*************************************/
if(!function_exists('s7upf_vc_carousel_slider'))
{
    function s7upf_vc_carousel_slider($attr, $content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'control_nav'     => '',
			'itemscustom'     => '',
            'autoplay'        => 'false',
            'pagination'      => 'false',
            'navigation'      => 'false',
			'class_extra'     => '',
            'custom_css'      => '',
        ),$attr));
		if(empty($itemscustom)){
			$itemscustom = '0:1';
		}
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
        $html .=    '<div class="carousel-slider '.$css_class.' '.esc_attr($class_extra).'">';
        $html .=        '<div class="wrap-item '.esc_attr($control_nav).'" data-autoplay="'.esc_attr($autoplay).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-itemscustom="'.s7upf_convert_itemscustom($itemscustom).'">';
        $html .=            wpb_js_remove_wpautop($content, true);
        $html .=        '</div>';
        $html .=    '</div>';
        return $html;
    }
}
stp_reg_shortcode('carousel_slider','s7upf_vc_carousel_slider');
vc_map(
    array(
        'name'     => esc_html__( 'SV Carousel Slider', 'manu' ),
        'base'     => 'carousel_slider',
        'category' => esc_html__( '7Up-theme', 'manu' ),
        'icon'     => 'icon-st',
        'as_parent' => array( 'only' => 'adv_slider_item,client_slider_item,brand_slider_item' ),
        'content_element' => true,
        'js_view' => 'VcColumnView',
        'params'   => array(                       
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style Control Nav', 'manu' ),
                'param_name'  => 'control_nav',
                'value'       => array(
                    esc_html__( 'Default', 'manu' )        		 => '',
                    esc_html__( 'Group Navi', 'manu' )     		 => 'group-navi',
                    esc_html__( 'Pagination Border', 'manu' )      => 'pagi-white',
				)
            ),
            array(
                'heading'     => esc_html__( 'Custom Items', 'manu' ),
                'type'        => 'textfield',
                'description'   => esc_html__( 'Enter item for screen width(px) format is width:value and separate values by ",". Example is 0:2,480:3,768:4,1024:5. Default is auto.', 'manu' ),
                'param_name'  => 'itemscustom',
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Navigation Control', 'manu' ),
                'param_name'  => 'navigation',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Pagination Control', 'manu' ),
                'param_name'  => 'pagination',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Auto Play Control', 'manu' ),
                'param_name'  => 'autoplay',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Class Extra', 'manu' ),
                'param_name'  => 'class_extra',
            ),
            array(
                "type"          => "css_editor",
                "heading"       => esc_html__("Custom Style",'manu'),
                "param_name"    => "custom_css",
                'group'         => esc_html__('Design Option','manu')
            ),
        )
    )
);

/*******************************************END MAIN*****************************************/

/**************************************BEGIN ADV SLIDER************************************/
//Banner item Frontend
if(!function_exists('s7upf_vc_adv_slider_item'))
{
    function s7upf_vc_adv_slider_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'         => 'default',
            'link'          => '', 
			'size'          => '', 
            'image'         => '',
            'animation'     => '',
            'video'         => '',
            'title'         => '',
            'sub_title'     => '',
            'desc'      	=> '',           
            'button'        => '',
        ),$attr));
		
		if(!empty($size)) $size = explode('x', $size);
        else $size = 'full';
		$data_link = vc_build_link($button);
		
        switch ($style) {
            case 'product-offer':
                $html .=    '<div class="banner-adv item-adv-offer '.esc_attr($animation).'">
								<div class="offer-info inline-block">';
				if(!empty($title)) 		$html .=	'<h3 class="title14 bg-color2 white">'.esc_html($title).'</h3>';
				if(!empty($sub_title))	$html .=	'<h3 class="title14 bg-color2 white">'.esc_html($sub_title).'</h3>';
				$html .= 		'</div>
								<a class="adv-thumb-link" href="'.esc_url($link).'">'.wp_get_attachment_image($image,$size).'</a>
							</div>';
                break;
            
            default:
                $html .=    '<div class="banner-adv '.esc_attr($animation).'">
                                <a class="adv-thumb-link" href="'.esc_url($link).'">
									'.wp_get_attachment_image($image,$size).'
								</a>';
								if(!empty($content)){
								$html .=	'<div class="default-info-adv">
												'.wpb_js_remove_wpautop($content, true).'
											</div>';
								}
                $html .=    '</div>';
                break;
        }        
        return $html;
    }
}
stp_reg_shortcode('adv_slider_item','s7upf_vc_adv_slider_item');

// Banner item
vc_map(
    array(
        'name'     => esc_html__( 'Adv Slider Item', 'manu' ),
        'base'     => 'adv_slider_item',
        'icon'     => 'icon-st',
        'content_element' => true,
        'as_child' => array('only' => 'carousel_slider'),
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style', 'manu' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Default', 'manu' ) => 'default',
                    esc_html__( 'Product Offer', 'manu' ) => 'product-offer',
                    )
            ),  
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Link', 'manu' ),
                'param_name'  => 'link',
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Image Size', 'manu' ),
                'param_name'  => 'size',
				'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
            ),
            array(
                'type'        => 'attach_image',
                'heading'     => esc_html__( 'Image', 'manu' ),
                'param_name'  => 'image',
            ),
            array(
				"type" => "dropdown",
				"heading" => esc_html__("Animation",'manu'),
				"param_name" => "animation",
				"value"     => array(
					esc_html__("Default",'manu')   => '',
					esc_html__("Zoom",'manu')   => 'zoom-image',
					esc_html__("Pull Curtain",'manu')   => 'pull-curtain',
					esc_html__("Fade Out-In",'manu')   => 'fade-out-in',
					esc_html__("Fade In-Out",'manu')   => 'fade-in-out',
					esc_html__("Zoom Fade Out-In",'manu')   => 'zoom-image fade-out-in',
					esc_html__("Zoom Rotate",'manu')   => 'zoom-rotate',
					esc_html__("Overlay",'manu')   => 'overlay-image',
					esc_html__("Overlay Zoom",'manu')   => 'overlay-image zoom-image',
					esc_html__("Line Scale",'manu')   => 'line-scale',
					esc_html__("Zoom Line Scale",'manu')   => 'zoom-image line-scale',
					),
			),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Link Video', 'manu' ),
                'param_name'  => 'video',
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('abc'),
				),
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Title', 'manu' ),
                'param_name'  => 'title',
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('product-offer'),
				),
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Sub Title', 'manu' ),
                'param_name'  => 'sub_title',
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('product-offer'),
				),
            ),
            array(
                "type"          => "textarea",
                "heading"       => esc_html__("Description",'manu'),
                "param_name"    => "desc",
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('abc'),
				),
            ),
			array(
				"type" => "vc_link",
				"heading" => esc_html__("Extra Link",'manu'),
				"param_name" => "button",
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('abc'),
				),
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"heading" => esc_html__("Content",'manu'),
				"param_name" => "content",
				'dependency'    => array(
					'element'   => 'style',
					'value'   => array('default'),
				)
			),
        )
    )
);

/**************************************END ADV SLIDER************************************/
/**************************************BEGIN CLIENT SLIDER************************************/
//Banner item Frontend
if(!function_exists('s7upf_vc_client_slider_item'))
{
    function s7upf_vc_client_slider_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'         => '',
            'link'          => '', 
			'size'          => '', 
            'image'         => '',
            'name'          => '',
            'desc'      	=> '',           
            'info'          => '',
        ),$attr));
		
		if(!empty($size)) $size = explode('x', $size);
        else $size = 'full';
		
        switch ($style) {
            case 'item-about-client':
                $html .=    '<div class="item-about-client">
                               <div class="client-thumb">
								   <a href="'.esc_url($link).'">
										'.wp_get_attachment_image($image,$size).'
									</a>
								</div>	
                                <div class="client-info">
									<p class="desc">'.esc_html($desc).'</p>
                                    <h3 class="title14"><a href="'.esc_url($link).'" class="color">'.esc_html($name).'</a></h3>
                                    <span class="silver">'.esc_html($info).'</span>
                                </div>
                            </div>';
                break;
            
            default:
                $html .=    '<div class="item-client3 text-center">
								<a class="client-thumb inline-block" href="'.esc_url($link).'">
									'.wp_get_attachment_image($image,$size).'
								</a>
								<p class="desc white">'.esc_html($desc).'</p>
								<hr>
								<span class="color">'.esc_html($info).'</span>
                            </div>';
                break;
        }        
        return $html;
    }
}
stp_reg_shortcode('client_slider_item','s7upf_vc_client_slider_item');

// Banner item
vc_map(
    array(
        'name'     => esc_html__( 'Client Slider Item', 'manu' ),
        'base'     => 'client_slider_item',
        'icon'     => 'icon-st',
        'content_element' => true,
        'as_child' => array('only' => 'carousel_slider'),
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style', 'manu' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Default', 'manu' ) => '',
                    esc_html__( 'About Client', 'manu' ) => 'item-about-client',
				)
            ),  
            array(
                'type'        => 'attach_image',
                'heading'     => esc_html__( 'Client Avatar', 'manu' ),
                'param_name'  => 'image',
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Client Url', 'manu' ),
                'param_name'  => 'link',
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Avatar Size', 'manu' ),
                'param_name'  => 'size',
				'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Client Name', 'manu' ),
                'param_name'  => 'name',
				'dependency'    => array(
					'element'   => 'style',
					'value'   => array('item-about-client'),
				)
            ),
            array(
                "type"          => "textarea",
                "heading"       => esc_html__("Client Review",'manu'),
                "param_name"    => "desc",
            ),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Client Infomation",'manu'),
				"param_name" => "info",
			),
        )
    )
);

/**************************************END ITEM************************************/

/**************************************BEGIN BRAND SLIDER************************************/
//Banner item Frontend
if(!function_exists('s7upf_vc_brand_slider_item'))
{
    function s7upf_vc_brand_slider_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'         => 'default',
            'link'          => '', 
			'size'          => '', 
            'image'         => '',
			'list_image'    => '',
        ),$attr));
		
		if(!empty($size)) $size = explode('x', $size);
        else $size = 'full';
		
        switch ($style) {
			case 'horizontal':
				$data_image = (array) vc_param_group_parse_atts( $list_image );
				$html .=    '<div class="item">';
								if(is_array($data_image)){
									foreach ($data_image as $key => $value){
										if(!empty($value['link'])) {
											$html .= '<div class="item-brand text-center"><a class="wobble-horizontal" href="'.esc_url($value['link']).'">';
												if(!empty($value['image'])) {
													$html .= wp_get_attachment_image($value['image'],$size);
												}
											$html .= '</a></div>';
										}
									}
								}
                 $html .=    '</div>';
				break;
				
            default:
                $html .=    '<div class="item-brand2 text-center">
								<a class="wobble-horizontal" href="'.esc_url($link).'">
									'.wp_get_attachment_image($image,$size).'
								</a>
                            </div>';
                break;
        }        
        return $html;
    }
}
stp_reg_shortcode('brand_slider_item','s7upf_vc_brand_slider_item');

// Banner item
vc_map(
    array(
        'name'     => esc_html__( 'Brand Slider Item', 'manu' ),
        'base'     => 'brand_slider_item',
        'icon'     => 'icon-st',
        'content_element' => true,
        'as_child' => array('only' => 'carousel_slider'),
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style', 'manu' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Default', 'manu' ) => 'default',
                    esc_html__( 'Horizontal', 'manu' ) => 'horizontal',
				)
            ),  
            array(
                'type'        => 'attach_image',
                'heading'     => esc_html__( 'Brand Logo', 'manu' ),
                'param_name'  => 'image',"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('default')
				),
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Brand Logo Size', 'manu' ),
                'param_name'  => 'size',
				'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Brand Url', 'manu' ),
                'param_name'  => 'link',
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('default')
				),
            ),
			array(
				"type" => "param_group",
				"heading" => esc_html__("Add List Item",'manu'),
				"param_name" => "list_image",
				"params"    => array(
					array(
						"type" => "attach_image",
						"heading" => esc_html__("Image",'manu'),
						"param_name" => "image",
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__("Link",'manu'),
						"param_name" => "link",
					),
				),
				"dependency"    =>array(
					'element'   =>'style',
					'value'     =>array('horizontal')
				),
			),
        )
    )
);

/**************************************END ITEM************************************/

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Carousel_slider extends WPBakeryShortCodesContainer {}
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Adv_Slider_item extends WPBakeryShortCode {}    
    class WPBakeryShortCode_Client_Slider_Item extends WPBakeryShortCode {}
    class WPBakeryShortCode_Brand_Slider_Item extends WPBakeryShortCode {}
}