<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 29/02/16
 * Time: 10:00 AM
 */

if(!function_exists('s7upf_vc_blog'))
{
    function s7upf_vc_blog($attr)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'title'         => '',
            'style'         => '',
            'type'          => 'list',
            'number'        => '',
            'masonry'       => 'no',
            'cats'          => '',
            'size'          => '',
            'excerpt'       => '',
            'order'         => '',
            'order_by'      => '',
            'class_extra'   => '',
            'custom_css'    => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		if($type=='grid'){
			$view_type_title = esc_html__('Grid View','manu');
		}else{
			$view_type_title = esc_html__('List View','manu');
		}
		if(isset($_GET['type'])){
			$type = $_GET['type'];
			if($type=='grid'){
				$view_type_title = esc_html__('Grid View','manu');
			}
			if($type=='list'){
				$view_type_title = esc_html__('List View','manu');
			}
			if($type=='full'){
				$view_type_title = esc_html__('List View','manu');
			}
		}
		if(isset($_GET['number'])){
			$number = $_GET['number'];
		}
		
		$load_size = $size;
		if(!empty($size)){
			$size = explode('x', $size);
		}else{
			$size = 'full';
		}
        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
		
        $args=array(
            'post_type'         => 'post',
            'posts_per_page'    => $number,
            'orderby'           => $order_by,
            'order'             => $order,
            'paged'             => $paged,
        );
        if($order_by == 'post_views'){
            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'post_views';
        }
        if($order_by == 'time_update'){
            $args['orderby'] = 'meta_value';
            $args['meta_key'] = 'time_update';
        }
        if($order_by == '_post_like_count'){
            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = '_post_like_count';
        }
        if(!empty($cats)) {
            $custom_list = explode(",",$cats);
            $args['tax_query'][]=array(
                'taxonomy'=>'category',
                'field'=>'slug',
                'terms'=> $custom_list
            );
        }
        $query = new WP_Query($args);
        global $count;
        $count = 1;
        $count_query = $query->post_count;
        $max_page = $query->max_num_pages;
		$html .= '<div class="content-blog-page '.$css_class.' '.$class_extra.'">
					<div class="title-page">
						<div class="row">
							<div class="col-md-12">
								<h2 class="title30 font-bold text-uppercase color2 pull-left">'.esc_html($title).'</h2>
								<ul class="sort-pagi-bar list-inline-block pull-right">
									<li>
										<div class="dropdown-box show-by">
											<a href="javascript:void(0)" class="dropdown-link"><span class="silver">'.esc_html__('Per Page','manu').':</span><span class="shop-show-value show-number-item gray">'.esc_html($number).'</span></a>
											<ul class="dropdown-list list-none">
												<li><a data-number="6" href="'.esc_url(s7upf_get_key_url('number','6')).'">'.esc_html("6","'manu").'</a></li>
												<li><a data-number="9" href="'.esc_url(s7upf_get_key_url('number','9')).'">'.esc_html("9","'manu").'</a></li>
												<li><a data-number="12" href="'.esc_url(s7upf_get_key_url('number','12')).'">'.esc_html("12","'manu").'</a></li>
												<li><a data-number="18" href="'.esc_url(s7upf_get_key_url('number','18')).'">'.esc_html("18","'manu").'</a></li>
												<li><a data-number="24" href="'.esc_url(s7upf_get_key_url('number','24')).'">'.esc_html("24","'manu").'</a></li>
												<li><a data-number="48" href="'.esc_url(s7upf_get_key_url('number','48')).'">'.esc_html("48","'manu").'</a></li>
											</ul>
										</div>
									</li>
									<li>
										<div class="view-type dropdown-box">
											<a href="javascript:void(0)" class="dropdown-link"><span class="silver">'.esc_html__('View As','manu').':</span><span class="gray">'.$view_type_title.'</span></a>
											<ul class="dropdown-list list-none">
												<li><a href="'.esc_url(s7upf_get_key_url('type','grid')).'" class="grid-view">'.esc_html__('Grid View','manu').'</a></li>
												<li><a href="'.esc_url(s7upf_get_key_url('type','list')).'" class="list-view">'.esc_html__('List View','manu').'</a></li>
											</ul>
										</div>
									</li>
								</ul>
							</div>
						</div>
					</div>';
			switch($type){
				case 'list':
					$html .= '<div class="blog-list-view">
								<div class="row">';
						if($query->have_posts()) {
							while($query->have_posts()) {
								$query->the_post();
								$html .= '<div class="col-md-12">'.s7upf_post_item('list',$size,$excerpt).'</div>';
							}
						}
					$html .= 	'</div>
							  </div>';
				break;
				
				case 'full':
					$html .= '<div class="blog-list-view full-image">
								 <div class="row">'; 	
						if($query->have_posts()) {
							while($query->have_posts()) {
								$query->the_post();
								$html .= '<div class="col-md-12">'.s7upf_post_item('full',$size,$excerpt).'</div>';
							}
						}
					$html .= 	  '</div>
							  </div>';
				break;
					
				case 'grid':
					$size = array(370,247);
					if($masonry == 'yes'){
						$html .= '<div class="blog-grid-view masonry-grid-view">
									<div class="row">';
							if($query->have_posts()) {
								while($query->have_posts()) {
									$count++;
									$query->the_post();
									$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2',$size,$excerpt).'</div>';
								}
							}
						$html .= 	'</div>
								</div>';
					}else{
						$html .= '<div class="blog-grid-view">
									<div class="row">';
							if($query->have_posts()) {
								while($query->have_posts()) {
									$count++;
									$query->the_post();
									if($count%2==0){
										$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2',$size,$excerpt).'</div>';
									}else{
										$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2-2',$size,$excerpt).'</div>';
									}	
								}
							}
						$html .= 	'</div>
								</div>';
					}			
					
				break;
				
			}
			wp_reset_postdata();
			if($style == 'loadmore'){
				if($max_page > 1) $html .=        '<a href="#" class="btn-border btn-load-more btn-load-more-post" data-hover="'.esc_html__('Load more','manu').'" data-number="'.esc_attr($number).'" data-order="'.esc_attr($order).'" data-orderby="'.esc_attr($order_by).'" data-cats="'.esc_attr($cats).'" data-type="'.esc_attr($type).'" data-size="'.esc_attr($load_size).'" data-excerpt="'.esc_attr($excerpt).'" data-paged="1" data-maxpage="'.esc_attr($max_page).'">'.esc_html__('Load more','manu').'</a>';
			}else{
				$big = 999999999;
				$html .=        '<div class="pagi-nav text-center">';
				$html .=            paginate_links( array(
										'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
										'format'       => '&page=%#%',
										'current'      => max( 1, $paged ),
										'total'        => $query->max_num_pages,
										'prev_text' => '<i class="icon ion-android-arrow-back"></i>',
										'next_text' => '<i class="icon ion-android-arrow-forward"></i>',
										'end_size'     => 2,
										'mid_size'     => 1
									) );        
				$html .=        '</div>';
			}	
        $html .= '</div>';
        return $html;
    }
}

stp_reg_shortcode('sv_blog','s7upf_vc_blog');

vc_map( array(
    "name"      => esc_html__("Manu Blog", 'manu'),
    "base"      => "sv_blog",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "textfield",
            "heading" => esc_html__("Title Page",'manu'),
            "param_name" => "title",
        ), 
        array(
            "type"          => "dropdown",
            "holder"        => "div",
            "heading"       => esc_html__("Blog Style",'manu'),
            "param_name"    => "style",
            "value"         => array(
                esc_html__("Default","'manu")         => '',
                esc_html__("Load More","'manu")       => 'loadmore',
			),
        ), 
        array(
            "type"          => "dropdown",
            "holder"        => "div",
            "heading"       => esc_html__("Post Style",'manu'),
            "param_name"    => "type",
            "value"         => array(
                esc_html__("List","'manu")         => 'list',
                esc_html__("Grid","'manu")         => 'grid',
                esc_html__("Full","'manu")         => 'full',
			),
            'description'   => esc_html__( 'Choose style to display.', 'manu' ),
        ), 
        array(
            "type"          => "dropdown",
            "holder"        => "div",
            "heading"       => esc_html__("Grid Masonry",'manu'),
            "param_name"    => "masonry",
            "value"         => array(
                esc_html__("No","'manu")         => 'no',
                esc_html__("Yes","'manu")        => 'yes',
			),
            "dependency"    =>array(
				'element'   =>'type',
				'value'     =>array('grid')
			),
        ), 
        array(
            "type" => "textfield",
            "heading" => esc_html__("Number post",'manu'),
            "param_name" => "number",
            'description'   => esc_html__( 'Number of post display in this element. Default is 10.', 'manu' ),
        ),  
        array(
            'type'        => 'textfield',
            'heading'     => esc_html__( 'Excerpt', 'manu' ),
            'param_name'  => 'excerpt',
            'description'   => esc_html__( 'Enter number character for post excerpt', 'manu' ),
        ),
        array(
            'type'        => 'textfield',
            'heading'     => esc_html__( 'Thumb Size', 'manu' ),
            'param_name'  => 'size',
            'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
        ),  
        array(
            'holder'     => 'div',
            'heading'     => esc_html__( 'Categories', 'manu' ),
            'type'        => 'checkbox',
            'param_name'  => 'cats',
            'value'       => s7upf_list_taxonomy('category',false)
        ),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Order",'manu'),
            "param_name"    => "order",
            "value"         => array(
                esc_html__('Desc','manu') => 'DESC',
                esc_html__('Asc','manu')  => 'ASC',
			),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        ),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Order By",'manu'),
            "param_name"    => "order_by",
            "value"         => s7upf_get_order_list(),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        ),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'Custom Css', 'manu' ),
			'param_name' => 'custom_css',
			'group' => esc_html__( 'Design options', 'manu' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Class Extra', 'manu' ),
			'param_name' => 'class_extra',
			'group' => esc_html__( 'Design options', 'manu' ),
		),
    )
));

add_action( 'wp_ajax_load_more_post', 's7upf_load_more_post' );
add_action( 'wp_ajax_nopriv_load_more_post', 's7upf_load_more_post' );
if(!function_exists('s7upf_load_more_post')){
    function s7upf_load_more_post() {
		$type           = $_POST['type'];
		$size           = $_POST['size'];
		if(!empty($size)){
			$size = explode('x', $size);
		}else{
			$size = 'full';
		}
		$excerpt        = $_POST['excerpt'];
        $orderby        = $_POST['orderby'];
        $order          = $_POST['order'];
        $cats           = $_POST['cats'];
		$number         = $_POST['number'];
		$paged          = $_POST['paged'];
        $html = '';
        $args   =   array(
            'post_type'         => 'post',
            'posts_per_page'    => $number,
            'orderby'           => $orderby,
            'order'             => $order,
            'paged'             => $paged + 1,
        );
        if($order_by == 'post_views'){
            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = 'post_views';
        }
        if($order_by == 'time_update'){
            $args['orderby'] = 'meta_value';
            $args['meta_key'] = 'time_update';
        }
        if($order_by == '_post_like_count'){
            $args['orderby'] = 'meta_value_num';
            $args['meta_key'] = '_post_like_count';
        }
        if(!empty($cats)) {
            $custom_list = explode(",",$cats);
            $args['tax_query']['relation'] = 'AND';
            $args['tax_query'][]=array(
                'taxonomy'  => 'category',
                'field'     => 'slug',
                'terms'     => $custom_list
            );
        }        
        $query = new WP_Query($args);
        global $count;
        $count = 1;
        $count_query = $query->post_count;
        
		switch($type){
			case 'list':
				if($query->have_posts()) {
					while($query->have_posts()) {
						$query->the_post();
						$html .= '<div class="col-md-12">'.s7upf_post_item('list',$size,$excerpt).'</div>';
					}
				}
			break;
			
			case 'full':
				if($query->have_posts()) {
					while($query->have_posts()) {
						$query->the_post();
						$html .= '<div class="col-md-12">'.s7upf_post_item('full',$size,$excerpt).'</div>';
					}
				}
			break;
				
			case 'grid':
				$size = array(370,247);
				if($masonry == 'yes'){
					if($query->have_posts()) {
						while($query->have_posts()) {
							$count++;
							$query->the_post();
							$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2',$size,$excerpt).'</div>';
						}
					}
				}else{
					if($query->have_posts()) {
						while($query->have_posts()) {
							$count++;
							$query->the_post();
							if($count%2==0){
								$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2',$size,$excerpt).'</div>';
							}else{
								$html .= '<div class="col-md-4 col-sm-6 col-xs-6">'.s7upf_post_item('style2-2',$size,$excerpt).'</div>';
							}	
						}
					}
				}			
				
			break;
			
		}
        echo apply_filters('s7upf_output_content',$html);
        wp_reset_postdata();
		die();
    }
}