<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 31/08/15
 * Time: 10:00 AM
 */
if(!function_exists('s7upf_vc_banner_slider'))
{
    function s7upf_vc_banner_slider($attr, $content = false)
    {
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style' => '',
            'autoplay' => 'false',
            'pagination' => 'false',
            'navigation' => 'false',
            'transition' => '',
			'control_nav'     => '',
            'custom_css' => '',
			'class_extra' => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
        $html .=    '<div class="banner-slider '.$css_class.' '.esc_attr($class_extra).' '.esc_attr($style).'">';
        $html .=        '<div class="wrap-item '.esc_attr($control_nav).'" data-autoplay="'.esc_attr($autoplay).'" data-pagination="'.esc_attr($pagination).'" data-navigation="'.esc_attr($navigation).'" data-transition="'.esc_attr($transition).'" data-itemscustom="[[0,1]]">';
        $html .=            wpb_js_remove_wpautop($content, false);
        $html .=        '</div>';
        $html .=    '</div>';
        return $html;
    }
}
stp_reg_shortcode('banner_slider','s7upf_vc_banner_slider');
vc_map(
    array(
        'name'     => esc_html__( 'SV Banner Slider', 'manu' ),
        'base'     => 'banner_slider',
        'category' => esc_html__( '7Up-theme', 'manu' ),
        'icon'     => 'icon-st',
        'as_parent' => array( 'only' => 'banner_slider_item' ),
        'content_element' => true,
        'js_view' => 'VcColumnView',
        'params'   => array(   
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Banner Style', 'manu' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Default', 'manu' )                  => '',
                    esc_html__( 'Banner Background', 'manu' )      => 'bg-slider',
                    esc_html__( 'Banner Background Parallax', 'manu' )      => 'bg-slider parallax-slider',
                ),
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Slider Transition', 'manu' ),
                'param_name'  => 'transition',
                'value'       => array(
                    esc_html__( 'None', 'manu' )        => '',
                    esc_html__( 'Fade', 'manu' )        => 'fade',
                    esc_html__( 'BackSlide', 'manu' )   => 'backSlide',
                    esc_html__( 'GoDown', 'manu' )      => 'goDown',
                    esc_html__( 'FadeUp', 'manu' )      => 'fadeUp',
                    )
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Navigation Control', 'manu' ),
                'param_name'  => 'navigation',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Pagination Control', 'manu' ),
                'param_name'  => 'pagination',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Auto Play Control', 'manu' ),
                'param_name'  => 'autoplay',
                'value'       => array(
                    esc_html__( 'False', 'manu' )        => 'false',
                    esc_html__( 'True', 'manu' )        => 'true',
                    )
            ),
			array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style Control Nav', 'manu' ),
                'param_name'  => 'control_nav',
                'value'       => array(
                    esc_html__( 'Default', 'manu' )                => '',
                    esc_html__( 'Pagination Border', 'manu' )      => 'pagi-white',
                    )
            ),
            array(
                "type"          => "css_editor",
                "heading"       => esc_html__("Custom Style",'manu'),
                "param_name"    => "custom_css",
                'group'         => esc_html__('Design Option','manu')
            ),
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Class Extra', 'manu' ),
                'param_name'  => 'class_extra',
				'group'         => esc_html__('Design Option','manu')
            ),
        )
    )
);

/*******************************************END MAIN*****************************************/


/**************************************BEGIN ITEM************************************/
//Banner item Frontend
if(!function_exists('s7upf_vc_banner_slider_item'))
{
    function s7upf_vc_banner_slider_item($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'         => '',
            'image'         => '',
            'link'          => '', 
			'effect'		=> '',
			'class_extra'   => '',
        ),$attr));
		$info_class = "";
        if(!empty($image)){
            if(!empty($effect)) $info_class .= 'animated';
            
			$html .=        '<div class="item-slider '.esc_attr($style).'">
							    <div class="banner-thumb">
								    <a href="'.esc_url($link).'"><img src="'.wp_get_attachment_url($image).'" alt="" /></a>
							    </div>';
			if(!empty($content)){
				switch ($style){
					
					case 'item-slider1':
					
						$html .=	'<div class="banner-info text-center white '.esc_attr($class_extra).' '.esc_attr($info_class).'" data-animated="'.esc_attr($effect).'">
										<div class="container">';
						$html .=			wpb_js_remove_wpautop($content, true);
						$html .=		'</div>
									</div>';
					
						break;
					
					case 'item-slider2':
					
						$html .=	'<div class="banner-info text-center '.esc_attr($class_extra).'">
										<div class="container">';
						$html .=			wpb_js_remove_wpautop($content, true);
						$html .=		'</div>
									</div>';
					
						break;
					
					case 'item-slider3':
					
						$html .=	'<div class="banner-info white font-bold text-center '.esc_attr($class_extra).' '.esc_attr($info_class).'" data-animated="'.esc_attr($effect).'">';
						$html .=		wpb_js_remove_wpautop($content, true);
						$html .=	'</div>';
					
						break;
					
					case 'item-slider4':
					
						$html .=	'<div class="banner-info text-center white '.esc_attr($class_extra).' '.esc_attr($info_class).'" data-animated="'.esc_attr($effect).'">';
						$html .=		wpb_js_remove_wpautop($content, true);
						$html .=	'</div>';
					
						break;
					
					case 'default':
					
						$html .=	'<div class="banner-info '.esc_attr($info_class).' '.esc_attr($class_extra).'" data-animated="'.esc_attr($effect).'">
										<div class="container">';
						$html .=			wpb_js_remove_wpautop($content, true);
						$html .=		'</div>
									</div>';
					
						break;
				}
			}
			$html .=         '</div>';
        }
        return $html;
    }
}
stp_reg_shortcode('banner_slider_item','s7upf_vc_banner_slider_item');

// Banner item
vc_map(
    array(
        'name'     => esc_html__( 'Banner Item', 'manu' ),
        'base'     => 'banner_slider_item',
        'icon'     => 'icon-st',
        'content_element' => true,
        'as_child' => array('only' => 'banner_slider'),
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Style', 'manu' ),
                'param_name'  => 'style',
                'value'       => array(
                    esc_html__( 'Default', 'manu' )      => '',
                    esc_html__( 'Style Home 1', 'manu' ) => 'item-slider1',
                    esc_html__( 'Style Home 2', 'manu' ) => 'item-slider2',
                    esc_html__( 'Style Home 3', 'manu' ) => 'item-slider3',
                    esc_html__( 'Style Home 4', 'manu' ) => 'item-slider4',
                    )
            ),            
            array(
                'type'        => 'attach_image',
                'heading'     => esc_html__( 'Image Background', 'manu' ),
                'param_name'  => 'image',
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Link Banner', 'manu' ),
                'param_name'  => 'link',
            ),
            array(
                'type'        => 'animation_style',
                'heading'     => esc_html__( 'Content Effect', 'manu' ),
                'param_name'  => 'effect',
            ),  
            array(
                "type" => "textarea_html",
                "holder" => "div",
                "heading" => esc_html__("Content",'manu'),
                "param_name" => "content",
            ),    
			array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Class Extra', 'manu' ),
                'param_name'  => 'class_extra',
            ),
        )
    )
);

/**************************************END ITEM************************************/

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Banner_Slider extends WPBakeryShortCodesContainer {}
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Banner_Slider_Item extends WPBakeryShortCode {}    
}