<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */
if(!function_exists('s7upf_vc_banner_background')){
    function s7upf_vc_banner_background($attr,$content = false){
        $html = $css_class = '';
        extract(shortcode_atts(array(
            'style'            => '',
            'background'       => '',
			'size'             => '', 
            'image'            => '',
            'date'             => '',
            'attachment'       => 'banner-background',
            'class_extra'      => '',
            'custom_css'       => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		if(!empty($size)){
			$size = explode('x', $size);
		}else{
			$size = 'full';
		}
        switch ($style) {
            case 'countdown':
                $html .=    '<div class="deal-banner4 '.$css_class.' '.esc_attr($attachment).' '.esc_attr($class_extra).'" data-image="'.esc_url(wp_get_attachment_url($background)).'">
                                <div class="container">
                                	<div class="content-deal4">';
										if(!empty($image)) $html .='<div class="deal-saleoff4">'.wp_get_attachment_image($image).'</div>';
										$text='[&quot;'.esc_html__("Day","manu").'&quot;,&quot;'.esc_html__("Hou","manu").'&quot;,&quot;'.esc_html__("Min","manu").'&quot;,&quot;'.esc_html__("Sec","manu").'&quot;]';
										if(!empty($date))  $html .='<div class="time-countdown deal-time deal-clock4" data-date="'.esc_attr($date).'" data-color="#25c0f6" data-bg="#8f9091" data-width="0.03" data-text="'.esc_attr($text).'"></div>';
					$html .=    	    '<div class="intro-deal4 white">'.wpb_js_remove_wpautop($content, true).'</div>
									</div>
                                </div>
                            </div>';
                break;
			
            default:        
                $html .=    '<div class="'.esc_attr($attachment).' '.$css_class.' '.esc_attr($class_extra).'" data-image="'.esc_url(wp_get_attachment_url($background)).'">
                                <div class="container">
                                    '.wpb_js_remove_wpautop($content, true).'
                                </div>
                            </div>';
                break;
        }
        return $html;
    }
}

stp_reg_shortcode('sv_banner_background','s7upf_vc_banner_background');

vc_map( array(
	"name"      => esc_html__("Manu Banner Background", 'manu'),
	"base"      => "sv_banner_background",
	"icon"      => "icon-st",
	"category"  => '7Up-theme',
	"params"    => array(
		array(
			"type" => "dropdown",
			"heading" => esc_html__("Style",'manu'),
			"param_name" => "style",
			"value"     => array(
				esc_html__("Default",'manu')   => '',
				esc_html__("Timer Countdown",'manu')   => 'countdown',
			)
		),
		array(
			"type" => "attach_image",
			"heading" => esc_html__("Background Image",'manu'),
			"param_name" => "background",
		),
		array(
			"type" => "dropdown",
			"heading" => esc_html__("Background Attchment",'manu'),
			"param_name" => "attachment",
			"value"     => array(
				esc_html__("Default",'manu')   => 'banner-background',
				esc_html__("Parallax",'manu')   => 'parallax',
			)
		),
		array(
			"type" => "attach_image",
			"heading" => esc_html__("Image",'manu'),
			"param_name" => "image",
			"dependency"    => array(
				"element"   => "style",
				"value"   => array('countdown'),
			),
		),
		array(
			"type"          => "textfield",
			"heading"       => esc_html__("Image Size",'manu'),
			"param_name"    => "size",
			'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
			"dependency"    => array(
				"element"   => "style",
				"value"   => array('countdown'),
			),
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__("Data Date",'manu'),
			"param_name" => "date",
			'description'   => esc_html__( 'Enter time countdown. Date Format:(mm/dd/yy)', 'manu' ),
			"dependency"    => array(
				"element"   => "style",
				"value"   => array('countdown'),
			),
		),  
		array(
			"type" => "textarea_html",
			"holder" => "div",
			"heading" => esc_html__("Content",'manu'),
			"param_name" => "content",
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'Custom Css', 'manu' ),
			'param_name' => 'custom_css',
			'group' => esc_html__( 'Design options', 'manu' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Class Extra', 'manu' ),
			'param_name' => 'class_extra',
			'group' => esc_html__( 'Design options', 'manu' ),
		),
	)
));
