<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('s7upf_vc_banner_advert'))
{
    function s7upf_vc_banner_advert($attr,$content = false)
    {
        $html = $img_html = $css_class = '';
        extract(shortcode_atts(array(
            'style'            => '',
            'sub_title'        => '',
            'title'            => '',
			'size'             => '', 
            'image'            => '',
            'second_image'     => '',
            'link'             => '',
            'desc'             => '',
            'direct'           => 'ver',
            'list_icon'        => '',
            'animation'        => '',
            'class_extra'      => '',
            'custom_css'       => '',
        ),$attr));
		if(!empty($list_icon)) $data_icon  = (array) vc_param_group_parse_atts( $list_icon );
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		if(!empty($size)){
			$size = explode('x', $size);
		}else{
			$size = 'full';
		}
		$img_html = wp_get_attachment_image($image,$size);
		if($animation=='zoom-out'){
			if(empty($second_image)){
				$img_html .= wp_get_attachment_image($image,$size);
			}else{
				$img_html .= wp_get_attachment_image($second_image,$size);
			}
		}
        switch ($style) {
            case 'large':
                $html .=    '<div class="banner-image2 banner-adv '.$css_class.' '.esc_attr($animation).' '.esc_attr($class_extra).'">
                                <a href="'.esc_url($link).'" class="adv-thumb-link">
									'.$img_html.'
								</a>
								<div class="banner-info white text-center">
									'.wpb_js_remove_wpautop($content, true).'
								</div>
                            </div>';
                break;
			
            case 'video':
                $html .=    '<div class="banner-video3 banner-adv '.$css_class.' '.esc_attr($animation).' '.esc_attr($class_extra).'">
                                <a href="'.esc_url($link).'" class="adv-thumb-link">
									'.$img_html.'
								</a>
                            </div>';
                break;
			
            case 'social':
				$col_thumb = $col_info = 'col-md-12 col-md-12 col-xs-12';
				if($direct=='ver'){
					$col_thumb = 'col-md-7 col-sm-12 col-xs-6';
					$col_info = 'col-md-5 col-sm-12 col-xs-6';
				}
                $html .=    '<div class="item-adv4 '.esc_attr($direct).' '.$css_class.' '.esc_attr($class_extra).'">
								<div class="row">
									<div class="'.$col_thumb.'">
										<div class="banner-adv zoom-out">
											<a href="'.esc_url($link).'" class="adv-thumb-link">
												'.$img_html.'
											</a>
										</div>
									</div>
									<div class="'.$col_info.'">
										<div class="adv-info">';
											if(!empty($title)){
												$html .='<strong class="title60 title-index">'.esc_html($title).'</strong>';
											}	
				$html .=                    wpb_js_remove_wpautop($content, true);
											if(!empty($data_icon)){
				$html .=					'<div class="social-network3">';
												foreach ($data_icon as $key => $value){
													if(!empty($value['link'])) {
														$html .= '<a class="white title18 float-shadow" href="'.esc_url($value['link']).'">';
															if(!empty($value['icon'])) {
																$html .= '<i class="'.$value['icon'].'"></i>';
															}
														$html .= '</a>';
													}
												}
				$html .=    				'</div>';
											}
				$html .=					'</div>
									</div>
								</div>
							</div>';
                break;
			
            case 'item-adv3':
                $html .=    '<div class="item-adv3 banner-adv '.$css_class.' '.esc_attr($animation).' '.esc_attr($class_extra).'">
                                <a href="'.esc_url($link).'" class="adv-thumb-link">
									'.$img_html.'
									<div class="banner-info white text-uppercase">
										'.wpb_js_remove_wpautop($content, true).'
									</div>
								</a>
                            </div>';
                break;
			
            case 'item-offer3':
                $html .=    '<div class="item-offer3 text-center '.$css_class.' '.esc_attr($class_extra).'">
								<h3 class="title18 text-uppercase font-bold">'.esc_html($title).'</h3>
								<h4 class="title14 text-uppercase white bg-color inline-block">'.esc_html($sub_title).'</h4>
								<div class="banner-adv '.esc_attr($animation).'">
									<a href="'.esc_url($link).'" class="adv-thumb-link">
										'.$img_html.'
									</a>
								</div>
								<p class="desc">'.esc_html($desc).'</p>
								<a href="'.esc_url($link).'" class="shop-button bg-color">'.esc_html__('Shop now','manu').'</a>
							</div>';
                break;

            default:        
                $html .=    '<div class="banner-adv '.$css_class.' '.esc_attr($animation).' '.esc_attr($class_extra).'">
                                <div class="adv-thumb">
                                    <a href="'.esc_url($link).'" class="adv-thumb-link">
                                        '.$img_html.'
                                    </a>
									<div class="banner-info">
										'.wpb_js_remove_wpautop($content, true).'
									</div>
                                </div>
                            </div>';
                break;
        }
        return $html;
    }
}

stp_reg_shortcode('sv_banner_advert','s7upf_vc_banner_advert');

$check_add = '';
if(isset($_GET['return'])) $check_add = $_GET['return'];
if(empty($check_add)) add_action( 'vc_before_init_base','sv_add_banner_advert',10,100 );
if ( ! function_exists( 'sv_add_banner_advert' ) ) {
	function sv_add_banner_advert(){
		vc_map( array(
			"name"      => esc_html__("Manu Banner Advert", 'manu'),
			"base"      => "sv_banner_advert",
			"icon"      => "icon-st",
			"category"  => '7Up-theme',
			"params"    => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Style",'manu'),
					"param_name" => "style",
					"value"     => array(
						esc_html__("Default",'manu')   => 'default',
						esc_html__("Large Banner",'manu')   => 'large',
						esc_html__("Video Banner",'manu')   => 'video',
						esc_html__("Adv Home 3",'manu')   => 'item-adv3',
						esc_html__("Banner Category",'manu')   => 'item-offer3',
						esc_html__("Social Network",'manu')   => 'social',
					)
				),
				array(
					"type"          => "textfield",
					"heading"       => esc_html__("Image Size",'manu'),
					"param_name"    => "size",
					'description'   => esc_html__( 'Enter site thumbnail to crop. [width]x[height]. Example is 300x300', 'manu' ),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__("Image",'manu'),
					"param_name" => "image",
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Link",'manu'),
					"param_name" => "link",
				),  
				array(
					"type" => "textfield",
					"heading" => esc_html__("Title",'manu'),
					"param_name" => "title",
					"dependency"    => array(
						"element"   => "style",
						"value"   => array('item-offer3','social'),
					),
				), 
				array(
					"type" => "textfield",
					"heading" => esc_html__("Sub Title",'manu'),
					"param_name" => "sub_title",
					"dependency"    => array(
						"element"   => "style",
						"value"   => array('item-offer3'),
					)
				), 
				array(
					"type" => "textfield",
					"heading" => esc_html__("Description",'manu'),
					"param_name" => "desc",
					"dependency"    => array(
						"element"   => "style",
						"value"   => array("item-offer3"),
					),
				), 
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Adv Direct",'manu'),
					"param_name" => "direct",
					"value"     => array(
						esc_html__("Horizontal",'manu')   => 'ver',
						esc_html__("Vertical",'manu')   => 'hoz',
					),
					"dependency"    => array(
						"element"   => "style",
						"value"   => array("social"),
					),
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Animation",'manu'),
					"param_name" => "animation",
					"value"     => array(
						esc_html__("Default",'manu')   => '',
						esc_html__("Zoom",'manu')   => 'zoom-image',
						esc_html__("Pull Curtain",'manu')   => 'pull-curtain',
						esc_html__("Zoom Out",'manu')   => 'zoom-out',
						esc_html__("Fade Out-In",'manu')   => 'fade-out-in',
						esc_html__("Fade In-Out",'manu')   => 'fade-in-out',
						esc_html__("Zoom Fade Out-In",'manu')   => 'zoom-image fade-out-in',
						esc_html__("Zoom Rotate",'manu')   => 'zoom-rotate',
						esc_html__("Zoom Rotate Fade Out-In",'manu')   => 'zoom-rotate fade-out-in',
						esc_html__("Overlay",'manu')   => 'overlay-image',
						esc_html__("Overlay Zoom",'manu')   => 'overlay-image zoom-image',
						esc_html__("Line Scale",'manu')   => 'line-scale',
						esc_html__("Zoom Line Scale",'manu')   => 'zoom-image line-scale',
						esc_html__("Zoom Fly Horizontal",'manu')   => 'zoom-image fly-hoz',
					),
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__("Second Image",'manu'),
					"param_name" => "second_image",
					"dependency"    => array(
						"element"   => "animation",
						"value"   => array("zoom-out"),
					),
				),
				array(
					"type"          => "vc_link",
					"heading"       => esc_html__("Button",'manu'),
					"param_name"    => "button",
					"dependency"    => array(
						"element"   => "style",
						"value"   => array('abc'),
					)
				),
				array(
					"type" => "param_group",
					"heading" => esc_html__("Add List Icon",'manu'),
					"param_name" => "list_icon",
					"params"    => array(
						array(  
							'type' => 'iconpicker' ,
							'heading' => esc_html__('Icon', 'manu'),
							'param_name' => 'icon',
							'value' => '', // default value to backend editor admin_label
							'settings' => array(
								'emptyIcon' => false,
								'type' => 'ionicon',
								'iconsPerPage' => 100,
							),
							'description' =>  esc_html__( 'Select icon from Ion icon library.', 'manu' ),
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__("Link",'manu'),
							"param_name" => "link",
						),
					),
					"dependency"    =>array(
						'element'   =>'style',
						'value'     =>array('social')
					),
				),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"heading" => esc_html__("Content",'manu'),
					"param_name" => "content",
					"dependency"    => array(
						"element"   => "style",
						"value"   => array('default','large','item-adv3','social'),
					)
				),
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'Custom Css', 'manu' ),
					'param_name' => 'custom_css',
					'group' => esc_html__( 'Design options', 'manu' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Class Extra', 'manu' ),
					'param_name' => 'class_extra',
					'group' => esc_html__( 'Design options', 'manu' ),
				),
			)
		));
	}
}	