<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */
if(!function_exists('s7upf_vc_accordion'))
{
    function s7upf_vc_accordion($attr, $content = false)
    {
        $html = $list_html = $css_class = '';
        extract(shortcode_atts(array(
            'style'          => '',
            'title'          => '',
            'list'           => '',
            'class_extra'    => '',
			'custom_css'     => '',
        ),$attr));
		if(!empty($custom_css)) $css_class = vc_shortcode_custom_css_class( $custom_css );
		$data = (array) vc_param_group_parse_atts( $list );
		
		switch ($style) {
			
            case 'faq-accordion':
				if(is_array($data)){
					$active="";
					if(is_array($data)){
						foreach ($data as $key => $value) {
							if($key==0){$class="active";}
							$list_html .=   '<div class="item-toggle-tab '.$active.'">
												<h3 class="toggle-tab-title title14">'.esc_html($value['title']).'</h3>
												<p class="desc toggle-tab-content">'.esc_html($value['desc']).'</p>
											</div>';
						}
					}
					$html .=    '<div class="block-faq '.$css_class.' '.esc_attr($class_extra).'">';
					if(!empty($title)) $html .=    	'<h2 class="title18 font-bold text-uppercase">'.esc_html($title).'</h2>';
					$html .=    	'<div class="toggle-tab '.esc_attr($style).'">';
					$html .=       		 $list_html;
					$html .=    	'</div>';
					$html .=    '</div>';
                }
                
			break;

			
            case 'contact-accordion':
				if(is_array($data)){
					$active="";
					if(is_array($data)){
						foreach ($data as $key => $value) {
							if($key==0){$class="active";}
							$list_html .=   '<div class="item-toggle-tab '.$active.'">
												<h2 class="toggle-tab-title navi">'.esc_html($value['title']).'</h2>
												<p class="desc toggle-tab-content">'.esc_html($value['desc']).'</p>
											</div>';
						}
					}
					$html .=    '<div class="contact-faq '.$css_class.' '.esc_attr($class_extra).'">';
					if(!empty($title)) $html .=    	'<h2 class="title18 navi font-bold text-uppercase rale-font">'.esc_html($title).'</h2>';
					$html .=    	'<div class="toggle-tab '.esc_attr($style).'">';
					$html .=       		 $list_html;
					$html .=    	'</div>';
					$html .=    '</div>';
                }
                
			break;

            case 'about-accordion':
				if(is_array($data)){
					$active="";
					if(is_array($data)){
						foreach ($data as $key => $value) {
							if($key==0){$active="active";}
							$list_html .=   '<div class="item-toggle-tab '.$active.'">
												<div class="toggle-tab-title"><span class="bg-color"><i class="'.$value['icon'].'"></i></span><h2 class="navi">'.esc_html($value['title']).'</h2></div>
												<p class="desc toggle-tab-content">'.esc_html($value['desc']).'</p>
											</div>';
						}
					}
					$html .=    '<div class="about-why-choise '.$css_class.' '.esc_attr($class_extra).'">';
					if(!empty($title)) $html .=    	'<h2 class="title18 navi font-bold text-uppercase rale-font">'.esc_html($title).'</h2>';
					$html .=    	'<div class="toggle-tab '.esc_attr($style).'">';
					$html .=       		 $list_html;
					$html .=    	'</div>';
					$html .=    '</div>';
                }
                
			break;

            default:        
                if(is_array($data)){
					$active="";
					if(is_array($data)){
						foreach ($data as $key => $value) {
							if($key==0){$active="active";}
							$list_html .=   '<div class="item-toggle-tab '.$active.'">
												<h2 class="title18 toggle-tab-title">'.esc_html($value['title']).'</h2>
												<p class="desc toggle-tab-content">'.esc_html($value['desc']).'</p>
											</div>';
						}
					}
					$html .=    	'<div class="toggle-tab '.esc_attr($class_extra).'">';
					$html .=       		 $list_html;
					$html .=    	'</div>';
                }
			break;
        }
        return $html;
    }
}

stp_reg_shortcode('sv_accordion','s7upf_vc_accordion');


vc_map( array(
    "name"      => esc_html__("Manu Accordion", 'manu'),
    "base"      => "sv_accordion",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
		array(
			'type' => 'dropdown',
			'admin_label' => true,
			'heading' => esc_html__( 'Style', 'manu' ),
			'param_name' => 'style',
			'value' => array(
				esc_html__('Default','manu')=>'',
				esc_html__('Faq Accordion','manu')=>'faq-accordion',
				esc_html__('Contact Accordion','manu')=>'contact-accordion',
				esc_html__('About Accordion','manu')=>'about-accordion',
			),
		),
        array(
			"type" => "textfield",
			"heading" => esc_html__("Title",'manu'),
			"param_name" => "title",
		),
		array(
            "type" => "param_group",
            "heading" => esc_html__("Add List Accordion",'manu'),
            "param_name" => "list",
            "params"    => array(
				array(  
					'type' => 'iconpicker' ,
					'heading' => esc_html__('Icon', 'manu'),
					'param_name' => 'icon',
					'value' => '', // default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						'type' => 'ionicon',
						'iconsPerPage' => 100,
					),
				),
                array(
                    "type" => "textfield",
                    "heading" => esc_html__("Title",'manu'),
                    "param_name" => "title",
                ),
                array(
                    "type" => "textarea",
                    "heading" => esc_html__("Content",'manu'),
                    "param_name" => "desc",
                ),
            ),
        ),
		array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Custom Style', 'manu' ),
            'param_name' => 'custom_css',
            'group' => esc_html__( 'Design options', 'manu' ),
        ),
		array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Class Extra', 'manu' ),
            'param_name' => 'class_extra',
            'group' => esc_html__( 'Design options', 'manu' ),
        ),
    )
));