<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */

add_action('admin_init', 's7upf_custom_meta_boxes');
if(!function_exists('s7upf_custom_meta_boxes')){
    function s7upf_custom_meta_boxes(){
        //Format content
        $format_metabox = array(
            'id' => 'block_format_content',
            'title' => esc_html__('Format Settings', 'manu'),
            'desc' => '',
            'pages' => array('post'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(                
                array(
                    'id' => 'format_image',
                    'label' => esc_html__('Upload Image', 'manu'),
                    'type' => 'upload',
                ),
                array(
                    'id' => 'format_gallery',
                    'label' => esc_html__('Add Gallery', 'manu'),
                    'type' => 'Gallery',
                ),
                array(
                    'id' => 'format_media',
                    'label' => esc_html__('Link Media', 'manu'),
                    'type' => 'text',
                )
            ),
        );
		//Sub Title
        $sub_title_metabox = array(
            'id' => 'post_sub_title',
            'title' => esc_html__('Sub Title', 'manu'),
            'desc' => '',
            'pages' => array('post'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(      
                array(
                    'id' => 'sub_title',
                    'type' => 'text',
                )
            ),
        );
        // SideBar
    	$sidebar_metabox_default = array(
            'id'        => 's7upf_sidebar_option',
            'title'     => 'Advanced Settings',
            'desc'      => '',
            'pages'     => array( 'page','post','product'),
            'context'   => 'side',
            'priority'  => 'low',
            'fields'    => array(
                array(
                    'id'          => 's7upf_sidebar_position',
                    'label'       => esc_html__('Sidebar position ','manu'),
                    'type'        => 'select',
                    'std' => '',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','manu'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('No Sidebar','manu'),
                            'value'=>'no'
                        ),
                        array(
                            'label'=>esc_html__('Left sidebar','manu'),
                            'value'=>'left'
                        ),
                        array(
                            'label'=>esc_html__('Right sidebar','manu'),
                            'value'=>'right'
                        ),
                    ),

                ),
                array(
                    'id'        =>'s7upf_select_sidebar',
                    'label'     =>esc_html__('Selects sidebar','manu'),
                    'type'      =>'sidebar-select',
                    'condition' => 's7upf_sidebar_position:not(no),s7upf_sidebar_position:not()',
                ),
                array(
                    'id'          => 's7upf_show_breadrumb',
                    'label'       => esc_html__('Show Breadcrumb','manu'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','manu'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('Yes','manu'),
                            'value'=>'on'
                        ),
                        array(
                            'label'=>esc_html__('No','manu'),
                            'value'=>'off'
                        ),
                    ),

                ),
				array(
                    'id'          => 's7upf_header_page',
                    'label'       => esc_html__('Choose page header','manu'),
                    'type'        => 'select',
                    'choices'     => s7upf_list_post_type('s7upf_header')
                ),
                array(
                    'id'          => 's7upf_footer_page',
                    'label'       => esc_html__('Choose page footer','manu'),
                    'type'        => 'select',
                    'choices'     => s7upf_list_post_type('s7upf_footer')
                ),       
            )
        );   
		//Product
        $product_trendding = array(
            'id' => 'product_trendding',
            'title' => esc_html__('Product Type', 'manu'),
            'desc' => '',
            'pages' => array('product'),
            'context' => 'side',
            'priority' => 'high',
            'fields' => array(                
                array(
                    'id'    => 'trending_product',
                    'label' => esc_html__('Product Trendding', 'manu'),
                    'type'        => 'on-off',
                    'std'         => 'off'
                ),
            ),
        );
		$product_extra_desc = array(
            'id' => 'product_extra_desc',
            'title' => esc_html__('Extra Description', 'manu'),
            'desc' => '',
            'pages' => array('product'),
            'context' => 'normal',
            'priority' => 'low',
            'fields' => array(      
                array(
                    'id'    => 'extra_desc', 
					'label' => esc_html__('More Description', 'manu'),
                    'type'        => 'textarea',
                ),
            ),
        );	
		$product_custom_tab = array(
            'id' => 'block_product_custom_tab',
            'title' => esc_html__('Product Tabs Extra', 'manu'),
            'desc' => '',
            'pages' => array('product'),
            'context' => 'normal',
            'priority' => 'low',
            'fields' => array(                
                array(
                    'id'          => 'product_tab_data',
                    'label'       => esc_html__('Custom Tab','manu'),
                    'type'        => 'list-item',
                    'settings'    => array(
                        array(
                            'id' => 'tab_content',
                            'label' => esc_html__('Content', 'manu'),
                            'type' => 'textarea',
                        ),
                    )
                ), 
            ),
        );
		//Product Hover
		$product_metabox = array(
            'id' => 'block_product_thumb_hover',
            'title' => esc_html__('Product Second Image', 'manu'),
            'desc' => '',
            'pages' => array('product'),
            'context' => 'side',
            'priority' => 'low',
            'fields' => array(                
                array(
                    'id'    => 'product_thumb_hover',
                    'type'  => 'upload',
                ),
            ),
        );
		// Product Special
    	$block_product_special = array(
            'id'        => 's7upf_product_special',
            'title'     => 'Product Layout',
            'pages'     => array( 'product'),
            'context'   => 'normal',
            'priority'  => 'low',
            'fields'    => array(
				array(
                    'id' => 'product_layout',
                    'label' => esc_html__('Select Product layout', 'manu'),
                    'type' => 'select',
                    'choices'     => array(  
                        array(
                            'value'=> '',
                            'label'=> esc_html__("Default", 'manu'),
                        ),                                                  
                        array(
                            'value'=> 'sticky',
                            'label'=> esc_html__("Sticky", 'manu'),
                        ),
                    )
                ),
            )
        );   
		//Show page title
        $show_page_title = array(
            'id' => 'page_title_setting',
            'title' => esc_html__('Page setting', 'manu'),
            'pages' => array('page'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(
                array(
                    'id' => 'show_title_page',
                    'label' => esc_html__('Show title', 'manu'),
                    'type' => 'on-off',
                    'std'   => 'on',
                ),
                array(
                    'id'          => 'main_color',
                    'label'       => esc_html__('Main color','manu'),
                    'type'        => 'colorpicker',
                ),
                array(
                    'id'          => 'main_color2',
                    'label'       => esc_html__('Main color 2','manu'),
                    'type'        => 'colorpicker',
                ),
				array(
                    'id'          => 'body_bg',
                    'label'       => esc_html__('Body Background','manu'),
                    'type'        => 'colorpicker',
                ),
            )
        );
		
        if (function_exists('ot_register_meta_box')){
            ot_register_meta_box($format_metabox);
            ot_register_meta_box($sub_title_metabox);
            ot_register_meta_box($sidebar_metabox_default);
            ot_register_meta_box($product_trendding);
            ot_register_meta_box($product_extra_desc);
            ot_register_meta_box($product_custom_tab);
            ot_register_meta_box($block_product_special);
            ot_register_meta_box($product_metabox);
            ot_register_meta_box($show_page_title);
        }
    }
}
?>