<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<section class="error-404 content-pages not-found">
				<div class="container">
					<?php
						$page_id = s7upf_get_option('s7upf_404_page');
						if(!empty($page_id)) {
							echo         S7upf_Template::get_vc_pagecontent($page_id);
						}
						else{ 
					?>
					<header class="page-header">
						<h2 class="title18 font-bold text-uppercase"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'manu' ); ?></h2>
					</header><!-- .page-header -->

					<div class="page-content">
						
						<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'manu' ); ?></p>

						<?php get_search_form(); ?>
					</div><!-- .page-content -->
					
					<?php } ?>
				</div>
			</section><!-- .error-404 -->

		</main><!-- .site-main -->
	</div><!-- .content-area -->

<?php get_footer(); ?>
