<?php

/**
 * User Login Form
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<form method="post" action="<?php bbp_wp_login_action( array( 'context' => 'login_post' ) ); ?>" class="bbp-login-form form-horizontal">
	<fieldset class="bbp-form">
		<legend><?php _e( 'Log In', 'magzilla' ); ?></legend>

		<div class="bbp-username form-group">
			<label class="col-sm-2 control-label" for="user_login"><?php _e( 'Username', 'magzilla' ); ?>: </label>
			<input type="text" name="log" value="<?php bbp_sanitize_val( 'user_login', 'text' ); ?>" size="20" id="user_login" tabindex="<?php bbp_tab_index(); ?>" />
		</div>

		<div class="bbp-password form-group">
			<label class="col-sm-2 control-label" for="user_pass"><?php _e( 'Password', 'magzilla' ); ?>: </label>
			<input type="password" name="pwd" value="<?php bbp_sanitize_val( 'user_pass', 'password' ); ?>" size="20" id="user_pass" tabindex="<?php bbp_tab_index(); ?>" />
		</div>

		<div class="bbp-remember-me form-group">
			<div class="col-sm-offset-2 col-sm-10">
				<input type="checkbox" name="rememberme" value="forever" <?php checked( bbp_get_sanitize_val( 'rememberme', 'checkbox' ) ); ?> id="rememberme" tabindex="<?php bbp_tab_index(); ?>" />
				<label for="rememberme"><?php _e( 'Keep me signed in', 'magzilla' ); ?></label>
			</div>
		</div>

		<?php do_action( 'login_form' ); ?>

		<div class="bbp-submit-wrapper form-group">

			<button type="submit" tabindex="<?php bbp_tab_index(); ?>" name="user-submit" class="button submit user-submit btn btn-theme"><?php _e( 'Log In', 'magzilla' ); ?></button>

			<?php bbp_user_login_fields(); ?>

		</div>
	</fieldset>
</form>
