<?php
    class magzilla_soundcloud extends WP_Widget {
        
        /**
         * Register widget
         **/
        public function __construct() {
            
            parent::__construct(
                                'magazilla-soundcloud', // Base ID
                                __( 'Magzilla: SoundCloud', 'magzilla' ), // Name
                                array( 'description' => '', ) // Args
                                );
            
        }
        
        function widget( $args, $instance ) {
            extract( $args );
            
            $title = apply_filters('widget_title', $instance['title'] );
            $url = isset( $instance['url'] ) ? $instance['url']: '';
            $autoplay = isset( $instance['autoplay'] ) ? $instance['autoplay']: '';
            
            $play = 'false';
            if( !empty( $autoplay )) $play = 'true';
            
            
            
            echo $before_widget;
            if ( ! empty( $title ) ) {
                echo $before_title . $title . $after_title;
            }
            echo magzilla_soundcloud( $url , $play );
            echo $after_widget;
            
        }
        
        function update( $new_instance, $old_instance ) {
            $instance = $old_instance;
            $instance['title'] = strip_tags( $new_instance['title'] );
            $instance['url'] = $new_instance['url'] ;
            $instance['autoplay'] = strip_tags( $new_instance['autoplay'] );
            return $instance;
        }
        
        function form( $instance ) {
            $defaults = array( 'title' => 'SoundCloud'  );
            $instance = wp_parse_args( (array) $instance, $defaults ); ?>

<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
</p>
<p>
<label for="<?php echo $this->get_field_id( 'url' ); ?>">URL :</label>
<input id="<?php echo $this->get_field_id( 'url' ); ?>" name="<?php echo $this->get_field_name( 'url' ); ?>" value="<?php echo $instance['url']; ?>" type="text" class="widefat" />
</p>
<p>
<label for="<?php echo $this->get_field_id( 'autoplay' ); ?>">Autoplay :</label>
<input id="<?php echo $this->get_field_id( 'autoplay' ); ?>" name="<?php echo $this->get_field_name( 'autoplay' ); ?>" value="true" <?php if( $instance['autoplay'] ) echo 'checked="checked"'; ?> type="checkbox" />
</p>


<?php
    }
    }
    
    if ( ! function_exists( 'magzilla_soundcloud_loader' ) ) {
        function magzilla_soundcloud_loader (){
            register_widget( 'magzilla_soundcloud' );
        }
        add_action( 'widgets_init', 'magzilla_soundcloud_loader' );
    }
    function magzilla_soundcloud($url , $autoplay = 'false' ) {
        return '<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url='.$url.'&amp;auto_play='.$autoplay.'&amp;show_artwork=true"></iframe>';
    }
    ?>