<?php
    class magzilla_google extends WP_Widget {
        
        public function __construct() {
            
            parent::__construct(
                                'magzilla-google', // base id
                                __('Magzilla: Google +', 'magzilla'),
                                array( 'description' => __( 'Google Plus Page', 'magzilla' ), ) // Args
                                );
        }
        
        function widget( $args, $instance ) {
            extract( $args );
            
            $title = apply_filters('widget_title', $instance['title'] );
            $page_url = isset( $instance['page_url'] ) ? $instance['page_url']: '';
            
            echo $before_widget;
            
            if ( ! empty( $title ) ) {
                echo $before_title . $title . $after_title;
            } ?>

<div class="google-box">
<!-- Google +1 script -->
<script type="text/javascript">
(function() {
 var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
 po.src = 'https://apis.google.com/js/plusone.js';
 var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
 })();
</script>
<!-- Link blog to Google+ page -->
<a style='display: block; height: 0;' href="<?php echo $page_url ?>" rel="publisher">&nbsp;</a>
<!-- Google +1 Page badge -->
<g:plus href="<?php echo $page_url ?>" height="" width="310" theme="light"></g:plus>

</div>
<?php 
    echo $after_widget;
    }
    
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['page_url'] = strip_tags( $new_instance['page_url'] );
        return $instance;
    }
    
    function form( $instance ) {
        $defaults = array( 'title' =>__( 'Follow us on Google+' , 'magzilla'), 'page_url' => '' );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>

<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
</p>
<p>
<label for="<?php echo $this->get_field_id( 'page_url' ); ?>">Page Url : </label>
<input id="<?php echo $this->get_field_id( 'page_url' ); ?>" name="<?php echo $this->get_field_name( 'page_url' ); ?>" value="<?php echo $instance['page_url']; ?>" class="widefat" type="text" />
</p>


<?php
    }
    }
    
    if ( ! function_exists( 'magzilla_google_loader' ) ) {
        function magzilla_google_loader (){
            register_widget( 'magzilla_google' );
        }
        add_action( 'widgets_init', 'magzilla_google_loader' );
    }
    ?>