<?php
/**
 * Single view template.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

$reading_chapter = $this->get('chapter');

$this->load_parts( [ 'html-start' ] );
?>

<?php $this->load_parts( [ 'header' ] ); ?>

<article class="amp-wp-article">
	<header class="amp-wp-article-header">
		<h1 class="amp-wp-title">
			<?php 
			if($reading_chapter){                
				$manga_url = get_permalink(get_the_ID()) . 'amp';
				?>
				<a href="<?php echo esc_url($manga_url);?>"><?php echo esc_html( $this->get( 'post_title' ) );?></a>
				<?php
			} else {
				echo esc_html( $this->get( 'post_title' ) );
			}
			
			if($reading_chapter){
				echo ' - ' . esc_html( $reading_chapter['chapter_name'] );
			}
			?>
		</h1>
		
		<?php $this->load_parts( apply_filters( 'amp_post_article_header_meta', [ 'meta-author', 'meta-time' ] ) ); ?>
	</header>

	<div class="amp-wp-article-content">
		<?php
		global $wp_manga;
		
			if($reading_chapter){
				if($wp_manga->is_content_manga( get_the_ID() )){
					$this->load_parts(['manga-chapter-text']);
				} else {
					$this->load_parts(['manga-chapter-manga']);
				}
			} else {
				echo sprintf($this->get( 'post_amp_content' ), null); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
			}
		?>
	</div>

	<footer class="amp-wp-article-footer">
		<?php $this->load_parts( apply_filters( 'amp_post_article_footer_meta', [ 'meta-taxonomy', 'meta-comments-link' ] ) ); ?>
	</footer>
</article>

<?php $this->load_parts( [ 'footer' ] ); ?>

<?php
$this->load_parts( [ 'html-end' ] );
