<?php


add_shortcode('x_heading', 'madara_x_heading', 10, 2);
function madara_x_heading($atts, $content){
    $heading_color = isset($atts['color']) ? esc_attr($atts['color']) : '';
    $link_url = isset($atts['link_url']) ? esc_url($atts['link_url']) : '';
    $link_title = isset($atts['link_title']) ? $atts['link_title'] : esc_html('See All', WP_MANGA_X_TEXTDOMAIN);
    $link_url_sub = isset($atts['link_url_sub']) ? esc_url($atts['link_url_sub']) : '';
    $link_title_sub = isset($atts['link_title_sub']) ? $atts['link_title_sub'] : esc_html('', WP_MANGA_X_TEXTDOMAIN);
    return '<div class="x-heading"><h2 style="color:'.$heading_color.'">'.$content.'</h2><div class="sub-links"><a style="color:'.$heading_color.'" href="'.$link_url.'">'.$link_title.'</a><a style="color:'.$heading_color.'" href="'.$link_url_sub.'"> | '.$link_title_sub.'</a></div></div>';
}

add_shortcode('madara_x_slider', 'madara_x_manga_slider_render', 10, 2);

function madara_x_manga_slider_render( $atts, $content ) {
    global $wp_manga_functions;

    $id        = 'c-post-slider-' . rand( 1, 999 );
    $style     = isset( $atts['style'] ) && $atts['style'] != '' ? $atts['style'] : 1;
    $cats      = isset( $atts['cats'] ) && $atts['cats'] != '' ? $atts['cats'] : '';
    $tags      = isset( $atts['tags'] ) && $atts['tags'] != '' ? $atts['tags'] : '';
    $orderby   = isset( $atts['orderby'] ) && $atts['orderby'] != '' ? $atts['orderby'] : 'latest';
    $count     = isset( $atts['count'] ) && $atts['count'] != '' ? $atts['count'] : '5';
    $order     = isset( $atts['order'] ) && $atts['order'] != '' ? $atts['order'] : 'DESC';
    $ids       = isset( $atts['ids'] ) && $atts['ids'] != '' ? $atts['ids'] : '';
    $post_type = isset( $atts['post_type'] ) && $atts['post_type'] != '' ? $atts['post_type'] : 'post';
    $manga_type = isset( $atts['manga_type'] ) && $atts['manga_type'] != '' ? $atts['manga_type'] : '';
    $number    = isset( $atts['number'] ) && $atts['number'] != '' ? $atts['number'] : '2';
    $time      = isset( $atts['time'] ) && $atts['time'] != '' ? $atts['time'] : 'all';
    $autoplay      = isset( $atts['autoplay'] ) && $atts['autoplay'] != '' ? $atts['autoplay'] : false;

    if ( $orderby == 'view' ) {
        $orderby = 'most_viewed';
    } else if ( $orderby == 'random' ) {
        $orderby = 'rand';
    } else if ( $orderby == 'comment' ) {
        $orderby = 'most_commented';
    } else if ( $orderby == 'title' ) {
        $orderby = 'title';
    } else if ( $orderby == 'input' ) {
        $orderby = 'post__in';
    } else {
        $orderby = 'date';
    }
    
    $args = array(
        'categories' => $cats,
        'tags'       => $tags,
        'ids'        => $ids,
        'post_type'  => $post_type,
        'timerange'  => $time
    );
    
    if($post_type == 'wp-manga'){
        if($manga_type != ''){
            $args['meta_query_value'] = $manga_type;
            $args['key'] = '_wp_manga_chapter_type';
        }
    }

    if($orderby == 'most_viewed'){
        switch($time){
            case 'day':
                $args['viewed_meta_key'] = '_wp_manga_day_views_value';
                break;
            case 'week':
                $args['viewed_meta_key'] = '_wp_manga_week_views_value';
                break;
            case 'month':
                $args['viewed_meta_key'] = '_wp_manga_month_views_value';
                break;
            case 'year':
                $args['viewed_meta_key'] = '_wp_manga_year_views_value';
                break;
            case 'all':
            default:
                $args['viewed_meta_key'] = '_wp_manga_views';
                break;
        }
    }

    $shortcode_query = App\Models\Database::getPosts( $count, $order, 1, $orderby, $args );

    switch ( $style ) {
        case '1':
            $wrap_class  = 'manga-slider';
            $inner_class = 'slider__container_custom';
            $data_style  = 'style-1';
            $classes     = 'style-1 no-padding';
            $thumb_size = 'madara_x_slider_1';
            break;
        case '2':
            $wrap_class  = 'manga-slider';
            $inner_class = 'slider__container';
            $data_style  = 'style-2';
            $classes     = 'style-2';
            $thumb_size = 'madara_x_slider_2';
            break;
        case '3':
            $wrap_class  = 'manga-x-slider';
            $inner_class = 'slider__container slider-for';
            $data_style  = 'style-3';
            $classes     = 'no-full-width style-3';
            $thumb_size = 'madara_x_slider_3';
            break;
    }
    ob_start();
    if ( $shortcode_query->have_posts() ) {
        ?>

        <div id="<?php echo esc_attr( $id ); ?>" class="<?php echo esc_attr( $wrap_class ) . ' ' . esc_attr( $classes ); ?>" data-style="<?php echo esc_attr( $data_style ); ?>" data-count="<?php echo esc_attr( $number ); ?>" <?php if($autoplay && $autoplay == '1'){?>data-autoplay="1"<?php }?>>

            <div class="<?php echo esc_attr( $inner_class ); ?>" role="toolbar">

                <?php
                    while ( $shortcode_query->have_posts() ) {

                        $shortcode_query->the_post(); ?>

                            <div class="slider__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">

                                <?php if ( has_post_thumbnail() ) { 
                                    $thumb_image = get_the_post_thumbnail(get_the_ID(), $thumb_size );
                                    ?>
                                    <div class="slider__thumb">
                                        <?php if ($style != 2) { 
                                            madara_manga_title_badges_html( get_the_ID(), 1 );}
                                            if ($style == 1 && get_post_meta(get_the_ID(),'manga_poster_image',true)) {
                                                $thumb_image = '<img src=' .get_post_meta(get_the_ID(), 'manga_poster_image',true ).' title='.esc_attr(get_the_title(get_the_ID())).'/>';
                                            }
                                        ?>
                                        <div class="slider__thumb_item">
                                            <a href="<?php echo get_the_permalink() ?>">
                                                <?php echo  $thumb_image; ?>
                                                <div class="slider-overlay"></div>
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="slider__content">
                                    <div class="slider__content_item">
                                        <div class="post-title font-title">
                                            <h4>
												<?php if ($style == 2) { madara_manga_title_badges_html( get_the_ID(), 1 ); }?>
												<a href="<?php echo get_the_permalink() ?>">
													<?php echo get_the_title(); ?>
												</a>
                                                <?php if ($style != 1) { ?>
                                                    <span class="manga-genres">
                                                    <?php 
                                                        $genres = $wp_manga_functions->get_manga_genres(get_the_ID());
												  		if ($genres) {
															$genres_arr = explode(',', $genres);
															$first_3_genres = array_splice($genres_arr, 0,3);
															foreach ($first_3_genres as $index => $genre) {
																echo '<span class="genre-item"><i class="fas fa-circle"></i>' . $genre.'</span>';
                                                                if ($style == 3 && $index == 1) {
                                                                    break;
                                                                }
															}
														}
                                                    ?>
                                                    </span>
                                                <?php } ?>
                                            </h4>
                                        </div>
                                    </div>
                                </div>

                                <?php
                                $badge = \App\Madara::getOption('show_chapter_type', 0);
                                
                                if($badge){ ?>
                                <div class="slider__meta">
                                    <?php    
                                        if($badge == 1){
                                            $type = get_post_meta(get_the_ID(), '_wp_manga_chapter_type', true);
                                            $type_show = $type !== '' ? ($type == 'text' ? esc_html__('Novel', WP_MANGA_X_TEXTDOMAIN) : esc_html__('Video', WP_MANGA_X_TEXTDOMAIN)) : esc_html__('Manga', WP_MANGA_X_TEXTDOMAIN);
                                        } else {
                                            global $wp_manga_functions;
                                            $type_show = $wp_manga_functions->get_manga_type(get_the_ID());
                                        }
                                    ?>
                                    <span class="manga-chapter-type"><?php echo $type_show;?></span>
                                </div>
                                <?php } ?>
                            </div>

                    <?php }//end while
                    wp_reset_postdata();
                ?>

            </div>

            <?php if ($style == '3') {
                ?>
                    <div class="slider__container slider-nav">

                        <?php
                            while ( $shortcode_query->have_posts() ) {

                                $shortcode_query->the_post(); ?>
                                    <div class="slider__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">
                                        <?php if ( has_post_thumbnail() ) { ?>
                                            <div class="slider__thumb">
                                                <?php if ($style != 2) { madara_manga_title_badges_html( get_the_ID(), 1 );}?>
                                                <div class="slider__thumb_item">
                                                    <a href="<?php echo get_the_permalink() ?>">
                                                        <?php echo get_the_post_thumbnail(get_the_ID(), $thumb_size ); ?>
                                                        <div class="slider-overlay"></div>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php } ?>

                                        <div class="slider__content">
                                            <div class="slider__content_item">
                                                <div class="post-title font-title">
                                                    <h4>
                                                        <?php if ($style == 2) { madara_manga_title_badges_html( get_the_ID(), 1 ); }?>
                                                        <a href="<?php echo get_the_permalink() ?>">
                                                            <?php echo get_the_title(); ?>
                                                        </a>
                                                        <?php if ($style != 1) { ?>
                                                            <span class="manga-genres">
                                                            <?php 
                                                                $genres = $wp_manga_functions->get_manga_genres(get_the_ID());
                                                                if ($genres) {
                                                                    $genres_arr = explode(',', $genres);
                                                                    $first_3_genres = array_splice($genres_arr, 0,3);
                                                                    foreach ($first_3_genres as $index => $genre) {
                                                                        echo '<span class="genre-item"><i class="fas fa-circle"></i>' . $genre.'</span>';
                                                                        if ($style == 3 && $index == 0) {
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            ?>
                                                            </span>
                                                        <?php } ?>
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                        
	$badge = \App\Madara::getOption('show_chapter_type', 0);
	
	if($badge){ ?>
	<div class="slider__meta">
		<?php    
			if($badge == 1){
				$type = get_post_meta(get_the_ID(), '_wp_manga_chapter_type', true);
				$type_show = $type !== '' ? ($type == 'text' ? esc_html__('Novel', WP_MANGA_X_TEXTDOMAIN) : esc_html__('Video', WP_MANGA_X_TEXTDOMAIN)) : esc_html__('Manga', WP_MANGA_X_TEXTDOMAIN);
			} else {
				global $wp_manga_functions;
				$type_show = $wp_manga_functions->get_manga_type(get_the_ID());
			}
		?>
		<span class="manga-chapter-type"><?php echo $type_show;?></span>
	</div>
	<?php } ?>
                                    </div>

                            <?php }//end while
                            wp_reset_postdata();
                        ?>
                    </div>
                <?php
            }?>

        </div>

        <?php
    }
    $output = ob_get_contents();
    ob_end_clean();

    return $output;

}
// add_shortcode('madara_x_heroslider', 'madara_x_manga_heroslider_render', 10, 2);

function madara_x_manga_heroslider_render( $atts, $content ) {

    $id        = 'c-post-slider-' . rand( 1, 999 );
    $style     = isset( $atts['style'] ) && $atts['style'] != '' ? $atts['style'] : 1;
    $cats      = isset( $atts['cats'] ) && $atts['cats'] != '' ? $atts['cats'] : '';
    $tags      = isset( $atts['tags'] ) && $atts['tags'] != '' ? $atts['tags'] : '';
    $orderby   = isset( $atts['orderby'] ) && $atts['orderby'] != '' ? $atts['orderby'] : 'latest';
    $count     = isset( $atts['count'] ) && $atts['count'] != '' ? $atts['count'] : '5';
    $order     = isset( $atts['order'] ) && $atts['order'] != '' ? $atts['order'] : 'DESC';
    $ids       = isset( $atts['ids'] ) && $atts['ids'] != '' ? $atts['ids'] : '';
    $post_type = 'wp-manga';
    $manga_type = isset( $atts['manga_type'] ) && $atts['manga_type'] != '' ? $atts['manga_type'] : '';
    $number    = 2;
    $time      = isset( $atts['time'] ) && $atts['time'] != '' ? $atts['time'] : 'all';
    $autoplay      = isset( $atts['autoplay'] ) && $atts['autoplay'] != '' ? $atts['autoplay'] : false;

    $thumb_size = array( 300, 420 );

    if ( $orderby == 'view' ) {
        $orderby = 'most_viewed';
    } else if ( $orderby == 'random' ) {
        $orderby = 'rand';
    } else if ( $orderby == 'comment' ) {
        $orderby = 'most_commented';
    } else if ( $orderby == 'title' ) {
        $orderby = 'title';
    } else if ( $orderby == 'input' ) {
        $orderby = 'post__in';
    } else {
        $orderby = 'date';
    }
    
    $args = array(
        'categories' => $cats,
        'tags'       => $tags,
        'ids'        => $ids,
        'post_type'  => $post_type,
        'timerange'  => $time
    );
    
    if($post_type == 'wp-manga'){
        if($manga_type != ''){
            $args['meta_query_value'] = $manga_type;
            $args['key'] = '_wp_manga_chapter_type';
        }
    }

    $shortcode_query = App\Models\Database::getPosts( $count, $order, 1, $orderby, $args );

    $wrap_class  = 'x-heroslider';
    $inner_class = 'slider__container';
    $data_style  = 'style-1';
    $classes     = 'style-1 no-padding';
    
    ob_start();

    if ( $shortcode_query->have_posts() ) {
        ?>


        <div id="<?php echo esc_attr( $id ); ?>" class="x-heroslider <?php echo esc_attr( $wrap_class ) . ' ' . esc_attr( $classes ); ?>" data-style="<?php echo esc_attr( $data_style ); ?>" data-count="<?php echo esc_attr( $number ); ?>" <?php if($autoplay && $autoplay == '1'){?>data-autoplay="1"<?php }?>>

            <div class="<?php echo esc_attr( $inner_class ); ?>" role="toolbar">

                <?php
                    while ( $shortcode_query->have_posts() ) {

                        $shortcode_query->the_post(); ?>

                        <?php if ( $style != 4 ) { ?>

                            <div class="slider__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">
                                <div class="slider_item_inner">
                                    <?php if ( has_post_thumbnail() ) { ?>
                                        <div class="slider__thumb">
                                            <div class="slider__thumb_item">
                                                <a href="<?php echo get_the_permalink() ?>">
                                                    <?php echo madara_thumbnail( $thumb_size ); ?>
                                                    <div class="slider-overlay"></div>
                                                </a>
                                            </div>
                                        </div>
                                    <?php } ?>

                                    <div class="slider__content">
                                        <div class="slider__content_item">
                                            <div class="post-title font-title">
                                                <h4>
                                                    <a href="<?php echo get_the_permalink() ?>">
                                                    <?php madara_manga_title_badges_html( get_the_ID(), 1 ); ?>
                                                    <?php echo get_the_title() ?></a>
                                                </h4>
                                            </div>
                                            <div class="post-content">
                                                <div class="manga-author">
                                                    <?php
                                                    global $wp_manga_functions;
                                                    $authors     = $wp_manga_functions->get_manga_authors( get_the_ID() );
                                                    echo $authors;
                                                    ?>
                                                </div>
                                                <div class="manga-views">
                                                    <?php
                                                    $manga_views = get_post_meta( get_the_ID(), '_wp_manga_views', true );
                                                    echo sprintf(__("<i class='fa fa-eye'></i>%s views", WP_MANGA_X_TEXTDOMAIN), wp_manga_number_format_short(intval($manga_views)));
                                                    ?>
                                                </div>
                                                <div class="manga-summary">
                                                    <?php echo get_the_content();?>
                                                </div>
                                                <div class="manga-read">
                                                    <?php
                                                    global $wp_manga_functions;
                                                    $chapter = $wp_manga_functions->get_latest_chapters(get_the_ID(), false, 1, 0, 'name', 'asc');
                                                    if(count($chapter) > 0){
                                                    $chapter_url = $wp_manga_functions->build_chapter_url( get_the_ID(), $chapter[0]);
                                                    ?>
                                                    <a href="<?php echo $chapter_url;?>" id="btn-read-last" class="c-btn c-btn_style-1"><?php echo $chapter[0]['chapter_name'];?></a>
                                                    <?php }?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php } else { ?>

                            <div class="col-sm-6 col-md-3 related__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">

                                <?php if ( has_post_thumbnail() ) { ?>
                                    <div class="related__thumb">
                                        <div class="related__thumb_item">
                                            <a href="<?php echo get_the_permalink() ?>">
                                                <?php echo madara_thumbnail( $thumb_size ); ?>
                                                <div class="related-overlay"></div>
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="related__content">
                                    <div class="related__content_item">
                                        <div class="post-title font-title">
                                            <h5>
                                                <a href="<?php echo get_the_permalink() ?>">
                                                    <?php madara_manga_title_badges_html( get_the_ID(), 1 ); ?>
                                                    <?php echo get_the_title() ?>
                                                </a>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php } ?>

                    <?php }//end while
                    wp_reset_postdata();
                ?>

            </div>
        </div>


        <?php
    }
    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}

add_shortcode('madara_child_x_payment_history', 'madara_child_x_buycred_payment_history', 10, 2);
function madara_child_x_buycred_payment_history($atts = [], $content = ''){
	$user_id = get_current_user_id();
	if(!$user_id) return '';

	$payments = madara_child_x_buycred_get_users_payments($user_id);
	if(!$payments || count($payments) == 0){
		$html = '<div id="madara_child_x_payment_history"><p class="no-history">' . esc_html__('No payments available', WP_MANGA_X_TEXTDOMAIN) . '</p></div>';
	} else {
		ob_start();
?>
<div id="madara_child_x_payment_history">
	<table class="table">
		<thead>
			<tr>
				<th class="column-transaction-id"><?php esc_html_e( 'Transaction ID', WP_MANGA_X_TEXTDOMAIN ); ?></th>
				<th class="column-gateway"><?php esc_html_e( 'Gateway', WP_MANGA_X_TEXTDOMAIN ); ?></th>
				<th class="column-amount"><?php esc_html_e( 'Amount', WP_MANGA_X_TEXTDOMAIN ); ?></th>
				<th class="column-cost"><?php esc_html_e( 'Cost', WP_MANGA_X_TEXTDOMAIN ); ?></th>
				<th class="column-date"><?php esc_html_e( 'Date', WP_MANGA_X_TEXTDOMAIN ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 
			
			$pendings = buycred_get_users_pending_payments($user_id);
			
			$pendings_ids = array_map(function($item){ return $item->payment_id;}, $pendings[MYCRED_DEFAULT_TYPE_KEY]);
			
			foreach($payments as $payment){
				$post_id = $payment->ID;
				
				if(in_array($post_id, $pendings_ids)){
					continue;
				}
				?>
			<tr>
				<th>
					<?php
					echo get_the_title( $post_id );
					?>
				</th>
				<th>
					<?php
					global $mycred_modules;
					$gateway   = mycred_get_post_meta( $post_id, 'gateway', true );
					$installed = $mycred_modules['solo']['buycred']->get();

					if ( isset( $installed[ $gateway ] ) )
						echo esc_html( $installed[ $gateway ]['title'] );
					else
						echo esc_html( $gateway );
					?>
				</th>
				<th><?php
					
					$type   = mycred_get_post_meta( $post_id, 'point_type', true );
					$amount = mycred_get_post_meta( $post_id, 'amount', true );
					$mycred = mycred( $type );

					echo esc_html( $mycred->format_creds( $amount ) );
					
					?>
				</th>
				<th>
					<?php
					$cost     = mycred_get_post_meta( $post_id, 'cost', true );
					$currency = mycred_get_post_meta( $post_id, 'currency', true );

					echo esc_html( $cost . ' ' . $currency );
					?>
				</th>
				<th>
					<?php
					echo get_the_date(get_option('date_format') . ' ' . get_option('time_format'), $post_id);
					?>
				</th>
			</tr>
			<?php } ?>
		</tbody>
	</table>
</div>
<?php


		$html = ob_get_contents();
		ob_end_clean();
	}

	return $html;
}