<?php

if(!class_exists('madara_UNYSON_BACKUP')){
	class madara_UNYSON_BACKUP
	{
		function __construct(){
			// empty class to trick the sample data tab
			echo 'a';exit;
		}
	}
	
}

if(!class_exists('madara_sampledata_installer')){
	class madara_sampledata_installer{
		function __construct(){
			add_action( 'wp_ajax_madara_install_data', array($this, 'ajax_install_data' ));
			add_action('madara_welcome_importdata_tab_content', array($this, '_sample_data_page'));
		}
		
		function ajax_install_data(){
			// create home page	
			$args = array(
						'post_content' => '<!-- wp:shortcode -->
						[madara_x_slider style="2" number="3" post_type="wp-manga"]
						<!-- /wp:shortcode -->
						
						<!-- wp:spacer {"height":"30px"} -->
						<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:shortcode -->
						[x_heading link_url="https://live.mangabooth.com/x/manga/"]Slider[/x_heading]
						<!-- /wp:shortcode -->
						
						<!-- wp:spacer {"height":"18px"} -->
						<div style="height:18px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:shortcode -->
						[madara_x_slider style="1" number="5" count="10" post_type="wp-manga"]
						<!-- /wp:shortcode -->
						
						<!-- wp:spacer {"height":"30px"} -->
						<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:shortcode -->
						[x_heading link_url="https://live.mangabooth.com/x/manga/"]Slider 2[/x_heading]
						<!-- /wp:shortcode -->
						
						<!-- wp:shortcode -->
						[madara_x_slider style="3" number="4" count="8" post_type="wp-manga"]
						<!-- /wp:shortcode -->
						
						<!-- wp:spacer {"height":"0px"} -->
						<div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:spacer {"height":"30px"} -->
						<div style="height:30px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:shortcode -->
						[x_heading]Latest Releases[/x_heading]
						<!-- /wp:shortcode -->
						
						<!-- wp:spacer {"height":"0px"} -->
						<div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div>
						<!-- /wp:spacer -->
						
						<!-- wp:shortcode -->
						[manga_listing item_layout="chapters" count="40"]
						<!-- /wp:shortcode -->',
						'post_type' => 'page',
						'post_title' => 'Home Page',
						'post_status' => 'publish'
					);
			$frontpage_id = wp_insert_post($args);
			
			update_post_meta( $frontpage_id, 'custom_sidebar_settings', 'on' );
			update_post_meta( $frontpage_id, 'page_content', 'page_content' );
			update_post_meta( $frontpage_id, 'page_sidebar', 'full' );
			update_post_meta( $frontpage_id, 'main_top_sidebar_background', array('background-color' => '#000') );
			update_post_meta( $frontpage_id, 'main_top_sidebar_container', 'full_width' );
			update_post_meta( $frontpage_id, 'main_top_sidebar_spacing', array('top' => '15', 'right' => '0', 'bottom' => '1', 'left' => '0', 'unit' => 'px') );
			update_post_meta( $frontpage_id, 'main_top_second_sidebar_spacing', array('top' => '1', 'right' => '0', 'bottom' => '0', 'left' => '0', 'unit' => 'px') );
			update_post_meta( $frontpage_id, 'main_top_second_sidebar_background', array('background-color' => '#000') );
			update_post_meta( $frontpage_id, 'page_title', 'off' );
			update_post_meta( $frontpage_id, 'page_meta_tags', 'off' );
			update_post_meta( $frontpage_id, '_wp_page_template', 'page-templates/front-page.php' );
		
			$args = array(
				'post_content' => '-- Manga Listing --',
				'post_type' => 'page',
				'post_title' => 'All Series',
				'post_status' => 'publish'
			);
			$newpage_id = wp_insert_post($args);
		
			update_post_meta( $newpage_id, 'page_content', 'manga' );
			update_post_meta( $newpage_id, 'page_sidebar', 'full' );
			update_post_meta( $newpage_id, 'manga_archives_item_layout', 'small_thumbnail' );
			update_post_meta( $newpage_id, 'archive_heading_text', 'Latest Updates' );
			update_post_meta( $newpage_id, '_wp_page_template', 'page-templates/front-page.php' );
			update_post_meta( $newpage_id, 'page_post_orderby', 'modified' );

			$args = array(
				'post_content' => 'The calendar shows list of mangas which are having new updates each day. It displays the next 7 days',
				'post_type' => 'page',
				'post_title' => 'Calendar',
				'post_status' => 'publish'
			);
			$calendar_pageid = wp_insert_post($args);
		
			update_post_meta( $calendar_pageid, 'page_content', 'page_content' );
			update_post_meta( $calendar_pageid, 'page_sidebar', 'full' );
			update_post_meta( $calendar_pageid, '_wp_page_template', 'page-templates/calendar-manga.php' );

			$args = array(
				'post_content' => 'You can bookmark any mangas when viewing ones, and it will appear here for quick access',
				'post_type' => 'page',
				'post_title' => 'My Bookmarks',
				'post_status' => 'publish'
			);
			$bookmark_pageid = wp_insert_post($args);
		
			update_post_meta( $bookmark_pageid, 'page_content', 'page_content' );
			update_post_meta( $bookmark_pageid, 'page_sidebar', 'full' );
			update_post_meta( $bookmark_pageid, '_wp_page_template', 'page-templates/my-bookmark.php' );
			
			$settings = get_option( 'wp_manga_settings' , array() );
			$settings['manga_archive_page'] = $newpage_id;
			$resp = update_option( 'wp_manga_settings', $settings );
		
			// Widgets settings
			$widgets = '{"search_sidebar":{"manga-search-2":{"title":"","search_advanced":"Advanced"}},"footer_sidebar":{"manga-genres-id-1":{"title":"All Genres","exclude_genre":"","show_manga_counts":"true","layout":"layout-2"}}}';
		
			$widgets_json = json_decode($widgets);   // Decode file contents to JSON data.
			$wie_import_results = $this->wie_import_data($widgets_json);
		
			// create menu
			$main_menu_id = wp_create_nav_menu('Primary Menu ' . rand(0,1000));
			if($main_menu_id){
				wp_update_nav_menu_item($main_menu_id, 0, array(
					'menu-item-title' =>  __('Home'),
					'menu-item-object-id' => $frontpage_id,
					'menu-item-object' => 'page',
					'menu-item-type' => 'post_type',
					'menu-item-status' => 'publish'));
			
				wp_update_nav_menu_item($main_menu_id, 0, array(
					'menu-item-title' =>  __('All Series'),
					'menu-item-object-id' => $newpage_id,
					'menu-item-object' => 'page',
					'menu-item-type' => 'post_type',
					'menu-item-status' => 'publish'));
				
				wp_update_nav_menu_item($main_menu_id, 0, array(
					'menu-item-title' =>  __('Calendar'),
					'menu-item-object-id' => $calendar_pageid,
					'menu-item-object' => 'page',
					'menu-item-type' => 'post_type',
					'menu-item-status' => 'publish'));
			}
		
			$user_menu_id = wp_create_nav_menu('User Menu ' . rand(0,1000));
			if($user_menu_id){
				wp_update_nav_menu_item($user_menu_id, 0, array(
					'menu-item-title' =>  __('My Bookmarks'),
					'menu-item-object-id' => $bookmark_pageid,
					'menu-item-object' => 'page',
					'menu-item-type' => 'post_type',
					'menu-item-status' => 'publish'));
			}    
			
			$locations = get_theme_mod('nav_menu_locations');
			$locations['primary_menu'] = $main_menu_id;
			$locations['user_menu'] = $user_menu_id;
			set_theme_mod( 'nav_menu_locations', $locations );
		
			update_option( 'page_on_front', $frontpage_id );
			update_option('show_on_front', 'page');
			update_option('posts_per_page', 16);
			
			// permalink
			update_option('permalink_structure', '/%postname%/');
			update_option('users_can_register', 1);

			set_theme_mod('credit_card_icon', 'fas fa-solid fa-coins');
			set_theme_mod('credit_card_link', '/buy-coins/');
			set_theme_mod('coin_purchase_page', '/buy-coins/');
			set_theme_mod('calendar_schedule_by', 1);
			set_theme_mod('chapter_lightbox', 1);
			set_theme_mod('show_chapter_type', 1);
			set_theme_mod('calendar_items_per_row', 5);
		
			$badges = array('no', 'hot','new', 'custom');
			// insert manga post
			for($id = 1; $id <= 20; $id++){
				$args = array(
					'post_content' => 'What is Lorem Ipsum?
					Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
					
					Why do we use it?
					It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).',
					'post_type' => 'wp-manga',
					'post_title' => 'Manga ' . $id,
					'post_status' => 'publish'
				);
			
				$manga_id = wp_insert_post($args);

				$thumb_idx = rand(1,5);
				$banner_idx = rand(1,5);
			
				$thumb_id = $this->_upload_thumb( get_template_directory() . '/sample-data/thumb-' . $thumb_idx . '.jpg', $manga_id );
				$banner_id = $this->_upload_thumb( get_template_directory() . '/sample-data/horiimage-' . $banner_idx . '.jpg', $manga_id );
			
				
				$badge = $badges[rand(0, 3)];
				$meta_data = array(
					'_thumbnail_id'          => $thumb_id,
					'_wp_manga_alternative'  => 'Alternative Name',
					'_wp_manga_chapter_type' => 'manga',
					'manga_release_schedule' => 'New chapter released daily',
					'manga_release_days' => array("1","2","3","4","5","6","7"),
					'manga_title_badges' => $badge,
					'manga_custom_badges' => ($badge == 'custom' ? 'trending' : '')
				);
			
				foreach( $meta_data as $key => $value ){
					if( !empty( $value ) ){
						update_post_meta( $manga_id, $key, $value );
					}
				}
			
				update_post_meta($manga_id, 'manga_banner', wp_get_attachment_url($banner_id));
			
				$manga_terms = array(
					'wp-manga-release' => '2023',
					'wp-manga-author'      => 'The Author',
					'wp-manga-artist'      => 'Artist',
					'wp-manga-genre'       => 'action,horrow,fun,drama,ecchi,fighting,girl,boys,adventure,manhwa,chinese',
					'wp-manga-tag'         => 'tag-1,tag-2,tag-3',
				);
			
				foreach( $manga_terms as $tax => $term ){
					$resp = $this->_add_manga_terms( $manga_id, $term, $tax );
				}
		
				// insert chapters
				$this->_upload_single_chapter(array('name' => 'Chapter 1', 'extend_name' => 'Other Name 1'), $manga_id);
				$this->_upload_single_chapter(array('name' => 'Chapter 2', 'extend_name' => 'Other Name 2'), $manga_id);
				$this->_upload_single_chapter(array('name' => 'Chapter 3', 'extend_name' => 'Other Name 3'), $manga_id);
				$this->_upload_single_chapter(array('name' => 'Chapter 4', 'extend_name' => 'Other Name 4'), $manga_id);
			}
		
			$this->_update_post_views( $manga_id, 1000 );
			$this->_update_ratings( $manga_id, array('avg' => 5, 'numbers' => 1000) );
		
			wp_send_json_success( ['message' => 'Sample data installed. Please remove "/sample-data" folder in your theme', 'data' => $message] );
		}
		
		function _upload_single_chapter( $chapter, $post_id ){		
			// Prepare
			global $wp_manga, $wp_manga_storage;
			$uniqid = $wp_manga->get_uniqid( $post_id );
			
			$slugified_name = $wp_manga_storage->slugify( $chapter['name'] );
			
			// Download images
			$extract = WP_MANGA_DATA_DIR . $uniqid . '/' . $slugified_name;
		
			if( ! file_exists( $extract ) ){
				if( ! wp_mkdir_p( $extract ) ){
					error_log_die([
						'function' => __FUNCTION__,
						'message'  => "Cannot make dir $extract",
						'cancel'   => true,
					]);
				}
			}
		
			$extract_uri = WP_MANGA_DATA_URL;
		
			$this->_folder_copy(dirname(__FILE__) . '/chapter-images', $extract);
		
			// Create Chapter
			$chapter_args = array(
				'post_id'             => $post_id,
				'volume_id'           => 0,
				'chapter_name'        => $chapter['name'],
				'chapter_name_extend' => $chapter['extend_name'],
				'chapter_slug'        => $slugified_name,
			);
		
			$storage = 'local';
			
			//upload chapter to cloud in case of crawl single
			$result = $wp_manga_storage->wp_manga_upload_single_chapter( $chapter_args, $extract, $extract_uri, $storage );
			
			return $result;
		
		}
		
		function _folder_copy($src, $dst) { 
		  
			// open the source directory
			$dir = opendir($src); 
		  
			// Make the destination directory if not exist
			@mkdir($dst); 
		  
			// Loop through the files in source directory
			while( $file = readdir($dir) ) { 
		  
				if (( $file != '.' ) && ( $file != '..' )) { 
					if ( is_dir($src . '/' . $file) ) 
					{ 
		  
						// Recursively calling custom copy function
						// for sub directory 
						$this->_folder_copy($src . '/' . $file, $dst . '/' . $file); 
		  
					} 
					else { 
						copy($src . '/' . $file, $dst . '/' . $file); 
					} 
				} 
			} 
		  
			closedir($dir);
		}
		
		function _add_manga_terms( $post_id, $terms, $taxonomy ){
		
		
		
			$terms = explode(',', $terms);
		
			if( empty( $terms ) ){
				return false;
			}
		
			$taxonomy_obj = get_taxonomy( $taxonomy );
		
			if( $taxonomy_obj->hierarchical ){
		
				$output_terms = array();
		
				foreach( $terms as $current_term ){
		
					if( empty( $current_term ) ){
						continue;
					}
		
					//check if term is exist
					$term = term_exists( $current_term, $taxonomy );
		
					//then add if it isn't
					if( ! $term || is_wp_error( $term ) ){
						$term = wp_insert_term( $current_term, $taxonomy );
						if( !is_wp_error( $term ) && isset( $term['term_id'] ) ){
							$term = intval( $term['term_id'] );
		
						}else{
							continue;
						}
					}else{
						$term = intval( $term['term_id'] );
					}
		
					$output_terms[] = $term;
				}
		
				$terms = $output_terms;
			}
		
			$resp = wp_set_post_terms( $post_id, $terms, $taxonomy );
		
			return $resp;
		
		}
		
		function _update_post_views( $post_id, $views ){
		
			$month = date('m');
		
			update_post_meta( $post_id, '_wp_manga_month_views', array(
				'date' => $month,
				'views' => $views
			) );
			
			update_post_meta( $post_id, '_wp_manga_views', $views );
			
			$new_year_views = array( 'views' => $views, 'date' => date('y') );
			update_post_meta( $post_id, '_wp_manga_year_views', $new_year_views );
			update_post_meta( $post_id, '_wp_manga_year_views_value', $views ); // clone to sort by value
		
		}
		
		function _update_ratings( $post_id, $ratings = array() ){
		
			if( empty( $ratings ) || !isset( $ratings['avg'] ) || !isset( $ratings['numbers'] ) ){
				return false;
			}
		
			extract( $ratings );
		
			$totals = intval( (float)trim($avg) * (float)$numbers );
			$int_avg_totals = intval( $avg ) * $numbers;
		
			$above_avg_numbers = $totals - $int_avg_totals;
			$int_avg_numbers = $numbers - $above_avg_numbers;
		
			$rates = array();
		
			for( $i = 1; $i <= $above_avg_numbers; $i++ ){
				$rates[] = intval( $avg + 1 );
			}
		
			for( $i = 1; $i <= $int_avg_numbers; $i++ ){
				$rates[] = intval( $avg );
			}
		
			update_post_meta( $post_id, '_manga_avarage_reviews', $avg );
			update_post_meta( $post_id, '_manga_reviews', $rates );
		
			return true;
		}
		
		function _upload_thumb($url, $post_id = 0){
			include_once( ABSPATH . 'wp-admin/includes/image.php' );
			$content = file_get_contents( $url );
		
			$pathinfo = pathinfo( $url );
		
			if( ! $content ){
				return false;
			}
		
			$upload_dir = wp_upload_dir();
		
			if( ! file_exists( $upload_dir['basedir'] . '/images' ) ){
				if( ! wp_mkdir_p( $upload_dir['basedir'] . '/images' ) ){
					error_log_die([
						'function' => __FUNCTION__,
						'message'  => "Cannot make dir $extract",
						'cancel'   => true,
					]);
				}
			}
		
			$file_tmp_path = $upload_dir['basedir'] . '/images/' . $pathinfo['filename'] . '-' . $post_id . '.' . explode('?',$pathinfo['extension'])[0];
		
			file_put_contents( $file_tmp_path, $content );
		
			$wp_filetype = wp_check_filetype(basename($file_tmp_path), null );
		
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_title' => $post_id,
				'post_content' => '',
				'post_status' => 'inherit'
			);
		
			$attach_id = wp_insert_attachment( $attachment, $file_tmp_path );
		
			$imagenew = get_post( $attach_id );
			$fullsizepath = get_attached_file( $imagenew->ID );
			$attach_data = wp_generate_attachment_metadata( $attach_id, $fullsizepath );
			wp_update_attachment_metadata( $attach_id, $attach_data );
		
			return $attach_id;
		}
		
		function _import_thememod($options){
			// Default message.
			$message = 'failed';
		
			$decoded  = base64_decode( $options ); // phpcs:ignore
			
			// Convert the options to an array.
			$options = maybe_unserialize( $decoded );
			
			if ( $options ) {
				$options = (array)$options;
				/*
				$options['copyright'] = 'Madara WordPress Theme by Mangabooth.com';
				$options = serialize($options);
				$encoded = base64_encode($options);
				echo $encoded;exit;*/
		
				$options_safe = array();
		
				// Get settings array.
				$settings = get_option( apply_filters( 'ot_options_id', 'option_tree' ) );
		
				// Has options.
				if ( is_array( $options ) ) {
					foreach($options as $option => $val){
						if($val == 'on'){
							$val = 1;
						} else if($val == 'off'){
							$val = 0;
						}
						set_theme_mod($option, $val);
					}
		
					$message = 'success';
				}
			}
		
			return $message;
		}
		
		/**
		 * Import widget JSON data
		 *
		 * @since 0.4
		 * @global array $wp_registered_sidebars
		 * @param object $data JSON widget data from .wie file.
		 * @return array Results array
		 */
		function wie_import_data($data)
		{
			global $wp_registered_sidebars;
	
			// Have valid data?
			// If no data or could not decode.
			if (empty($data) || ! is_object($data)) {
				$message = esc_html__('Import data is invalid.', 'madara');
				wp_send_json_error( ['message' => $message, 'data' => $message] );
			}
	
			// Hook before import.
			do_action('wie_before_import');
			$data = apply_filters('wie_import_data', $data);
	
			// Get all available widgets site supports.
			$available_widgets = $this->wie_available_widgets();
	
			// Get all existing widget instances.
			$widget_instances = array();
			foreach ($available_widgets as $widget_data) {
				$widget_instances[$widget_data['id_base']] = get_option('widget_' . $widget_data['id_base']);
			}
	
			// clean existing widgets
			$sidebars_widgets = get_option('sidebars_widgets');
			foreach($sidebars_widgets as $id => $widgets){
				$sidebars_widgets[$id] = array();
			}
			update_option('sidebars_widgets', $sidebars_widgets);
	
			// Begin results.
			$results = array();
	
			// Loop import data's sidebars.
			foreach ($data as $sidebar_id => $widgets) {
				// Skip inactive widgets (should not be in export file).
				if ('wp_inactive_widgets' === $sidebar_id) {
					continue;
				}
	
				// Check if sidebar is available on this site.
				// Otherwise add widgets to inactive, and say so.
				if (isset($wp_registered_sidebars[$sidebar_id])) {
					$sidebar_available    = true;
					$use_sidebar_id       = $sidebar_id;
					$sidebar_message_type = 'success';
					$sidebar_message      = '';
				} else {
					$sidebar_available    = false;
					$use_sidebar_id       = 'wp_inactive_widgets'; // Add to inactive if sidebar does not exist in theme.
					$sidebar_message_type = 'error';
					$sidebar_message      = esc_html__('Widget area does not exist in theme (using Inactive)', 'widget-importer-exporter');
				}
	
				// Result for sidebar
				// Sidebar name if theme supports it; otherwise ID.
				$results[$sidebar_id]['name']         = ! empty($wp_registered_sidebars[$sidebar_id]['name']) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id;
				$results[$sidebar_id]['message_type'] = $sidebar_message_type;
				$results[$sidebar_id]['message']      = $sidebar_message;
				$results[$sidebar_id]['widgets']      = array();
	
				// Loop widgets.
				foreach ($widgets as $widget_instance_id => $widget) {
					$fail = false;
	
					// Get id_base (remove -# from end) and instance ID number.
					$id_base            = preg_replace('/-[0-9]+$/', '', $widget_instance_id);
					$instance_id_number = str_replace($id_base . '-', '', $widget_instance_id);
	
					// Does site support this widget?
					if (! $fail && ! isset($available_widgets[$id_base])) {
						$fail                = true;
						$widget_message_type = 'error';
						$widget_message      = esc_html__('Site does not support widget', 'widget-importer-exporter'); // Explain why widget not imported.
					}
	
					// Filter to modify settings object before conversion to array and import
					// Leave this filter here for backwards compatibility with manipulating objects (before conversion to array below)
					// Ideally the newer wie_widget_settings_array below will be used instead of this.
					$widget = apply_filters('wie_widget_settings', $widget);
	
					// Convert multidimensional objects to multidimensional arrays
					// Some plugins like Jetpack Widget Visibility store settings as multidimensional arrays
					// Without this, they are imported as objects and cause fatal error on Widgets page
					// If this creates problems for plugins that do actually intend settings in objects then may need to consider other approach: https://wordpress.org/support/topic/problem-with-array-of-arrays
					// It is probably much more likely that arrays are used than objects, however.
					$widget = json_decode(wp_json_encode($widget), true);
	
					// Filter to modify settings array
					// This is preferred over the older wie_widget_settings filter above
					// Do before identical check because changes may make it identical to end result (such as URL replacements).
					$widget = apply_filters('wie_widget_settings_array', $widget);
					
					// No failure.
					if (! $fail) {
						// Add widget instance
						$single_widget_instances   = get_option('widget_' . $id_base); // All instances for that widget ID base, get fresh every time.
						$single_widget_instances   = ! empty($single_widget_instances) ? $single_widget_instances : array(
							'_multiwidget' => 1,   // Start fresh if have to.
						);
						$single_widget_instances[] = $widget; // Add it.
	
						// Get the key it was given.
						end($single_widget_instances);
						$new_instance_id_number = key($single_widget_instances);
	
						// If key is 0, make it 1
						// When 0, an issue can occur where adding a widget causes data from other widget to load,
						// and the widget doesn't stick (reload wipes it).
						if ('0' === strval($new_instance_id_number)) {
							$new_instance_id_number = 1;
							$single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
							unset($single_widget_instances[0]);
						}
	
						// Move _multiwidget to end of array for uniformity.
						if (isset($single_widget_instances['_multiwidget'])) {
							$multiwidget = $single_widget_instances['_multiwidget'];
							unset($single_widget_instances['_multiwidget']);
							$single_widget_instances['_multiwidget'] = $multiwidget;
						}
	
						// Update option with new widget.
						update_option('widget_' . $id_base, $single_widget_instances);
	
						// Assign widget instance to sidebar.
						// Which sidebars have which widgets, get fresh every time.
						$sidebars_widgets = get_option('sidebars_widgets');
	
						// Avoid rarely fatal error when the option is an empty string
						// https://github.com/churchthemes/widget-importer-exporter/pull/11.
						if (! $sidebars_widgets) {
							$sidebars_widgets = array();
						}
	
						// Use ID number from new widget instance.
						$new_instance_id = $id_base . '-' . $new_instance_id_number;
	
						// Add new instance to sidebar.
						$sidebars_widgets[$use_sidebar_id][] = $new_instance_id;
	
						// Save the amended data.
						update_option('sidebars_widgets', $sidebars_widgets);
	
						// After widget import action.
						$after_widget_import = array(
							'sidebar'           => $use_sidebar_id,
							'sidebar_old'       => $sidebar_id,
							'widget'            => $widget,
							'widget_type'       => $id_base,
							'widget_id'         => $new_instance_id,
							'widget_id_old'     => $widget_instance_id,
							'widget_id_num'     => $new_instance_id_number,
							'widget_id_num_old' => $instance_id_number,
						);
						do_action('wie_after_widget_import', $after_widget_import);
	
						// Success message.
						if ($sidebar_available) {
							$widget_message_type = 'success';
							$widget_message      = esc_html__('Imported', 'widget-importer-exporter');
						} else {
							$widget_message_type = 'warning';
							$widget_message      = esc_html__('Imported to Inactive', 'widget-importer-exporter');
						}
					}
	
					// Result for widget instance
					$results[$sidebar_id]['widgets'][$widget_instance_id]['name']         = isset($available_widgets[$id_base]['name']) ? $available_widgets[$id_base]['name'] : $id_base;      // Widget name or ID if name not available (not supported by site).
					$results[$sidebar_id]['widgets'][$widget_instance_id]['title']        = ! empty($widget['title']) ? $widget['title'] : esc_html__('No Title', 'widget-importer-exporter');  // Show "No Title" if widget instance is untitled.
					$results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
					$results[$sidebar_id]['widgets'][$widget_instance_id]['message']      = $widget_message;
				}
			}
	
			// Hook after import.
			do_action('wie_after_import');
	
			// Return results.
			return apply_filters('wie_import_results', $results);
		}
		
		/**
		 * Available widgets
		 *
		 * Gather site's widgets into array with ID base, name, etc.
		 * Used by export and import functions.
		 *
		 * @since 0.4
		 * @global array $wp_registered_widget_updates
		 * @return array Widget information
		 */
		function wie_available_widgets()
		{
			global $wp_registered_widget_controls;
	
			$widget_controls = $wp_registered_widget_controls;
	
			$available_widgets = array();
	
			foreach ($widget_controls as $widget) {
				// No duplicates.
				if (! empty( $widget['id_base'] ) && ! isset( $available_widgets[ $widget['id_base'] ] )) {
					$available_widgets[ $widget['id_base'] ]['id_base'] = $widget['id_base'];
					$available_widgets[ $widget['id_base'] ]['name']    = $widget['name'];
				}
			}
	
			return apply_filters( 'wie_available_widgets', $available_widgets );
		}
		
		function _sample_data_page(){
			?>
			<style type="text/css">
				#page-sample-data, #page-sample-data p{font-size:14px}
				#page-sample-data .btn{display:inline-block;padding:3px 10px;background:#007cba;color:#FFF;font-size:14px}
				#page-sample-data .btn i{display: none}
				#page-sample-data .btn:hover{background:#006ba1; color:#FFF}
				#page-sample-data .btn.loading{background:#999;border:none}
				#page-sample-data .btn.loading i{display: inline-block;}
				#page-sample-data ul{list-style-type: disc;padding-left:15px}
			</style>
			<div id="page-sample-data">
				<h3 style="margin: 40px 0">Install sample data for Madara Child X</h3>
				<p>Demo Page: <a href="https://live.mangabooth.com/x" target="_blank">Madara Child X</a></p>
				<p><a href="javascript:void(0)" class="btn" onclick="madara_install_sampledata(this)"><i class="fas fa-spinner fa-spin"></i> Click here</a></p>
				
				<p><strong>Notes:</strong>
					<ul>
						<li>New data will be imported each time running the Sample Data installation</li>
						<li>Make sure to run only on a fresh site because existing settings will be replaced</li>
					</ul>
				</p>
			</div>
			<script type="text/javascript">
				function madara_install_sampledata(obj){
					if(!jQuery(obj).hasClass('loading')){
						jQuery(obj).addClass('loading');
						jQuery.ajax({
							method : 'POST',
							url : ajaxurl,
							data : {
								action: 'madara_install_data'
							},
							success : function( response ){
								var data = response.data;
								console.log(data.data);
								alert(data.message);
								jQuery('#page-sample-data .btn').after("<p>View <a href='/'>your site</a> now</p>")
							},
							error: function(err){
								console.log(err);
								alert("error");
							},
							complete: function(){
								jQuery(obj).removeClass('loading');
							}
						});
					}
					
					return false;
				}
			</script>
			<?php
		}
	}
}

if(!function_exists('error_log_die')){
	function error_log_die($args){
		/**
		 * 'function' => __FUNCTION__,
						'message'  => "Cannot make dir $extract",
						'cancel'   => true,
		 */
		error_log($args['function']);
		error_log($args['message']);

		if(isset($args['cancel']) && $args['cancel']){
			wp_die();
		}
	}
}