<?php
	/**
	 * Template Name: My Bookmark
	 *
	 * @package madara
	 */

	use App\Madara;
		 
	if ( ! is_user_logged_in() ) {
		wp_redirect( home_url() );
		exit;
	}
	
	get_header();

	$archive_content_columns     = Madara::getOption( 'archive_content_columns', 3 );
	$page_custom_css = Madara::getOption('page_custom_css', '');
	$madara_sidebar              = madara_get_theme_sidebar_setting();

	$wp_manga_functions = madara_get_global_wp_manga_functions();
	$user_id       = get_current_user_id();
	$bookmarks     = $wp_manga_functions->get_bookmarked_mangas( $user_id, Madara::getOption('manga_bookmark_list_orderby', ''));
	$reading_style = $wp_manga_functions->get_reading_style();
	$reading_style = ! empty( $reading_style ) ? $reading_style : 'paged';
?>

	<div class="c-page-content">
		<div class="content-area">
			<div class="container">
				<div class="row <?php echo esc_attr( $madara_sidebar == 'left' ? 'sidebar-left' : '') ?>">
				
					<div class="main-col <?php echo esc_attr( $madara_sidebar != 'full' && ( is_active_sidebar( 'manga_archive_sidebar' ) || is_active_sidebar( 'main_sidebar' ) ) ? 'col-md-8 col-sm-8' : 'sidebar-hidden col-md-12 col-sm-12'); ?>">
						<h1><?php the_title();?></h1>
						<?php do_action('madara_before_page_content'); ?>
						<div class="content"><?php the_content(); ?></div>
						<div class="page-list-bookmark">
							
							<?php if ( ! empty( $bookmarks ) ) {
								$order = Madara::getOption('manga_bookmark_list_order', 'oldest_first');
								if($order == 'newest_first')
									$bookmarks = array_reverse($bookmarks); // latest bookmarked items on top
									foreach ( $bookmarks as $bookmark ) {

									$post = isset($bookmark['post']) ? $bookmark['post'] : get_post( intval( $bookmark['id'] ) );

									if ( $post == null || $post->post_status !== 'publish' ) {
										continue;
									}
									
									$post_id = $bookmark['id'];

									//get bookmarked chapter
									$chapter = null; // reset $chapter variable
									if ( class_exists( 'WP_MANGA' ) && ! empty( $bookmark['c'] ) && ! is_array( $bookmark['c'] ) ) {
										$wp_manga_chapter = madara_get_global_wp_manga_chapter();
										$chapter          = $wp_manga_chapter->get_chapter_by_id( $post->ID, $bookmark['c'] );
									}
									
									$permalink = get_the_permalink( $post_id );
									$title     = get_the_title( $post_id );
									$time      = get_post_meta( $post_id, '_latest_update', true );
									?>
									<div class="manga__item">
										<div class="item-thumb">
											<?php if ( has_post_thumbnail( $post_id ) ) { ?>
												<a href="<?php echo esc_url( $permalink ); ?>" title="<?php echo esc_attr( $title ); ?>">
													<?php echo madara_thumbnail(('manga-thumb-1'), $post_id ); ?>
												</a>
											<?php } ?>
										</div>
										<div class="item-content">
											<div class="mange-name">
												<div class="item-infor">
													<div class="post-title">
														<?php if ( ! empty( $title ) ) { ?>
															<h3>
																<a href="<?php echo esc_url( $permalink ); ?>"><?php echo esc_attr( $title ); ?></a>
															</h3>
														<?php } ?>
													</div>
												</div>
											</div>
											<div class="manga-excerpt">            
												<?php 
												global $post;
													echo apply_filters('the_content',$post->post_content);
												?>
											</div>
											<div class="action">
												<a href="<?php echo esc_url( $permalink ); ?>" title="<?php echo esc_attr( $title ); ?>"><?php esc_html_e('Read',WP_MANGA_X_TEXTDOMAIN);?></a>
												<a class="wp-manga-delete-bookmark" title="Delete bookmark" href="javascript:void(0)" data-post-id="<?php echo esc_attr( $post_id ); ?>"><i class="fa fa-bookmark" aria-hidden="true"></i></a>
											</div>
										</div>
									</div>
									<?php
								}
							} else { ?>
									<p><?php esc_html_e( 'No Manga Bookmarked', WP_MANGA_X_TEXTDOMAIN ); ?> </p>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>


	<?php
	get_footer();
