<?php
	/**
	 * Template Name: Calendar Manga
	 *
	 * @package madara
	 */

	use App\Madara;
	
	get_header();

	global $wp_manga_functions;
    // Calendar row
	$currentDate = new DateTime();
	$dayNames = [esc_html__('Sun', WP_MANGA_X_TEXTDOMAIN), esc_html__('Mon', WP_MANGA_X_TEXTDOMAIN), esc_html__('Tue', WP_MANGA_X_TEXTDOMAIN), esc_html__('Wed', WP_MANGA_X_TEXTDOMAIN), esc_html__('Thu', WP_MANGA_X_TEXTDOMAIN), esc_html__('Fri', WP_MANGA_X_TEXTDOMAIN), esc_html__('Sat', WP_MANGA_X_TEXTDOMAIN)];
	$calendar = '';

	$archive_content_columns     = Madara::getOption( 'archive_content_columns', 3 );
	$page_custom_css = Madara::getOption('page_custom_css', '');
	$madara_sidebar              = madara_get_theme_sidebar_setting();
	// Retrieve the 'release_date' query variable
	$requested_release_date = (get_query_var('release_date')) ? get_query_var('release_date') : $currentDate->format('Y-m-d');
	
	?>

	<div class="c-page-content style-1">
		<div class="content-area <?php echo esc_attr($page_custom_css);?>">
			<div class="container">
				<div class="row <?php echo esc_attr( $madara_sidebar == 'left' ? 'sidebar-left' : '') ?>">
					<?php do_action('madara_before_page_content'); ?>
					<div class="main-col <?php echo esc_attr( $madara_sidebar != 'full' && ( is_active_sidebar( 'manga_archive_sidebar' ) || is_active_sidebar( 'main_sidebar' ) ) ? 'col-md-8 col-sm-8' : 'sidebar-hidden col-md-12 col-sm-12'); ?>">

						<?php get_template_part( 'html/main-bodytop' ); ?>

						<div class="main-col-inner c-page">

							<h1 class="item-title">
								<?php echo esc_html(get_the_title($page_id)); ?>
							</h1>

							<div class="content"><?php the_content(); ?></div>

							<div class="calendar_row">
								<?php 

								// Loop through the next 7 days
								for ($i = 0; $i < 7; $i++) {
									$dayOfWeekIndex = $currentDate->format('w');
									
									// Add the 'release_date' query variable to the URL
									$release_date_url = add_query_arg('release_date', $currentDate->format('Y-m-d'), get_permalink());					

									// Check if the current date matches the requested release date
									$activeClass = ($requested_release_date == $currentDate->format("Y-m-d")) ? 'active' : '';

									echo '<a href="' . esc_url($release_date_url) . '" class="calendar-box ' . esc_attr($activeClass) . '"><span class="date">' . $currentDate->format("M d") . '</span><span class="weekday">' . $dayNames[$dayOfWeekIndex] . '</span></a>';

									// Move to the next day
									$currentDate->modify('+1 day');
								}
								?>
							</div>

							<div class="calendar-manga row-eq-height">
							<?php
							
							$schedule_by = Madara::getOption('calendar_schedule_by', 1);
							
							if($schedule_by == 2){
								$results = manga_get_mangas_by_chapter_schedule($requested_release_date);
							
								if (!$results) {
									echo esc_html__('No manga found for the selected day.', WP_MANGA_X_TEXTDOMAIN);
									return;
								}
								
								foreach($results as $result){
									$manga_id = $result['post_id'];
									global $post;
									$post = get_post($manga_id);
									setup_postdata($post);
									
									get_template_part('/madara-core/content/content-archive-badge');
								}
	
								wp_reset_postdata();
							} else {
								$date = date_create_from_format("Y-m-d", $requested_release_date);
								$query = madara_child_x_get_mangas_by_day_release($date->format('w'));
								while($query->have_posts()){
									$query->the_post();
									get_template_part('/madara-core/content/content-archive-badge');
								}
							}

							?>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php
	get_footer();
