<?php

	/**
	 * The Template for History section (list of recent read mangas) in User Settings page
	 *
	 * This template can be overridden by copying it to your-child-theme/madara-core/user/history.php
	 *
	 * HOWEVER, on occasion Madara will need to update template files and you
	 * (the theme developer) will need to copy the new files to your theme to
	 * maintain compatibility. We try to do this as little as possible, but it does
	 * happen. When this occurs the version of the template file will be bumped and
	 * we will list any important changes on our theme release logs.
	 * @package Madara
	 * @version 1.7.2.2
	 */
	 
	 if ( ! is_user_logged_in() ) {
		return;
	}

	$user_id       = get_current_user_id();
	
?>

<div class="tab-group-item">

	<h2><?php echo esc_html__('Completed Payments', WP_MANGA_X_TEXTDOMAIN);?></h2>
	<?php echo do_shortcode('[madara_child_x_payment_history]');?>
	<h2><?php echo esc_html__('Pending Payments', WP_MANGA_X_TEXTDOMAIN);?></h2>
	<?php echo do_shortcode('[mycred_buy_pending]');?>
	<h2><?php echo esc_html__('Coin Spending', WP_MANGA_X_TEXTDOMAIN);?></h2>
	<?php echo do_shortcode('[mycred_history user_id="current" number=20]');?>
</div>
