<?php

	/**
	 * The Template for Manga Detail page
	 *
	 * This template can be overridden by copying it to your-child-theme/madara-core/manga-single.php
	 *
	 * HOWEVER, on occasion Madara will need to update template files and you
	 * (the theme developer) will need to copy the new files to your theme to
	 * maintain compatibility. We try to do this as little as possible, but it does
	 * happen. When this occurs the version of the template file will be bumped and
	 * we will list any important changes on our theme release logs.
	 * @package Madara
	 * @version 1.7.2.2 
	 */ 

	get_header();

	use App\Madara;

	$wp_manga           = madara_get_global_wp_manga();
	$wp_manga_functions = madara_get_global_wp_manga_functions();
    $thumb_size         = 'full';
	$post_id            = get_the_ID();
    
    $is_oneshot = is_manga_oneshot($post_id);
    
    if($is_oneshot){
        get_template_part( '/madara-core/manga', 'oneshot' );
        exit;
    }

	$madara_single_sidebar      = madara_get_theme_sidebar_setting();
	$madara_breadcrumb          = Madara::getOption( 'manga_single_breadcrumb', 'on' );
	$manga_profile_background   = madara_output_background_options( 'manga_profile_background' );
	$manga_single_summary       = Madara::getOption( 'manga_single_summary', 'on' );

	$wp_manga_settings = get_option( 'wp_manga_settings' );
    
	$related_manga     = isset( $wp_manga_settings['related_manga'] ) ? $wp_manga_settings['related_manga'] : null;
    
    $info_summary_layout = Madara::getOption('manga_profile_summary_layout', 1);
    $manga_reading_social_share = Madara::getOption( 'manga_reading_social_share', 'off' );
    $user_bookmark = get_option('users_can_register') ? (isset( $wp_manga_settings['user_bookmark'] ) ? $wp_manga_settings['user_bookmark'] : 1) : 0;
    $is_oneshot = is_manga_oneshot($post_id);
    $genres     = $wp_manga_functions->get_manga_genres( $post_id );
    $authors    = $wp_manga_functions->get_manga_authors( $post_id);
    $vote       = $wp_manga_functions->get_total_vote( $post_id );
    $rate       = $wp_manga_functions->get_total_review( $post_id );
    $tags       = $wp_manga_functions->get_manga_tags($post_id);
    $type       = get_post_meta($post_id, '_wp_manga_chapter_type', true);
    switch($type){
        case 'novel':
            $type_show = esc_html__('Novel',WP_MANGA_X_TEXTDOMAIN);
            break;
        case 'video':
            $type_show = esc_html__('Video',WP_MANGA_X_TEXTDOMAIN);
            break;
        case 'manga':
        default:
            $type_show = esc_html__('Manga',WP_MANGA_X_TEXTDOMAIN);
            break;
    }
do_action( 'before_manga_single' );
 ?>
<div <?php post_class();?>>
<div class="profile-manga" style="<?php echo esc_attr( $manga_profile_background != '' ? $manga_profile_background : '');?>">
    <div class="container">
        <div class="row">
            <div class="left col-12 col-sm-12 col-md-4">
                <div class="manga-thumb">
                     <?php if ( has_post_thumbnail() ) { ?>
                        <div class="summary_image">
                            <a href="<?php echo get_the_permalink(); ?>">
                                <?php echo madara_thumbnail( $thumb_size ); ?>
                            </a>
                            <?php madara_manga_title_badges_html( $post_id, 1 ); ?>
                            <?php
                            $badge = Madara::getOption('show_chapter_type', 0);
                            if($badge && $badge == 2){
                                $type_show = $wp_manga_functions->get_manga_type($post_id);
                            }

                            if($badge && $type_show){
                            ?>
                            <span class="manga-chapter-type"><?php echo $type_show;?></span>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>

                <div class="action-buttons">
                    <div class="left">
                        <?php  
                            if(!$is_oneshot){                            
                                set_query_var( 'manga_id', $post_id );
                                get_template_part('madara-core/single/quick-buttons');
                            }
                            if($user_bookmark){?>
                            <div class="add-bookmark">
                                <?php
                                    $wp_manga_functions->bookmark_link_e();
                                ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <?php if ( is_active_sidebar( 'manga_single_sidebar' ) ) { ?>
                    <div class="sidebar-col">
                        <?php get_sidebar(); ?>
                    </div>
                <?php } ?>
            </div>
            <div class="right col-12 col-sm-12 col-md-8">
                <div class="post-title">                    
                    <h1>
						<?php echo esc_html( get_the_title() ); ?>
                    </h1>
                </div>
                <div class="post-content">

                <?php 
			
                if( $genres != '') {?>
                    <div class="post-content_item genres">
                        <div class="summary-content">
                            <div class="genres-content">
                                <?php echo wp_kses_post( str_replace(',', '', $genres )); ?>
                            </div>
                        </div>
                    </div>
			    <?php } ?>

                <div class="description-summary">

                    <div class="summary__content">
                        <?php 
                        global $post;
                        echo apply_filters('the_content', $post->post_content);
                        ?>
                    </div>

                </div>

                <div class="author-row">
                    
                        <div class="post-content_item">
                            <?php 
                                $publishers = get_the_term_list( $post_id, 'wp-manga-publisher', '', ', ', '' );
                                if ($publishers) {
                                ?>
                                <div class="summary-heading">
                                <h5>
                                    <?php echo esc_html__( 'Publisher', WP_MANGA_X_TEXTDOMAIN ); ?>
                                </h5>
                                </div>
                                <div class="summary-content">
                                    <div class="author-content">
                                        <?php
                                            echo wp_kses_post($publishers );
                                        ?>
                                    </div>
                                </div>
                                <?php
                            } ?>
                            
                        </div>
                </div>
                <div class="rating manga-info-row">
                    <div class="summary-heading">
                        <h5><?php echo esc_attr__( 'Rating', WP_MANGA_X_TEXTDOMAIN ); ?></h5>
                    </div>
                    <div class="summary-content">
                        <div class="post-content">
                            <div class="loader-inner ball-pulse">
                                <div></div>
                                <div></div>
                                <div></div>
                            </div>
                        </div>
                        <div class="post-rating">                            
                            <?php
                                $wp_manga_functions->manga_rating_display( $post_id, true );
                            ?>
                        </div>
                        <?php if($vote > 0){?>                            
                            <div class="vote-details" vocab="https://schema.org/" typeof="AggregateRating">
                                <span property="itemReviewed" typeof="Book"><span class="rate-title" property="name" title="<?php echo esc_attr(get_the_title($post_id));?>"><?php echo esc_html(get_the_title($post_id));?></span></span><?php echo sprintf(wp_kses(__('<span> <span> Average <span property="ratingValue" id="averagerate"> %s</span> / <span property="bestRating">5</span> </span> </span> out of <span property="ratingCount" id="countrate">%s</span>', WP_MANGA_X_TEXTDOMAIN), array('span' => array('rel' => 1,'typeof'=> 1,'property' => 1,'id' => 1))), $rate, $vote ? $vote : 0);?>
                            </div>	
                        <?php } ?>                       
                    </div>
                </div>

                <?php do_action('wp-manga-manga-properties', $post_id);?>
            
                <?php do_action('wp-manga-after-manga-properties', $post_id);?>

                <?php do_action('wp-manga-manga-status', $post_id);?>

                    <?php

                        $like_count = get_post_meta($post_id, 'kodex_post_likes_count', true);
                        $dislike_count = get_post_meta($post_id, 'kodex_post_dislikes_count', true);
                        if($like_count > 0 || $dislike_count > 0){?>
                        <div class="kodex-rating rating">
                            <div class="post-content_item">
                                <div class="summary-heading">
                                    <h5><?php echo esc_attr__( 'Rating', WP_MANGA_X_TEXTDOMAIN ); ?></h5>
                                </div>	
                                <span><?php echo ($like_count / ($like_count + $dislike_count)) * 100 . '%';?></span>
                            </div>

                        </div>
                    <?php } ?>

                <?php if (get_post_meta($post_id,'manga_release_schedule',true) && !in_array(get_post_meta($post_id,'_wp_manga_status',true), ['end','canceled'])) {?>
                    <div class="release-time author-row">
                        <?php echo get_post_meta($post_id,'manga_release_schedule',true);?>
                    </div>            
                <?php }?>

                <div class="tags-list">
                    <?php 
                        if($tags != '') {?>
                            <div class="post-content_item">
                                <div class="summary-content">
                                    <div class="tags-content">
                                        <?php echo wp_kses_post( str_replace(',','',$tags) ); ?>
                                    </div>
                                </div>
                            </div>
                        <?php } 
                    ?>
                </div>
            </div>

                <?php do_action('wp-manga-chapter-listing', $post_id); ?>

            </div>
        </div>

        <?php /*
        <div class="donate-box mobile">
            <h3>Support Author</h3>
            <p>Pledge your support to authors for more creative works.</p>
            <form class="donate-form">
                <ul class="fixed-options">
                    <li>
                        <input type="radio" id="5-shards" name="donate" value="5">
                        <label for="5-shards">5 Shards</label>
                    </li>
                    <li>
                        <input type="radio" id="10-shards" name="donate" value="10">
                        <label for="10-shards">10 Shards</label>
                    </li>
                    <li>
                        <input type="radio" id="50-shards" name="donate" value="50">
                        <label for="50-shards">50 Shards</label>
                    </li>
                </ul>
                <div class="custom-option">
                    <input type="number" min="0" placeholder="Type custom amount">
                    <button type="submit">Donate</button>
                </div>
            </form>
        </div>
        */?>
        <?php 
        if ( $related_manga == 1 ) {
            get_template_part( '/madara-core/manga', 'related' );
        }
        
        ?>

        <!-- comments-area -->
        <?php 
        
        do_action( 'wp_manga_discussion' ); ?>
        <!-- END comments-area -->
        
    </div>
</div>

<?php 
do_action( 'after_manga_single' ); ?>
</div>
<?php get_footer();