<?php
	/**
	 * The Template for Manga Chapter Reading page
	 *
	 * This template can be overridden by copying it to your-child-theme/madara-core/manga-single-reading.php
	 *
	 * HOWEVER, on occasion Madara will need to update template files and you
	 * (the theme developer) will need to copy the new files to your theme to
	 * maintain compatibility. We try to do this as little as possible, but it does
	 * happen. When this occurs the version of the template file will be bumped and
	 * we will list any important changes on our theme release logs.
	 * @package Madara
	 * @version 1.7.3.10
	 */

	 use App\Madara;

	$manga_id  = get_the_ID();
	$reading_chapter = function_exists('madara_permalink_reading_chapter') ? madara_permalink_reading_chapter() : false;

	if(!$reading_chapter){
		
		 // support Madara Core before 1.6
		 if($chapter_slug = get_query_var('chapter')){
			global $wp_manga_functions;
			$reading_chapter = $wp_manga_functions->get_chapter_by_slug( $manga_id, $chapter_slug );
		 }

		 if(!$reading_chapter){
			global $wp_query;
			$wp_query->set_404();
			status_header( 404 );
			get_template_part( 404 ); exit();
		 }
	}

	$cur_chap = $reading_chapter['chapter_slug'];

	$wp_manga           = madara_get_global_wp_manga();
	$wp_manga_functions = madara_get_global_wp_manga_functions();


	$style    = isset( $_GET['style'] ) ? $_GET['style'] : $wp_manga_functions->get_reading_style();

	$wp_manga_settings = get_option( 'wp_manga_settings' );
	$related_manga     = isset( $wp_manga_settings['related_manga'] ) ? $wp_manga_settings['related_manga'] : null;
	if($related_manga == 1){
		$related_manga = Madara::getOption( 'manga_reading_related', 'on' ) == 'on' ? 1 : 0;
	}
	$madara_single_sidebar      = madara_get_theme_sidebar_setting();
	$madara_breadcrumb          = Madara::getOption( 'manga_single_breadcrumb', 'on' );
	$manga_reading_discussion   = Madara::getOption( 'manga_reading_discussion', 'on' );
	$manga_reading_social_share = Madara::getOption( 'manga_reading_social_share', 'off' );

	$chapter_type = get_post_meta( $manga_id, '_wp_manga_chapter_type', true );
	$is_text_chapter_right_sidebar = ($madara_single_sidebar != 'full' && $chapter_type == 'text' && Madara::getOption( 'manga_reading_text_sidebar', 'on' ) == 'on') ? true : false;

	if ( $madara_single_sidebar == 'full' || $is_text_chapter_right_sidebar ) {
		$main_col_class = 'sidebar-hidden col-12 col-sm-12 col-md-12 col-lg-12';
	} else {
		$main_col_class = 'main-col col-12 col-sm-8 col-md-8 col-lg-8';
	}

	$is_novel = $chapter_type == 'text' ? true : false;

	get_header();

?>
    <div class="c-page-content style-1 reading-content-wrap chapter-type-<?php echo esc_attr($chapter_type == '' ? 'manga' : $chapter_type);?>" data-site-url="<?php echo home_url( '/' ); ?>">
        <div class="content-area">
            <div class="container">
                <div class="row">
                    <div class="main-col col-sm-12 sidebar-hidden">
						<?php

						$madara_show_chapter_heading = Madara::getOption( 'chapter_heading', 'on' );

						if($madara_show_chapter_heading == 'on'){?>
							<div class="d-flex justify-content-between align-items-center">
								<div class="prev-chap-item">
									<a style="font-size:22px" href="<?php echo get_the_permalink($manga_id); ?>" class="back-to-manga-detail"><i class="fa fa-chevron-left" aria-hidden="true"></i></a>
									<div class="chap-item">
										<?php
											if ( has_post_thumbnail($manga_id) ) { ?>
												<a href="<?php echo get_the_permalink(); ?>" title="<?php echo esc_attr(get_the_title());?>">
													<?php echo madara_thumbnail('manga_wg_post_1'); ?>
												</a>
											<?php }
										?>
										<h3><a href="<?php echo get_the_permalink(); ?>" title="<?php echo esc_attr(get_the_title());?>"><?php echo get_the_title($manga_id) ?></a></h3>
									</div>
								</div>
								<!-- <div class="chapter-nav">
									<button type="button" class="prev"><i class="fa fa-chevron-left" aria-hidden="true"></i></button>
									<button type="button" class="next"><i class="fa fa-chevron-right" aria-hidden="true"></i></button>
								</div> -->
							</div>
						<?php }  
						?>
						<h1 id="chapter-heading">
							<?php

								$manga = get_post($manga_id);
								echo esc_html($reading_chapter['chapter_name']);

								echo '<ul class="reading_actions">';
								do_action('madara_chapter_reading_actions_list_items'); 
								echo '</ul>';
							?>
						</h1>
                        <!-- container & no-sidebar-->
                        <div class="main-col-inner">
                            <div class="c-blog-post">
							<div style="display: none;" class="entry-header header" id="manga-reading-nav-head" data-position="header" data-chapter="<?php echo esc_attr($cur_chap);?>" data-id="<?php echo esc_attr(get_the_ID());?>"><?php $wp_manga->manga_nav( 'header' ); ?></div>
                                <div class="entry-content">
                                    <div class="entry-content_wrap">

                                        <div class="read-container">

											<?php echo apply_filters( 'madara_ads_before_content', madara_ads_position( 'ads_before_content', 'body-top-ads' ) ); ?>
											
                                            <div class="reading-content">
												<input type="hidden" id="wp-manga-current-chap" data-id="<?php echo esc_attr($reading_chapter['chapter_id']);?>" value="<?php echo esc_attr($cur_chap);?>"/>
												<?php

                                                global $post;

                                                if( !$post->post_password || ($post->post_password && !post_password_required()) ){

                                                    /**
                                                     * If alternative_content is empty, show default content
                                                     **/
                                                    $alternative_content = apply_filters('wp_manga_chapter_content_alternative', '');

                                                    if(!$alternative_content){
                                                        do_action('wp_manga_before_chapter_content', $cur_chap, $manga_id);

                                                        do_action('wp_manga_chapter_content', $cur_chap, $manga_id);

                                                        do_action('wp_manga_after_chapter_content', $cur_chap, $manga_id);
                                                    } else {
                                                        echo madara_filter_content($alternative_content);
                                                    }

                                                } else {
                                                    // show the password form
                                                    the_content();
                                                }

												?>

                                            </div>

                                        </div>

										<?php if ( $manga_reading_discussion == 'on' ) { ?>
											<div class="row">
												<div class="col-12">
													<!-- comments-area -->
													<?php do_action( 'wp_manga_discussion' ); ?>
													<!-- END comments-area -->
												</div>
											</div>
										<?php } ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="text-reading-footer">
				<div class="container d-flex justify-content-between">
					<div class="left-footer">
						<button class="hamburger open-chaps-list-canvas" type="button" data-toggle="modal" data-target="#chaptersModal"><i class="fa fa-bars" aria-hidden="true"></i></button>
						<h5 class="chap-name"><?php echo esc_html($reading_chapter['chapter_name']);?></h5>
					</div>
					<div class="right-footer">
						<?php
						
						if($is_novel){?>
						<div class="reading-settings">
							<button type="button" class="adjust-fz open-reader-settings"><i class="fa fa-text-width" aria-hidden="true"></i></button>
							<div id="childx-reader-settings">
								<div class="box-content">
									<div class="box-header">
										<button type="button" class="close" aria-label="Close">
											<span aria-hidden="true">&times;</span>
										</button>
									</div>
									<div class="box-body">
										<section class="adj-fs">
											<?php $list_font = ['Times New Roman', 'Helvetica']; ?>
											<h6><?php echo esc_html__('Fonts', WP_MANGA_X_TEXTDOMAIN);?></h6>
											<ul class="theme-set-font">
												<?php foreach ($list_font as $i => $font){
														$font_family_style = ($font == 'Times New Roman' ? 'Times New Roman", Times, serif' : 'Helvetica, sans-serif')
														?>
														<li>
															<input type="radio" value="<?=$font?>" id="<?=$font?>" name="<?=$font?>" />
															<label for="<?=$font?>"><strong style="font-family: <?php echo $font_family_style ?> ">Aa</strong></label>
														</li>
												<?php }?>
											</ul>
										</section>

										<section class="adj-fz">
											<h6><?php echo esc_html__('Text size', WP_MANGA_X_TEXTDOMAIN);?></h6>
											<div class="slidecontainer">
												<span style="font-size:13px">A</span><input type="range" min="10" max="30" value="14" class="slider" id="fontRange"><span style="font-size:20px">A</span>
											</div>
										</section>

										<section class="adj-bg">
											<h6> <?php echo esc_html__('Background', WP_MANGA_X_TEXTDOMAIN);?></h6>
											<span class="theme-set-color">

												<label class="_default" data-schema="default">
												<input name="tc" type="radio" value="_color1" id="col3" checked="checked">
												<strong>T</strong>
												</label>
												
												<label class="_yellow" data-schema="yellow">
												<input name="tc" type="radio" value="_color2" id="col2">
												<strong>T</strong>
												</label>

												<label class="_dark" data-schema="dark">
												<input name="tc" type="radio" value="_color3" id="col1">
												<strong>T</strong>
												</label>

											</span>
										</section>
									</div>
								</div>
							</div>
						</div>
						<?php }?>
						<div class="chap-nav">
							<button type="button" class="prev-chap"><i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo esc_html__('Prev', WP_MANGA_X_TEXTDOMAIN);?></button>
							<button type="button" class="next-chap"><?php echo esc_html__('Next', WP_MANGA_X_TEXTDOMAIN);?> <i class="fa fa-chevron-right" aria-hidden="true"></i></button>
						</div>
					</div>
				</div>
			</div>

			<div class="modal offcanvas-menu shadow pr-0" id="chaptersModal" tabindex="-1" aria-labelledby="chaptersModalLabel" aria-hidden="true" data-backdrop="">
				<div class="m-0 h-100">
					<div class="modal-content border-0 rounded-0">
						<div class="manga">
						
						<h3><?php echo get_the_title($manga_id) ?></h3>
						<div class="meta">
							<span class="views">
								<?php
									$manga_views = get_post_meta( $manga_id, '_wp_manga_views', true );
									echo sprintf(__("<i class='fa fa-eye'></i> %s Views", WP_MANGA_X_TEXTDOMAIN), wp_manga_number_format_short(intval($manga_views)));
								?>
							</span>
							<span class="subs">
								<?php 
									$total_bookmarked = get_post_meta($manga_id, '_wp_user_bookmarked', true);
									if(!$total_bookmarked){
										$total_bookmarked = 0;
									} else {
										$total_bookmarked = count($total_bookmarked);
									}
									echo sprintf(esc_html__('%s Subscribers', WP_MANGA_X_TEXTDOMAIN), $total_bookmarked);
								?>
							</span>
						</div>
						<div class="description-summary">

							<div class="summary__content">
								<?php 
								global $post;
								$content = apply_filters('the_content',$post->post_content);
								$length = 200;
								if(strlen($content) > $length) {
									$content = preg_replace("/^(.{1,$length})(\s.*|$)/s", '\\1...', $content);
								}
								$excerpt = str_replace('&nbsp;'," ", $content);
								echo $excerpt;
								?>
							</div>

						</div>

						</div>
						<div class="chapters">
							<?php do_action('wp-manga-chapter-listing-canvas', $manga_id); ?>
						</div>
					</div>
				</div>
			</div>

        </div>
    </div>
<?php do_action( 'after_manga_single' );
	wp_footer();
?>
