<?php
    /**
	 * The Template for Manga Search results page
	 *
	 * This template can be overridden by copying it to your-child-theme/madara-core/manga-search.php
	 *
	 * HOWEVER, on occasion Madara will need to update template files and you
	 * (the theme developer) will need to copy the new files to your theme to
	 * maintain compatibility. We try to do this as little as possible, but it does
	 * happen. When this occurs the version of the template file will be bumped and
	 * we will list any important changes on our theme release logs.
	 * @package Madara
	 * @version 1.7.3.11
	 */
	 
	 use App\Madara;
    
	/**
	 * @package madara
	 */
	
	?>

	<?php

	get_header();

	/**
	 * madara_before_main_page hook
	 *
	 * @hooked madara_output_before_main_page - 10
	 * @hooked madara_output_top_sidebar - 89
	 *
	 * @author
	 * @since 1.0
	 * @code     Madara
	 */

	do_action( 'madara_before_main_page' );

	global $wp_manga, $wp_manga_functions;
	$s         = esc_html(isset( $_GET['s'] ) ? $_GET['s'] : '');
	$s_type   = isset( $_GET['type'] ) ? $_GET['type'] : '';
	$s_genre   = isset( $_GET['genre'] ) ? $_GET['genre'] : array();
	$s_status  = isset( $_GET['status'] ) ? $_GET['status'] : array();
	$s_orderby = isset( $_GET['m_orderby'] ) ? $_GET['m_orderby'] : '';
	$s_paged   = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
	
	$s_args = madara_get_search_args();

	// if isset type, add query meta to args     
		switch ($s_type) {
		case 'text':
			$s_args['meta_query'][] = array(
				'key' => '_wp_manga_chapter_type',
				'value' => 'text',
				'compare' => '='
			);
			break;
		case 'manga':
			// if manga, value can be 'manga' or empty
			$s_args['meta_query'][] = array(
				'relation' => 'OR',
				array(
					'key' => '_wp_manga_chapter_type',
					'value' => 'manga',
					'compare' => '='
				),
				array(
					'key' => '_wp_manga_chapter_type',
					'compare' => 'NOT EXISTS'
				)
			);
		}

	$s_query = madara_manga_query( $s_args );

	//gen genres of search result
	// if ($s_query->have_posts()) {
	// 	$genres_from_results = array();
	// 	foreach ($s_query->posts as $post) {
	// 		$genres_from_results = array_merge($genres_from_results, wp_get_post_terms($post->ID, 'wp-manga-genre', array('fields' => 'slugs')));
	// 	}
	// 	//prevent duplicate
	// 	$genres_from_results = array_unique($genres_from_results);
	// }

	$manga_genres = get_terms( array(
		'taxonomy' => 'wp-manga-genre',
		'hide_empty' => true,
	));

	$manga_genres = array_map(function($genre){
		return $genre->slug;
	}, $manga_genres);

	$search_header_background = madara_output_background_options( 'search_header_background' );
    $madara_ajax_search = Madara::getOption('madara_ajax_search', 'on');
?>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <!--<header class="site-header">-->
    <div class="c-search-header__wrapper">
        <div class="container">

            <div class="search-content">
                <form role="search" method="get" class="search-form manga-search-form <?php echo (esc_html($madara_ajax_search) == 'on' ? 'ajax' : '');?>" action="<?php echo home_url('/');?>">
						<span class="screen-reader-text"><?php esc_html_e( 'Search for:', WP_MANGA_X_TEXTDOMAIN ); ?></span>
                        <input type="text" class="search-field manga-search-field" placeholder="<?php esc_html_e( 'Search...', WP_MANGA_X_TEXTDOMAIN ); ?>" value="<?php echo esc_attr( stripcslashes( $s )); ?>" name="s">
						<input type="submit" class="search-submit" value="<?php esc_html_e( 'Search', WP_MANGA_X_TEXTDOMAIN ); ?>">
						<div class="loader-inner line-scale">
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                        </div>
                        <input type="hidden" name="post_type" value="wp-manga">
                        <script>
							jQuery(document).ready(function ($) {
								$('form.search-form input.search-field[name="s"]').keyup(function () {
									var s = $('form.search-form input.search-field[name="s"]').val();
									$('form.search-advanced-form input[name="s"]').val(s);
								});

								$('.search-form').on('submit', function(e){
									console.log('click')
									e.preventDefault();
									$('.search-advanced-form').submit();
							});

							});

                        </script>
                </form>
            </div>
			<div class="search-filters">
				<div class="type-filter">
					<p class="filter-title">Type </p>
					<div class="options">
						<a class="btn <?php echo esc_attr(get_query_var('type')=='manga' ? 'active' : '') ?>" href="<?php echo esc_url(add_query_arg('type', 'manga')); ?>">Comic</a>
						<a class="btn <?php echo esc_attr(get_query_var('type')=='text' ? 'active' : '') ?>" href="<?php echo esc_url(add_query_arg('type', 'text')); ?>">Novel</a>
					</div>
				</div>
				<span class="vertical divider"></span>
				<div class="genres-filter">
					<p class="filter-title"> Genres</p>
					<div class="options">
						<?php 					
							if (!empty($manga_genres)) {
								
								$total = count($manga_genres);
								$featured_genres_num = 3;
								if ($s_genre){
									$featured_genres_num = 2;
									echo '<a href="'.esc_url(add_query_arg('genre', $s_genre)).'" class="btn btn-outline-secondary active">'.get_term_by('slug',$s_genre,'wp-manga-genre') -> name.'</a>';
									if (in_array($s_genre, $manga_genres)) {
										//remove genre from array
										$index = array_search($s_genre, $manga_genres);
										unset($manga_genres[$index]);
									}
								}

								$html_dropdown = '';
								foreach ($manga_genres as $index => $genre) {
									if ($index < $featured_genres_num) {
										echo '<a href="'.esc_url(add_query_arg('genre', $genre)).'" class="btn btn-outline-secondary">'.get_term_by('slug',$genre,'wp-manga-genre') -> name.'</a>';
									} else {
										$html_dropdown .= '<a href="'.esc_url(add_query_arg('genre', $genre)).'" class="dropdown-item btn btn-outline-secondary">'.get_term_by('slug',$genre,'wp-manga-genre') -> name.'</a>';
									}
								}
								?>
								<div class="dropdown more-genres-dropdown">
									<button class="btn dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
										Show more
									</button>
									<div class="dropdown-menu">
										<?php echo $html_dropdown; ?>
									</div>
								</div>
								<?php
								}
						?>
					</div>
				</div>
				<span class="vertical divider"></span>
				<div class="sort-by">
					<p class="filter-title">Sort by</p>
					<div class="dropdown options">
						<button class="btn dropdown-toggle <?php echo $s_orderby ? 'active' : ''; ?>" type="button" data-toggle="dropdown" aria-expanded="false">
							<?php
								$arr_data = [
									'relevance' => 'Relevance',
									'latest' => 'Latest',
									'alphabet' => 'A-Z',
									'rating' => 'Rating',
									'trending' => 'Trending',
									'views' => 'Most Views',
									'new-manga' => 'New',									
								];
								echo $s_orderby ? $arr_data[$s_orderby] : 'Sort by';
							?>
						</button>
						<div class="dropdown-menu">
							<a href="<?php echo esc_url(add_query_arg('m_orderby',''));?>" class="dropdown-item btn btn-outline-secondary">Relevance</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','latest'));?>" class="dropdown-item btn btn-outline-secondary">Latest</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','alphabet'));?>" class="dropdown-item btn btn-outline-secondary">A-Z</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','rating'));?>" class="dropdown-item btn btn-outline-secondary">Rating</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','trending'))?>;" class="dropdown-item btn btn-outline-secondary">Trending</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','views'));?>" class="dropdown-item btn btn-outline-secondary">Most Views</a>
							<a href="<?php echo esc_url(add_query_arg('m_orderby','new-manga'));?>" class="dropdown-item btn btn-outline-secondary">New</a>
						</div>
					</div>
				</div>
				<span class="vertical divider"></span>
				<div class="filter-status">
					<p class="filter-title">Status</p>
					<div class="dropdown options">
						<?php 
							global $wp_manga_post_type;
							$default_status = $wp_manga_post_type->get_manga_status();
						?>
						<button class="btn dropdown-toggle <?php echo $s_status ? 'active' : ''; ?>" type="button" data-toggle="dropdown" aria-expanded="false">
							<?php echo $s_status ? $default_status[$s_status] : 'Status'; ?>
						</button>
						<div class="dropdown-menu">
							<?php 
								foreach ($default_status as $key => $value) {
								?>
									<a data-value="<?php esc_attr_e($key); ?>" href="<?php echo esc_url(add_query_arg('status', $key));?>" class="dropdown-item btn btn-outline-secondary"><?php esc_html_e($value); ?></a>
								<?php } 
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="reset-filter"><button type="button" class="btn btn-outline-danger"><i class="fas fa-times"></i> Reset filter </button></div>
    </div><!--</header>-->
    <script type="text/javascript">
		var manga_args = <?php echo str_replace( '\/', '/', json_encode( $s_args ) ); ?>;
    </script>
    <div class="c-page-content">
        <div class="content-area">
            <div class="container">
                <div class="row">
                    <div class="main-col col-md-12 sidebar-hidden">

						<?php get_template_part( 'html/main-bodytop' ); ?>

                        <!-- container & no-sidebar-->
                        <div class="main-col-inner">
							<?php
								if ( $s_query->have_posts() ) {
									?>
                                    <div class="search-wrap">
										<h3 class="h4">
											<i class="<?php madara_default_heading_icon(); ?>"></i> <?php echo sprintf( _n( '%s result for "%s"', '%s results for "%s"', $s_query->found_posts, WP_MANGA_X_TEXTDOMAIN ), $s_query->found_posts, $s ); ?>
										</h3>
                                            <div class="search-lists">
													<?php
													
														while ( $s_query->have_posts() ) {

															$s_query->the_post();
															get_template_part( 'madara-core/content/content', 'search' );

														}														
														
														wp_reset_postdata();
													?>
                                            </div>
											<?php
											$madara_pagination = new App\Views\ParsePagination();
											$madara_pagination->renderPageNavigation( '.c-tabs-item', 'madara-core/content/content-search', $s_query );
											?>
                                    </div>
									<?php
								} else {
									get_template_part( 'madara-core/content/content', 'none' );
								}
							?>
                        </div>

						<?php get_template_part( 'html/main-bodybottom' ); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php

	/**
	 * madara_after_main_page hook
	 *
	 * @hooked madara_output_after_main_page - 90
	 * @hooked madara_output_bottom_sidebar - 91
	 *
	 * @author
	 * @since 1.0
	 * @code     Madara
	 */
	do_action( 'madara_after_main_page' );

	get_footer();
