<?php 
	global $wp_manga_functions;
?>
<div class="manga__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">
	<?php if ( has_post_thumbnail() ) { ?>
		<div class="manga__thumb">
			<div class="manga__thumb_item">
				<a href="<?php echo get_the_permalink() ?>">
					<?php echo get_the_post_thumbnail(get_the_ID(), 'manga-thumb-1' ); ?>
				</a>
			</div>
		</div>
	<?php } ?>

	<div class="manga__content">
		<div class="manga__content_item">
			<div class="post-title font-title">

				<h2>
					<a href="<?php echo get_the_permalink() ?>">
						<?php echo get_the_title(); ?>
					</a>
				</h2>
				<div class="manga-excerpt">            
					<?php 
					global $post;
					echo $post->post_content ? apply_filters('the_excerpt', $post->post_content ) : '';
					?>
				</div>
				<div class="manga-info">
					<?php madara_child_x_print_vote_percentage(get_the_ID());?>
					<?php
						$chapters = $wp_manga_functions->get_chapter( get_the_ID(), false );
						if ($chapters) {
							$total_chaps = $chapters['total_chapters'];
							echo '<span class="total">'. sprintf(esc_html__('%s Chapters',WP_MANGA_X_TEXTDOMAIN), $total_chaps).'</span>';
						}
					?>

				</div>
				<span class="manga-genres">
					<?php 
						$genres = $wp_manga_functions->get_manga_genres(get_the_ID());
						if ($genres) {
							$genres_arr = explode(',', $genres);
							$first_3_genres = array_splice($genres_arr, 0,3);
							foreach ($first_3_genres as $index => $genre) {
								echo '<span class="genre-item"><i class="fas fa-circle"></i>' . $genre.'</span>';
							}
						}
					?>
				</span>
			</div>
		</div>
	</div>
</div>
