<div class="manga__item <?php echo has_post_thumbnail() ? '' : 'no-thumb'; ?>">
	<?php if ( has_post_thumbnail() ) { ?>
		<div class="manga__thumb">
			<div class="manga__thumb_item">
				<a href="<?php echo get_the_permalink() ?>">
					<?php echo get_the_post_thumbnail(get_the_ID(), 'madara_x_slider_2' ); ?>
					<div class="item-overlay"></div>
				</a>
			</div>
		</div>
	<?php } ?>

	<div class="manga__content">
		<div class="manga__content_item">
			<div class="post-title font-title">
				<?php madara_manga_title_badges_html( get_the_ID(), 1 ); ?>

				<h2>
					<a href="<?php echo get_the_permalink() ?>">
						<?php echo get_the_title(); ?>
					</a>
				</h2>
				<span class="manga-genres">
					<?php 
						global $wp_manga_functions;
						$genres = $wp_manga_functions->get_manga_genres(get_the_ID());
						if ($genres) {
							$genres_arr = explode(',', $genres);
							$first_3_genres = array_splice($genres_arr, 0,3);
							foreach ($first_3_genres as $index => $genre) {
								echo '<span class="genre-item"><i class="fas fa-circle"></i>' . $genre.'</span>';
							}
						}
					?>
				</span>
			</div>
		</div>
	</div>

	<?php
	use App\Madara;
	$badge = Madara::getOption('show_chapter_type', 0);
	
	if($badge){ ?>
	<div class="manga__meta">
		<?php    
			if($badge == 1){
				$type = get_post_meta(get_the_ID(), '_wp_manga_chapter_type', true);
				$type_show = $type !== '' ? ($type == 'text' ? esc_html__('Novel', WP_MANGA_X_TEXTDOMAIN) : esc_html__('Video', WP_MANGA_X_TEXTDOMAIN)) : esc_html__('Manga', WP_MANGA_X_TEXTDOMAIN);
			} else {
				global $wp_manga_functions;
				$type_show = $wp_manga_functions->get_manga_type(get_the_ID());
			}
		?>
		<span class="manga-chapter-type"><?php echo $type_show;?></span>
	</div>
	<?php } ?>
</div>
