<?php

	/**
	 *  Sub header Navigation bar
	 */

	use App\Madara;

	global $wp_manga_user_actions;

	$header_bottom_border = Madara::getOption( 'header_bottom_border', 'on' );
	$madara_header_style  = apply_filters( 'madara_header_style', Madara::getOption( 'header_style', 1 ) );
	$sticky_menu          = Madara::getOption( 'nav_sticky', 1 );
	$sticky_navgiation    = Madara::getOption('manga_reading_sticky_navigation', 'on');
	$sticky_reading_header = Madara::getOption( 'manga_reading_sticky_header', '' );
    $header_login_buttons = Madara::getOption('header_disable_login_buttons', 'on');
	$is_manga_reading_page = false;
	
	if( function_exists( 'is_manga_reading_page' ) && is_manga_reading_page() ) {
		$is_manga_reading_page = true;
	}
	
	if ( $is_manga_reading_page && $sticky_reading_header == 'on' ) {
		$sticky_menu = 1;
	}
	
	$wp_manga = madara_get_global_wp_manga();
	
	$user_enabled = ($header_login_buttons == 'on') && ! is_user_logged_in() && get_option( 'users_can_register' );
	$user_manga_logged = is_user_logged_in() && class_exists( 'WP_MANGA' );
	$has_secondary_menu = has_nav_menu( 'secondary_menu' );
	$adult_filter = true;
	if ( $has_secondary_menu || ($user_enabled || $user_manga_logged) || $adult_filter ) {
		?>
        <div class="c-sub-header-nav <?php echo esc_attr($sticky_menu == 0 ? 'hide-sticky-menu' : ''); ?>">
                <div class="c-sub-nav_wrap">
					<?php if ( $user_enabled ) { ?>
                        <div class="c-modal_item">
                            <!-- Button trigger modal -->
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#form-login" class="btn-active-modal"><?php echo esc_html__( 'Sign in', WP_MANGA_X_TEXTDOMAIN ); ?></a>
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#form-sign-up" class="btn-active-modal"><?php echo esc_html__( 'Sign up', WP_MANGA_X_TEXTDOMAIN ); ?></a>
                        </div>
					<?php } elseif ( $user_manga_logged ) {
						$credit_card_link = Madara::getOption('credit_card_link','');						
						?>
                        <div class="c-modal_item">
							<?php
							if($credit_card_link){
								$credit_card_icon = Madara::getOption('credit_card_icon','fas fa-money-check');
								?>
							<a href="<?php echo esc_url($credit_card_link); ?>"><i class="<?php echo esc_attr($credit_card_icon);?>"></i></a>
							<?php }							
								$wp_manga_user_actions->get_user_section( 50, true);
							?>
                        </div>
					<?php }
					?>
                </div>

				<?php if( function_exists('is_manga_reading_page') && is_manga_reading_page() && $sticky_navgiation == 'on' ){ ?>
					<div class="entry-header">
						<?php $wp_manga->manga_nav( 'footer' ); ?>
                    </div>
				<?php } ?>
        </div>

	<?php }
