<?php
	/**
	 * Mobile Navigation Template
	 * @package madara
	 */
    use App\Madara;
    $header_login_buttons = Madara::getOption('header_disable_login_buttons', 'on');
    $user_enabled = ($header_login_buttons == 'on') && ! is_user_logged_in() && get_option( 'users_can_register' );
?>

<div class="mobile-menu menu-collapse off-canvas">
    <div class="close-nav">
        <button class="menu_icon__close">
            <span></span> <span></span>
        </button>
    </div>

	<div id="search-sidebar">
		<form class="manga-search-form search-form ajax" id="blog-post-search" action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
			<input class="manga-search-field" type="text" placeholder="<?php echo esc_html__( 'Search', WP_MANGA_X_TEXTDOMAIN ); ?>" name="s" value="">			
			<button type="submit" class="btn-search"><i class="fas fa-search"></i></button>
			<div class="loader-inner line-scale">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
			<input type="hidden" name="post_type" value="wp-manga"> 
		</form>
	</div>

    <nav class="off-menu">
		<?php
			if ( has_nav_menu( 'mobile_menu' ) ) {

				wp_nav_menu( array(
					'theme_location' => 'mobile_menu',
					'container'      => false,
					'menu_class'     => 'nav navbar-nav main-navbar',
					'walker'         => new App\Plugins\Walker_Nav_Menu\Custom_Walker_Nav_Menu()
				) );

			} else {

				wp_nav_menu( array(
					'theme_location' => 'primary_menu',
					'container'      => false,
					'menu_class'     => 'nav navbar-nav main-navbar',
					'walker'         => new App\Plugins\Walker_Nav_Menu\Custom_Walker_Nav_Menu()
				) );

			}
		?>
    </nav>
	
	<div class="center"><?php madara_adult_filter_button() ;?></div>
</div>