<?php
if ( ! defined( 'WP_MANGA_X_TEXTDOMAIN' ) ) {
	define( 'WP_MANGA_X_TEXTDOMAIN', 'madara-x' );
}

use \App\Madara;

add_action( 'after_setup_theme', 'madara_child_x_add_theme_support' );
function madara_child_x_add_theme_support() {
	load_theme_textdomain( WP_MANGA_X_TEXTDOMAIN, get_template_directory() . '/languages' );
}

	add_action( 'wp_enqueue_scripts', 'madara_scripts_styles_child_theme' );
	function madara_scripts_styles_child_theme() {

		wp_enqueue_style( 'madara-css-child', get_parent_theme_file_uri() . '/style.css', array(
			'bootstrap',
			'slick',
			'slick-theme'
		) );
		
		wp_enqueue_script( 'madara-child-js', get_stylesheet_directory_uri() . '/assets/js/child.js', array('madara-js') );

		$chapter_lightbox = Madara::getOption('chapter_lightbox', 0);
		
		if($chapter_lightbox){
			wp_enqueue_script( 'lightbox', get_parent_theme_file_uri( '/js/lightbox.min.js' ), array( 'jquery' ), '2.11.2', true );
			wp_enqueue_style( 'lightbox', get_parent_theme_file_uri( '/css/lightbox.min.css' ), array(), '2.11.2' );
		}
	}

	add_action('admin_enqueue_scripts', 'madara_admin_scripts_styles_child_theme');
	
	function madara_admin_scripts_styles_child_theme() {
		global $wp_manga;
		
		wp_enqueue_script( 'madara-admin-child-js', get_stylesheet_directory_uri() . '/assets/js/admin-child.js', array( 'jquery' ), '1.7.3', true );
		wp_localize_script('madara-admin-child-js', 'madara_child_x_ajax', array(
			'url' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('childx-nonce')
		));
	}

	/* Disable VC auto-update */
	add_action( 'admin_init', 'madara_vc_disable_update', 9 );
	function madara_vc_disable_update() {
		if ( function_exists( 'vc_license' ) && function_exists( 'vc_updater' ) && ! vc_license()->isActivated() ) {

			remove_filter( 'upgrader_pre_download', array( vc_updater(), 'preUpgradeFilter' ), 10 );
			remove_filter( 'pre_set_site_transient_update_plugins', array(
				vc_updater()->updateManager(),
				'check_update'
			) );

		}
	}
    
    /**
     * does not support Widgets Block Editor yet
     **/
    function madara_theme_support() {
        remove_theme_support( 'widgets-block-editor' );
    }
    add_action( 'after_setup_theme', 'madara_theme_support' );

	//add user menu items
	add_filter('wp_manga_user_menu_before_items', 'wp_manga_user_menu_before_items_callback');
	function wp_manga_user_menu_before_items_callback() { 
		if(class_exists('myCRED_Core')){
			$user_id = get_current_user_id();
			$coin_balance = mycred_get_users_balance( $user_id );
			if ($user_id !== 0) {
				$user_data = get_userdata($user_id);
				$html = '<li class="user-info">' . get_avatar($user_id) . '<span class="info"><span class="user-email">'.$user_data->display_name.'</span></span></li>';
				$html .= '<li class="coins-amount"><a href="' . \App\Madara::getOption('coin_purchase_page','#') . '">' . esc_html__('Coin Shop', WP_MANGA_X_TEXTDOMAIN) . '</a>';
				$html .= '<span>' . esc_html__('Balance: ', WP_MANGA_X_TEXTDOMAIN) . '<span class="amount-coins">' . number_format($coin_balance, 0) . '</span></span>';
				$html .= '</li>';
				
				return $html;
			} 
		}
		
		return '';
	}

	add_filter('madara_user_menu_profile', 'madara_child_x_madara_user_menu_profile');
	function madara_child_x_madara_user_menu_profile($user_menu){
		
		$args = array(
			'meta_key' => '_wp_page_template',
			'meta_value' => 'page-templates/my-bookmark.php'
		);
		$bookmark_page = get_pages($args);
		if($bookmark_page && count($bookmark_page)){
			$new_items = [];
			
			$items = explode('<li', $user_menu);
			foreach($items as $item){
				// remove the Bookmark item
				if(strpos($item, "?tab=bookmark") === false){
					array_push($new_items, $item);
				}
			}
			
			return implode('<li', $new_items);
		}

		return $user_menu;
	}

	add_filter('madara_user_settings_tab_array_compare', 'madara_child_x_madara_user_settings_tab_array_compare');
	function madara_child_x_madara_user_settings_tab_array_compare($tabs){
		$args = array(
			'meta_key' => '_wp_page_template',
			'meta_value' => 'page-templates/my-bookmark.php'
		);
		$bookmark_page = get_pages($args);
		if($bookmark_page && count($bookmark_page)){
			if(isset($tabs['bookmark'])){
				unset($tabs['bookmark']);
			}
		}

		if(class_exists('myCRED_Core')){
			global $wp_manga_user_actions;
			$tabs['balance-history'] = array(
				"url" => $wp_manga_user_actions->get_user_tab_url( 'balance-history' ),
				"icon" => "icon ion-md-folder-open",
				"label" => "Balance History"
			);
		}

		return $tabs;
	}

	//remove chapter listings table heading
	add_filter('wp-manga-shortcode-manga-listing-layout-chapters-header',function($html){
		$html = '<table class="manga-shortcodes manga-chapters-listing"><tbody>';
		return $html;
	});

	//add new thumbnail size
	add_filter( 'madara_thumb_config', 'add_new_thumb_sizes' );
	function add_new_thumb_sizes($availabe_sizes) {
		$availabe_sizes['madara_x_slider_1'] = [250, 500, true, 'Thumb 250x500px', 'This thumb is used for slider Madara X style 1'];
		$availabe_sizes['madara_x_slider_2'] = [450, 450, true, 'Thumb 450x450px', 'This thumb is used for slider Madara X style 2'];
		$availabe_sizes['madara_x_slider_3'] = [550, 315, true, 'Thumb 550x315px', 'This thumb is used for slider Madara X style 3'];

		return $availabe_sizes;
	}

	// load Chapters List of a Manga, and echo
	add_action('wp-manga-chapter-listing-canvas', 'wp_manga_single_manga_info_chapters_canvas');
	function wp_manga_single_manga_info_chapters_canvas( $manga_id ){
		global $wp_manga_functions, $wp_manga_database;
		
		$sort_option = $wp_manga_database->get_sort_setting();
		
		$manga = $wp_manga_functions->get_all_chapters( $manga_id, $sort_option['sort'] );
		
		$current_read_chapter = 0;
		if ( is_user_logged_in() ) {
			$user_id = get_current_user_id();
			$history = madara_get_current_reading_chapter($user_id, $manga_id);
			if($history){
				$current_read_chapter = $history['c'];
			}
		}
		
		global $wp_manga_template;
		include $wp_manga_template->load_template('single/info','chapters_canvas', false);
	}

	function add_custom_query_var($vars) {
		$vars[] = 'release_date';
		return $vars;
	}
	add_filter('query_vars', 'add_custom_query_var');

	add_filter('is_manga_archive', 'madara_child_x_is_manga_archive');
	function madara_child_x_is_manga_archive($is_manga_archive){
		if ( is_tax( 'wp-manga-publisher' )) {
			$is_manga_archive = true;
		}

		return $is_manga_archive;
	}

	add_action( 'admin_init', 'madara_child_x_post_MetaBoxes' );

	if ( ! function_exists( 'madara_child_x_post_MetaBoxes' ) ) {
		function madara_child_x_post_MetaBoxes() {
			$manga_meta_boxes = array(
				'id'       => 'x_childtheme_settings',
				'title'    => esc_html__( 'X Child Theme Settings', WP_MANGA_X_TEXTDOMAIN ),
				'desc'     => '',
				'pages'    => array( 'wp-manga' ),
				'context'  => 'normal',
				'priority' => 'high',
				'fields'   => array(
					array(
						'id'       => 'manga_release_schedule',
						'label'    => esc_html__( 'Release Schedule - Information', WP_MANGA_X_TEXTDOMAIN ),
						'desc'     => esc_html__( 'Show schedule information in Manga Detail page', WP_MANGA_X_TEXTDOMAIN ),
						'std'      => '',
						'type'     => 'text'
					),
					array(
						'id'       => 'manga_release_days',
						'label'    => esc_html__( 'Release Schedule - Days of Week', WP_MANGA_X_TEXTDOMAIN ),
						'desc'     => esc_html__( 'Select which days of week this manga is normally having a new chapter. After that, it will be shown in the [Calendar Manga] page template', WP_MANGA_X_TEXTDOMAIN ),
						'std'      => '',
						'type'     => 'checkbox',
						'choices'  => array(
							array(
								'value' => 1,
								'label' => esc_html__('Monday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 2,
								'label' => esc_html__('Tuesday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 3,
								'label' => esc_html__('Wednesday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 4,
								'label' => esc_html__('Thursday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 5,
								'label' => esc_html__('Friday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 6,
								'label' => esc_html__('Saturday', WP_MANGA_X_TEXTDOMAIN)
							),
							array(
								'value' => 7,
								'label' => esc_html__('Sunday', WP_MANGA_X_TEXTDOMAIN)
							)
						)
					)
				)
			);


			if ( function_exists( 'ot_register_meta_box' ) ) {
				ot_register_meta_box( $manga_meta_boxes );
			}

		}
	}

	// add taxonomy Publisher
	$publisher_slug = isset( $settings['manga_publisher_slug'] ) && $settings['manga_publisher'] != '' ? $settings['manga_publisher'] : 'manga-publisher';
	register_taxonomy( 'wp-manga-publisher', array( 'wp-manga' ), array(
		'hierarchical'      => false,
		'labels'            => array(
			'name'                       => esc_html__( 'Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'singular_name'              => esc_html__( 'Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'menu_name'                  => esc_html__( 'Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'all_items'                  => esc_html__( 'All Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'edit_item'                  => esc_html__( 'Edit Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'view_item'                  => esc_html__( 'View Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'update_item'                => esc_html__( 'Update Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'add_new_item'               => esc_html__( 'Add New Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'new_item_name'              => esc_html__( 'New Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'parent_item'                => esc_html__( 'Parent Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'parent_item_colon'          => esc_html__( 'Parent Manga Publisher:', WP_MANGA_X_TEXTDOMAIN ),
			'search_items'               => esc_html__( 'Search Manga Publisher', WP_MANGA_X_TEXTDOMAIN ),
			'separate_items_with_commas' => esc_html__( 'Separate Publishers with commas', WP_MANGA_X_TEXTDOMAIN ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used publishers', WP_MANGA_X_TEXTDOMAIN ),
		),
		'public'            => true,
		'show_ui'           => true,
		'show_in_menu'      => true,
		'show_admin_column' => true,
		'show_in_rest'      => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => $publisher_slug ),
		'capabilities' => array(
				'manage_terms' => 'manage_categories',
				'edit_terms' => 'manage_categories',
				'delete_terms' => 'manage_categories',
				'assign_terms' => 'edit_posts'
			)
	) );

	// add custon theme options
	if ( ! function_exists( 'ot_settings_id' ) ) {
		function ot_settings_id() {    
		  return apply_filters( 'ot_settings_id', 'option_tree_settings' );
		}
	}
	
	add_filter(ot_settings_id() . '_args', 'child_theme_options');

	function child_theme_options($custom_settings){
		
		$custom_settings['sections'][] = array(
			'id'    => 'child_theme_options',
			'title' => '<i class="fa-cookie-bite"></i>' . esc_html__( 'X Child Theme Options', WP_MANGA_X_TEXTDOMAIN ),
		);

		$custom_settings['settings'][] = array(
			'id'           => 'credit_card_link',
			'label'        => esc_html__( 'Header Icon Button - URL', WP_MANGA_X_TEXTDOMAIN ),
			'desc'			=> esc_html__('URL of the Icon Button on the secondary menu. Enter full URL with https. Leave empty to hide', WP_MANGA_X_TEXTDOMAIN ),
			'type'         => 'text',
			'section'      => 'child_theme_options',
		);

		$custom_settings['settings'][] = array(
			'id'           => 'credit_card_icon',
			'label'        => esc_html__( 'Header Icon Button - Icon', WP_MANGA_X_TEXTDOMAIN ),
			'desc'			=> esc_html__('Icon Class Name for the icon. For example "fas fa-money-check". See icons list here: <a href="https://ionic.io/ionicons/v4/" target="_blank">IonIcons</a><a  target="_blank" href="https://fontawesome.com/icons">
			FontAwesome</a>', WP_MANGA_X_TEXTDOMAIN),
			'type'         => 'text',
			'section'      => 'child_theme_options',
		);
		
		$custom_settings['settings'][] = array(
			'id'           => 'number_chaps_per_slide',
			'label'        => esc_html__( '[Manga Listing Shortcode] Number of items per slide', WP_MANGA_X_TEXTDOMAIN ),
			'desc'			=> esc_html__('The [manga_listing] shortcode with "chapters" layout will be turned into a slider. Use this option to change the number of items per slide for this slider. By default, 10 items per slide', WP_MANGA_X_TEXTDOMAIN ),
			'type'         => 'text',
			'section'      => 'child_theme_options',
		);

		return $custom_settings;
	}

	//add custom query vars to filter search
	add_filter('query_vars', 'registering_custom_query_var');

	function registering_custom_query_var($query_vars)
	{
		$query_vars[] = 'type';
		return $query_vars;
	}

	/**
	 * Get all mangas which will be updated/released on the specific day
	 * @param $requested_release_date string Y-m-d format
	 * @return Array List of Manga Ids array("post_id" => int)
	 */
	function manga_get_mangas_by_chapter_schedule($requested_release_date){
		global $wpdb;

		$sql = $wpdb->prepare("
			SELECT DISTINCT post_id
			FROM {$wpdb->prefix}manga_chapters
			WHERE schedule_time IS NOT NULL
			AND DATE(schedule_time) = %s
		", $requested_release_date);

		$results = $wpdb->get_results($sql, ARRAY_A);

		return $results;
	}

	/**
	 * Get Mangas by Days of Week schedule
	 * @param $days_of_week From 1 to 7
	 *  */	
	function madara_child_x_get_mangas_by_day_release($days_of_week){
		$args = array(
			'post_type' => 'wp-manga',
			'post_status' => 'publish',
			'meta_key' => 'manga_release_days',
			'meta_value' => ':"' . $days_of_week . '";',
			'meta_compare' => 'LIKE',
			'posts_per_page' => -1
		);

		$wp = new WP_Query($args);

		return $wp;
	}

	function madara_child_x_print_vote_percentage($post_id){
		$like_count = get_post_meta($post_id, 'kodex_post_likes_count', true);
		$like_count = $like_count ? $like_count : 0;
		$dislike_count = get_post_meta($post_id, 'kodex_post_dislikes_count', true);
		$dislike_count = $dislike_count ? $dislike_count : 0;
		$percentage = '';
		if($like_count > 0 || $dislike_count > 0){
			$percentage = ($like_count / ($like_count + $dislike_count)) * 100 . '%';
		} else {
			if($like_count > 0){
				$percentage = '100%';
			} elseif($dislike_count > 0){
				$percentage = '0%';
			}
		}
		if($percentage){
		?>
		<i class="fa fa-thumbs-up" aria-hidden="true"></i><span><?php echo $percentage . ' - ';?></span>
		<?php
		}
	}

require 'admin/settings-page.php';
add_action( 'admin_enqueue_scripts', 'madara_child_x_admin_init');
function madara_child_x_admin_init(){
	$license_key = get_option(MADARA_CHILD_X_LICENSE_KEY);
	if ($license_key) {
		
	} else {
		$screen = get_current_screen();            
		if($screen && $screen->id != 'toplevel_page_madara-welcome' && $screen->id != 'themes' && $screen->id != 'settings_page_madara-child-x'){
			// Redirect
			wp_redirect( admin_url( 'options-general.php?page=madara-child-x' ));
		}
	}
}

/**
 * Get Users Payments
 */
if ( ! function_exists( 'madara_child_x_buycred_get_users_payments' ) ) :
	function madara_child_x_buycred_get_users_payments( $user_id = NULL ) {
		$user_id = absint( $user_id );
		if ( $user_id === 0 ) return false;
		
		$args = array(
			'post_type' => 'buycred_payment',
			'post_status' => array('publish'),
			'numberposts' => -1,
			'post_author' => $user_id,
			'orderby' => 'date',
			'order' => 'desc'
		);

		$payments = get_posts($args);

		return $payments;
	}
endif;

add_filter('madara_custom_css', 'madara_child_x_custom_css');
function madara_child_x_custom_css($css){
	$madara             = new App\Madara();
	$madara_option_tree = new App\Config\OptionTree();
	$front_page_custom_colors            = get_post_meta(get_the_ID(), 'custom_colors', true);
		
	if ($front_page_custom_colors == 'off') {
		$main_color          = $madara_option_tree::getOption('main_color', '');
		$link_color_hover    = $madara_option_tree::getOption('link_color_hover', '');
	} else {
		$main_color          = $madara->getOption('main_color', '');
		$link_color_hover    = $madara->getOption('link_color_hover', '');
				
	}

	if($main_color){
		$css .= ':root{--red:' . $main_color . ';';
	}

	if($link_color_hover){
		$css .= '--red-lighter: ' . $link_color_hover . '}';	
	}

	$calendar_items_per_row  = $madara->getOption('calendar_items_per_row', 3);
	$rows = [];
	for($i = 1; $i <= $calendar_items_per_row; $i++){
		$rows[] = '1fr';
	}

	$css .= '@media (min-width:768px) {
		.calendar-manga {
			grid-template-columns: ' . implode(' ', $rows) . ';
		}
	}';
	
	return $css;
}

remove_action('wp-manga-manga-properties', 'wp_manga_single_manga_info_user_rate', 10, 1);
remove_action('wp-manga-manga-properties', 'wp_manga_single_manga_info_genres', 20, 1);
remove_action('wp-manga-manga-status', 'wp_manga_single_manga_user_buttons', 12, 1);
remove_action('wp-manga-manga-properties', 'wp_manga_single_manga_info_tags', 22, 1);

require 'customizer/customizer.php';
require 'shortcodes.php';
require 'sample-data/sample_data.php';