<?php


function madara_child_x_customizer_register( $wp_customize ) {
    $wp_customize->add_section( 'childx' , array(
        'title'      => esc_html__( 'X Child Theme Settings', WP_MANGA_X_TEXTDOMAIN ),
        'priority'   => 30,
    ) );

    $arr_settings = array(
        'credit_card_link' => '',
        'credit_card_icon' => '',
        'number_chaps_per_slide' => '10',
        'chapter_lightbox' => 0,
        'loop_show_chapters' => 0,
        'loop_show_genres' => 1,
        'coin_purchase_page' => '',
        'calendar_schedule_by' => 1,
        'calendar_items_per_row' => 5,
        'show_chapter_type' => 0
    );

    foreach($arr_settings as $key => $def_value){
        $wp_customize->add_setting( $key , array(
            'default'   => $def_value,
            'transport' => 'refresh',
        ) );
    };  

    $section = 'childx';

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'credit_card_link',
            array(
                'label'          => esc_html__( 'Header Icon Button - URL', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'credit_card_link',
                'type'           => 'text',
                'description' => esc_html__('URL of the Icon Button on the secondary menu. Enter full URL with https. Leave empty to hide', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'credit_card_icon',
            array(
                'label'          => esc_html__( 'Header Icon Button - Icon', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'credit_card_icon',
                'type'           => 'text',
                'description' => __('Icon Class Name for the icon. For example "fas fa-money-check". See icons list here: <a href="https://ionic.io/ionicons/v4/" target="_blank">IonIcons</a> and <a  target="_blank" href="https://fontawesome.com/icons">FontAwesome</a>', WP_MANGA_X_TEXTDOMAIN),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'number_chaps_per_slide',
            array(
                'label'          => esc_html__( '[Manga Listing Shortcode] Number of items per slide', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'number_chaps_per_slide',
                'type'           => 'text',
                'description' => esc_html__('The [manga_listing] shortcode with "chapters" layout will be turned into a slider. Use this option to change the number of items per slide for this slider. By default, 10 items per slide', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'chapter_lightbox',
            array(
                'label'          => esc_html__( 'Lightbox Viewer for Image Chapter', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'chapter_lightbox',
                'type'           => 'select',
                'choices' => array(
                    0 => esc_html__( 'Off', 'madara' ),
                    1 => esc_html__( 'On for Mobile', 'madara' ),
                    2 => esc_html__( 'On for All screens', 'madara' ),
				),
                'description' => esc_html__('Enable Lightbox Viewer for Image Chapter', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'show_chapter_type',
            array(
                'label'          => esc_html__( 'Manga Badge', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'show_chapter_type',
                'type'           => 'select',
                'choices' => array(
                    0 => esc_html__( 'Off', 'madara' ),
                    1 => esc_html__( 'Show Chapter Type (Manga, Novel, or Video)', 'madara' ),
                    2 => esc_html__( 'Show Manga Type property', 'madara' ),
				),
                'description' => esc_html__('Show a text badge on each Manga Item in the list', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'loop_show_genres',
            array(
                'label'          => esc_html__( 'Show Genres in the loop', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'loop_show_genres',
                'type'           => 'select',
                'choices' => array(
                    0 => esc_html__( 'Off', 'madara' ),
                    1 => esc_html__( 'On', 'madara' )
				),
                'description' => esc_html__('Turn on/off the Genres for each manga in the list', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'loop_show_chapters',
            array(
                'label'          => esc_html__( 'Show Latest Chapters in the loop', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'loop_show_chapters',
                'type'           => 'select',
                'choices' => array(
                    0 => esc_html__( 'Off', 'madara' ),
                    1 => esc_html__( 'On', 'madara' )
				),
                'description' => esc_html__('The Latest Chapters for each manga are hidden by default according to the Child Theme X design. You can bring it back', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'coin_purchase_page',
            array(
                'label'          => esc_html__( 'MyCred - Coin Shop URL', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'coin_purchase_page',
                'type'           => 'text',
                'description' => esc_html__('URL of the "Coin Shop" if using MyCred & WP Manga Chapter Coin plugins', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );
    
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'calendar_schedule_by',
            array(
                'label'          => esc_html__( '[Calendar Page Template] Schedule Manga By', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'calendar_schedule_by',
                'type'           => 'select',
                'choices' => array(
                    1 => esc_html__( 'Days of Week Manga Meta', 'madara' ),
                    2 => esc_html__( 'WP Manga Chapter Schedule plugin', 'madara' )
				),
                'description' => esc_html__('Choose how to schedule a manga, either by using Manga Meta info or using the WP Manga Chapter Schedule plugin', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    $wp_customize->add_control(
        new Skyrocket_Slider_Custom_Control(
            $wp_customize,
            'calendar_items_per_row',
            array(
                'label'          => esc_html__( '[Calendar Page Template] Items Per Row', WP_MANGA_X_TEXTDOMAIN ),
                'section'        => $section,
                'settings'       => 'calendar_items_per_row',
                'type'           => 'slider_control',
                'input_attrs' => array(
                    'min' => 3,
                    'max' => 6,
                    'step' => 1,
                ),
                'description' => esc_html__('Number of items per row in the Calendar Page Template layout (on wide screens)', WP_MANGA_X_TEXTDOMAIN ),
            )
        )
    );

    
 }

 add_action( 'customize_register', 'madara_child_x_customizer_register' );