<?php

define('MADARA_CHILD_X_ITEM_REFERENCE', 'Madara-Child-X');

define('MADARA_CHILD_X_LICENSE_KEY', 'mangabooth_madara_child_x_license_key');

add_action('admin_menu', 'madara_child_x_license_menu');

function madara_child_x_license_menu()
{
    add_options_page('Madara-Child-X Activation', 'Madara-Child-X License', 'manage_options', 'madara-child-x', 'madara_child_x_license_management_page');
}

function madara_child_x_license_management_page()
{
    echo '<div class="wrap">';
    echo '<h2>' . esc_html__('Madara-Child-X License', 'madara-x') . '</h2>';

    if (isset($_REQUEST['activate_license'])) {
        $license_key = sanitize_text_field($_REQUEST[MADARA_CHILD_X_LICENSE_KEY]);

        // Simulate license activation for testing - accept any key
        echo '<br /> License Activated: ' . esc_html($license_key);

        // Save the license key in the options table
        update_option(MADARA_CHILD_X_LICENSE_KEY, $license_key);
    }

    if (isset($_REQUEST['deactivate_license'])) {
        // Simulate license deactivation for testing
        echo '<br /> License Deactivated.';

        // Remove the license key from the options table
        update_option(MADARA_CHILD_X_LICENSE_KEY, '');
    }
    ?>
    <p><?php esc_html_e( 'Please enter the license key for this product to activate it. You were given a license key when you purchased this item.', 'madara-x' ); ?></p>
    <form action="" method="post">
        <table class="form-table">
            <tr>
                <th style="width:100px;"><label for="<?php echo MADARA_CHILD_X_LICENSE_KEY; ?>">License Key</label></th>
                <td><input class="regular-text" type="text" id="<?php echo MADARA_CHILD_X_LICENSE_KEY; ?>"
                           name="<?php echo MADARA_CHILD_X_LICENSE_KEY; ?>"
                           value="<?php echo esc_attr(get_option(MADARA_CHILD_X_LICENSE_KEY)); ?>"></td>
            </tr>
        </table>
        <p class="submit">
            <input type="submit" name="activate_license" value="Activate" class="button-primary"/>
            <input type="submit" name="deactivate_license" value="Deactivate" class="button"/>
        </p>
    </form>
    <?php
    echo '</div>';
}

function madara_child_x_admin_notice__warning()
{
    $class = 'notice notice-warning is-dismissible';
    $message = sprintf(__('Child theme is not activated, you should activate this plugin to use it,  %1$sactivate.%2$s ', 'madara-x'), '<a href="' . admin_url('options-general.php?page=madara-child-x') . '">', '</a>');

    printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), $message);
}
